/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.core.internal;

import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.eclipse.osee.framework.core.data.ApplicabilityToken;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactReadable;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.TransactionId;
import org.eclipse.osee.framework.core.data.UserId;
import org.eclipse.osee.framework.core.data.UserService;
import org.eclipse.osee.framework.core.data.UserToken;
import org.eclipse.osee.framework.core.enums.CoreArtifactTokens;
import org.eclipse.osee.framework.core.enums.CoreArtifactTypes;
import org.eclipse.osee.framework.core.enums.CoreAttributeTypes;
import org.eclipse.osee.framework.core.enums.CoreBranches;
import org.eclipse.osee.framework.core.enums.CoreUserGroups;
import org.eclipse.osee.framework.core.enums.SystemUser;
import org.eclipse.osee.framework.core.util.OseeInf;
import org.eclipse.osee.framework.jdk.core.type.Id;
import org.eclipse.osee.framework.jdk.core.util.Conditions;
import org.eclipse.osee.framework.jdk.core.util.OseeProperties;
import org.eclipse.osee.orcs.OrcsApi;
import org.eclipse.osee.orcs.core.internal.access.BootstrapUsers;
import org.eclipse.osee.orcs.search.QueryBuilder;
import org.eclipse.osee.orcs.transaction.TransactionBuilder;
import org.eclipse.osee.orcs.transaction.TransactionFactory;

public class CreateSystemBranches {
    private final OrcsApi orcsApi;
    private final TransactionFactory txFactory;
    private final QueryBuilder query;
    private static String RENDERER_IDENTIFIER_CLIENT_SIDE_MS_WORD_EDIT = "org.eclipse.osee.framework.ui.skynet.render.WordTemplateRenderer";
    private static String RENDERER_IDENTIFIER_SERVER_SIDE_MS_WORD_EDIT = "org.eclipse.osee.framework.ui.skynet.render.MSWordRestRenderer";
    private static String RENDERER_IDENTIFIER_TIS = "org.eclipse.osee.framework.ui.skynet.render.TisRenderer";
    private static String RENDERER_IDENTIFIER_WORD = "org.eclipse.osee.framework.ui.skynet.word";
    private static String EDIT_RENDERER_OPTIONS = "{\"ElementType\" : \"Artifact\", \"OutliningOptions\" : [ {\"Outlining\" : true, \"RecurseChildren\" : false, \"HeadingAttributeType\" : \"Name\", \"ArtifactName\" : \"Default\", \"OutlineNumber\" : \"\" }], \"AttributeOptions\" : [{\"AttrType\" : \"Word Template Content\",  \"Label\" : \"\", \"FormatPre\" : \"\", \"FormatPost\" : \"\"}]}";
    private static String MERGE_RENDERER_OPTIONS = "{\"ElementType\" : \"Artifact\", \"OutliningOptions\" : [ {\"Outlining\" : false, \"RecurseChildren\" : false, \"HeadingAttributeType\" : \"Name\", \"ArtifactName\" : \"Default\", \"OutlineNumber\" : \"\" }], \"AttributeOptions\" : [{\"AttrType\" : \"Word Template Content\",  \"Label\" : \"\", \"FormatPre\" : \"\", \"FormatPost\" : \"\"}]}";
    private static String PREVIEW_ALL_NO_ATTR_RENDERER_OPTIONS = "{\"ElementType\" : \"Artifact\", \"OutliningOptions\" : [ {\"Outlining\" : true, \"RecurseChildren\" : false, \"HeadingAttributeType\" : \"Name\", \"ArtifactName\" : \"Default\", \"OutlineNumber\" : \"\" }], \"AttributeOptions\" : [{\"AttrType\" : \"Word Template Content\",  \"Label\" : \"\", \"FormatPre\" : \"\", \"FormatPost\" : \"\"}]}";
    private static String RECURSIVE_NO_ATTR_RENDERER_OPTIONS = "{\"ElementType\" : \"Artifact\", \"OutliningOptions\" : [ {\"Outlining\" : true, \"RecurseChildren\" : true, \"HeadingAttributeType\" : \"Name\", \"ArtifactName\" : \"Default\", \"OutlineNumber\" : \"\" }], \"AttributeOptions\" : [{\"AttrType\" : \"Word Template Content\",  \"Label\" : \"\", \"FormatPre\" : \"\", \"FormatPost\" : \"\"}]}";
    private static String RECURSIVE_RENDERER_OPTIONS = "{\"ElementType\" : \"Artifact\", \"OutliningOptions\" : [ {\"Outlining\" : true, \"RecurseChildren\" : true, \"HeadingAttributeType\" : \"Name\", \"ArtifactName\" : \"Default\", \"OutlineNumber\" : \"\" }], \"AttributeOptions\" : [{\"AttrType\" : \"*\",  \"Label\" : \"\", \"FormatPre\" : \"\", \"FormatPost\" : \"\"}]}";
    private static List<PublishingTemplate> publishingTempaltes = List.of(new PublishingTemplate(CoreArtifactTokens.DocumentTemplates, "WordEditTemplate", EDIT_RENDERER_OPTIONS, "templates/Word Edit Template.xml", List.of(new PublishingTemplateMatchCriterion(RENDERER_IDENTIFIER_CLIENT_SIDE_MS_WORD_EDIT, "SPECIALIZED_EDIT"), new PublishingTemplateMatchCriterion(RENDERER_IDENTIFIER_TIS, "SPECIALIZED_EDIT"))), new PublishingTemplate(CoreArtifactTokens.DocumentTemplates, "WordMergeTemplate", MERGE_RENDERER_OPTIONS, "templates/PREVIEW_ALL.xml", List.of(new PublishingTemplateMatchCriterion(RENDERER_IDENTIFIER_WORD, "MERGE_EDIT"), new PublishingTemplateMatchCriterion(RENDERER_IDENTIFIER_WORD, "MERGE"), new PublishingTemplateMatchCriterion(RENDERER_IDENTIFIER_CLIENT_SIDE_MS_WORD_EDIT, "MERGE"), new PublishingTemplateMatchCriterion(RENDERER_IDENTIFIER_CLIENT_SIDE_MS_WORD_EDIT, "MERGE_EDIT"), new PublishingTemplateMatchCriterion(RENDERER_IDENTIFIER_CLIENT_SIDE_MS_WORD_EDIT, "DIFF THREE_WAY_MERGE"))), new PublishingTemplate(CoreArtifactTokens.DocumentTemplates, "PreviewAll", null, "templates/PREVIEW_ALL.xml", List.of(new PublishingTemplateMatchCriterion(RENDERER_IDENTIFIER_CLIENT_SIDE_MS_WORD_EDIT, "PREVIEW PREVIEW_ARTIFACT"), new PublishingTemplateMatchCriterion(RENDERER_IDENTIFIER_CLIENT_SIDE_MS_WORD_EDIT, "PREVIEW"), new PublishingTemplateMatchCriterion(RENDERER_IDENTIFIER_CLIENT_SIDE_MS_WORD_EDIT, "DIFF"))), new PublishingTemplate(CoreArtifactTokens.DocumentTemplates, "PREVIEW_ALL_NO_ATTRIBUTES", PREVIEW_ALL_NO_ATTR_RENDERER_OPTIONS, "templates/PREVIEW_ALL_NO_ATTRIBUTES.xml", List.of(new PublishingTemplateMatchCriterion(RENDERER_IDENTIFIER_CLIENT_SIDE_MS_WORD_EDIT, "PREVIEW PREVIEW_ALL_NO_ATTRIBUTES"), new PublishingTemplateMatchCriterion(RENDERER_IDENTIFIER_CLIENT_SIDE_MS_WORD_EDIT, "DIFF_NO_ATTRIBUTES"))), new PublishingTemplate(CoreArtifactTokens.DocumentTemplates, "PREVIEW_ALL_RECURSE", RECURSIVE_RENDERER_OPTIONS, "templates/PREVIEW_ALL_RECURSE.xml", List.of(new PublishingTemplateMatchCriterion(RENDERER_IDENTIFIER_CLIENT_SIDE_MS_WORD_EDIT, "PREVIEW PREVIEW_WITH_RECURSE"))), new PublishingTemplate(CoreArtifactTokens.DocumentTemplates, "PREVIEW_ALL_RECURSE_NO_ATTRIBUTES", RECURSIVE_NO_ATTR_RENDERER_OPTIONS, "templates/PREVIEW_ALL_RECURSE_NO_ATTRIBUTES.xml", List.of(new PublishingTemplateMatchCriterion(RENDERER_IDENTIFIER_CLIENT_SIDE_MS_WORD_EDIT, "PREVIEW PREVIEW_WITH_RECURSE_NO_ATTRIBUTES"), new PublishingTemplateMatchCriterion(RENDERER_IDENTIFIER_SERVER_SIDE_MS_WORD_EDIT, "PREVIEW_SERVER PREVIEW_WITH_RECURSE_NO_ATTRIBUTES"))));
    private static final String JSON_ATTR_VALUE = "{ \"WCAFE\" : [{\"TypeId\" : 204509162766372, \"BranchId\" : 1, \"Range\" : [{\"Min\" : 1, \"Max\" : 99}, {\"Min\" : 1001, \"Max\" : 1009}]},{\"TypeId\" : 204509162766372, \"BranchId\" : 61, \"Range\" : [{\"Min\" : 1, \"Max\" : 49}]},{\"TypeId\" : 204509162766372, \"BranchId\" : 714, \"Range\" : [{\"Min\" : 1, \"Max\" : 99}, {\"Min\" : 1001, \"Max\" : 1009}]},{\"TypeId\" : 204509162766373, \"BranchId\" : 1, \"Range\" : [{\"Min\" : 100, \"Max\" : 199}, {\"Min\" : 1100, \"Max\" : 1199}]},{\"TypeId\" : 204509162766373, \"BranchId\" : 61, \"Range\" : [{\"Min\" : 50, \"Max\" : 199}]},{\"TypeId\" : 204509162766373, \"BranchId\" : 714, \"Range\" : [{\"Min\" : 100, \"Max\" : 199}, {\"Min\" : 1100, \"Max\" : 1199}]},{\"TypeId\" : 204509162766374, \"BranchId\" : 1, \"Range\" : [{\"Min\" : 200, \"Max\" : 1000}, {\"Min\" : 1200, \"Max\" : 2000}]},{\"TypeId\" : 204509162766374, \"BranchId\" : 61, \"Range\" : [{\"Min\" : 200, \"Max\" : 1000}, {\"Min\" : 1200, \"Max\" : 2000}]},{\"TypeId\" : 204509162766374, \"BranchId\" : 714, \"Range\" : [{\"Min\" : 200, \"Max\" : 1000}, {\"Min\" : 1200, \"Max\" : 2000}]},{\"TypeId\" : 204509162766370, \"BranchId\" : 1, \"Range\" : [{\"Min\" : 1, \"Max\" : 8191}]},{\"TypeId\" : 204509162766370, \"BranchId\" : 61, \"Range\" : [{\"Min\" : 1, \"Max\" : 8191}]},{\"TypeId\" : 204509162766370, \"BranchId\" : 714, \"Range\" : [{\"Min\" : 1, \"Max\" : 8191}]},{\"TypeId\" : 204509162766371, \"BranchId\" : 1, \"Range\" : [{\"Min\" : 400}]},{\"TypeId\" : 204509162766371, \"BranchId\" : 61, \"Range\" : [{\"Min\" : 400}]},{\"TypeId\" : 204509162766371, \"BranchId\" : 714, \"Range\" : [{\"Min\" : 1}]}]}";
    private static final String JSON_PL_PREFERENCES = "{ \"FileExtensionCommentStyle\" : [\n      { \"FileExtension\" : \"fileApplicability\", \"CommentPrefixRegex\" : \"\", \"CommentSuffixRegex\" : \"\", \"CommentPrefix\" : \"\", \"CommentSuffix\" : \"\"},\n      { \"FileExtension\" : \"txt\", \"CommentPrefixRegex\" : \"\", \"CommentSuffixRegex\" : \"\", \"CommentPrefix\" : \"\", \"CommentSuffix\" : \"\"},\n      { \"FileExtension\" : \"VMF\", \"CommentPrefixRegex\" : \"%\", \"CommentPrefix\" : \"% \" },\n      { \"FileExtension\" : \"mdgsource\", \"CommentPrefixRegex\" : \"\\\\+\\\\.\", \"CommentPrefix\" : \"+. \" },\n      { \"FileExtension\" : \"java\", \"CommentPrefixRegex\" : \"/\\\\*\", \"CommentSuffixRegex\" : \"\\\\*/\", \"CommentPrefix\" : \"/* \", \"CommentSuffix\" : \" */\"},\n      { \"FileExtension\" : \"cpp\", \"CommentPrefixRegex\" : \"//\", \"CommentPrefix\" : \"// \" },\n      { \"FileExtension\" : \"cmd\", \"CommentPrefixRegex\" : \"REM\", \"CommentPrefix\" : \"REM \" },\n      { \"FileExtension\" : \"xml\", \"CommentPrefixRegex\" : \"<!--\", \"CommentSuffixRegex\" : \"-->\", \"CommentPrefix\" : \"<!-- \", \"CommentSuffix\" : \" -->\"},\n      { \"FileExtension\" : \"lst\", \"CommentPrefixRegex\" : \"#\", \"CommentPrefix\" : \"# \" }\n      ]}";

    public CreateSystemBranches(OrcsApi orcsApi) {
        this.orcsApi = orcsApi;
        this.txFactory = orcsApi.getTransactionFactory();
        this.query = orcsApi.getQueryFactory().fromBranch((BranchId)CoreBranches.COMMON);
    }

    public TransactionId create(UserToken superUser) {
        this.orcsApi.getKeyValueOps().putByKey((Id)ApplicabilityToken.BASE, ApplicabilityToken.BASE.getName());
        this.populateSystemBranch();
        this.orcsApi.getBranchOps().createTopLevelBranch(CoreBranches.COMMON);
        return this.populateCommonBranch(superUser);
    }

    private void populateSystemBranch() {
        TransactionBuilder tx = this.txFactory.createTransaction((BranchId)CoreBranches.SYSTEM_ROOT, "Add System Root branch artifacts");
        tx.createArtifact(CoreArtifactTokens.DefaultHierarchyRoot);
        tx.createArtifact(CoreArtifactTokens.UniversalGroupRoot);
        tx.commit();
    }

    private TransactionId populateCommonBranch(UserToken superUser) {
        TransactionBuilder tx = this.txFactory.createTransaction((BranchId)CoreBranches.COMMON, "Add Common branch artifacts");
        this.orcsApi.tokenService().getArtifactTypeJoins().forEach(arg_0 -> ((TransactionBuilder)tx).addOrcsTypeJoin(arg_0));
        this.orcsApi.tokenService().getAttributeTypeJoins().forEach(arg_0 -> ((TransactionBuilder)tx).addOrcsTypeJoin(arg_0));
        this.orcsApi.tokenService().getRelationTypeJoins().forEach(arg_0 -> ((TransactionBuilder)tx).addOrcsTypeJoin(arg_0));
        ArtifactReadable root = (ArtifactReadable)this.query.andIsHeirarchicalRootArtifact().getResults().getExactlyOne();
        ArtifactToken oseeConfig = tx.createArtifact((ArtifactId)root, CoreArtifactTokens.OseeConfiguration);
        ArtifactToken userGroupsFolder = tx.createArtifact((ArtifactId)oseeConfig, CoreArtifactTokens.UserGroups);
        ArtifactToken everyOne = tx.createArtifact((ArtifactId)userGroupsFolder, (ArtifactToken)CoreUserGroups.Everyone);
        tx.setSoleAttributeValue((ArtifactId)everyOne, (AttributeTypeToken)CoreAttributeTypes.DefaultGroup, (Object)true);
        tx.createArtifact((ArtifactId)userGroupsFolder, (ArtifactToken)CoreUserGroups.OseeAdmin);
        tx.createArtifact((ArtifactId)userGroupsFolder, (ArtifactToken)CoreUserGroups.AccountAdmin);
        tx.createArtifact((ArtifactId)userGroupsFolder, (ArtifactToken)CoreUserGroups.OseeAccessAdmin);
        tx.createArtifact((ArtifactId)userGroupsFolder, (ArtifactToken)CoreUserGroups.Publishing);
        ArtifactToken globalPreferences = tx.createArtifact((ArtifactId)oseeConfig, CoreArtifactTokens.GlobalPreferences);
        tx.setSoleAttributeValue((ArtifactId)globalPreferences, (AttributeTypeToken)CoreAttributeTypes.GeneralStringData, (Object)JSON_ATTR_VALUE);
        tx.setSoleAttributeValue((ArtifactId)globalPreferences, (AttributeTypeToken)CoreAttributeTypes.ProductLinePreferences, (Object)JSON_PL_PREFERENCES);
        tx.createArtifact((ArtifactId)oseeConfig, CoreArtifactTokens.XViewerCustomization);
        ArtifactToken documentTemplateFolder = tx.createArtifact((ArtifactId)oseeConfig, CoreArtifactTokens.DocumentTemplates);
        this.createWordTemplates(tx);
        this.createDataRights(tx, (ArtifactId)documentTemplateFolder);
        tx.commit();
        List roles = superUser.getRoles();
        if (!roles.contains(CoreUserGroups.AccountAdmin)) {
            roles.add(CoreUserGroups.AccountAdmin);
        }
        if (!roles.contains(CoreUserGroups.OseeAdmin)) {
            roles.add(CoreUserGroups.OseeAdmin);
        }
        if (!roles.contains(CoreUserGroups.OseeAccessAdmin)) {
            roles.add(CoreUserGroups.OseeAccessAdmin);
        }
        UserToken userWithRoles = UserToken.create((long)superUser.getId(), (String)superUser.getName(), (String)superUser.getEmail(), (String)superUser.getUserId(), (boolean)true, (List)superUser.getLoginIds(), (List)roles);
        UserService userService = this.orcsApi.userService();
        userService.clearCaches();
        HashSet<UserToken> users = new HashSet<UserToken>(SystemUser.values());
        users.remove(userWithRoles);
        Set<UserToken> bootsrapUsers = BootstrapUsers.getBoostrapUsers();
        Conditions.assertFalse((boolean)bootsrapUsers.isEmpty(), (String)"Bootstrap Users should NOT be empty.", (Object[])new Object[0]);
        users.addAll(bootsrapUsers);
        if (!users.contains(userWithRoles)) {
            users.add(userWithRoles);
        }
        OseeProperties.setIsInTest((boolean)true);
        userService.setUserForCurrentThread(UserId.valueOf((ArtifactId)userWithRoles));
        TransactionId txId = userService.createUsers(users, "Create System Users");
        OseeProperties.setIsInTest((boolean)false);
        return txId;
    }

    private void createWordTemplates(TransactionBuilder tx) {
        publishingTempaltes.forEach(publishingTemplate -> publishingTemplate.createPublishingTemplate(tx));
    }

    private void createDataRights(TransactionBuilder tx, ArtifactId documentTemplateFolder) {
        ArtifactToken dataRightsArt = tx.createArtifact(documentTemplateFolder, CoreArtifactTokens.DataRightsFooters);
        tx.createAttribute((ArtifactId)dataRightsArt, (AttributeTypeToken)CoreAttributeTypes.GeneralStringData, (Object)OseeInf.getResourceContents((String)"Unspecified.xml", this.getClass()));
        tx.createAttribute((ArtifactId)dataRightsArt, (AttributeTypeToken)CoreAttributeTypes.GeneralStringData, (Object)OseeInf.getResourceContents((String)"Default.xml", this.getClass()));
        tx.createAttribute((ArtifactId)dataRightsArt, (AttributeTypeToken)CoreAttributeTypes.GeneralStringData, (Object)OseeInf.getResourceContents((String)"GovernmentPurposeRights.xml", this.getClass()));
        tx.createAttribute((ArtifactId)dataRightsArt, (AttributeTypeToken)CoreAttributeTypes.GeneralStringData, (Object)OseeInf.getResourceContents((String)"RestrictedRights.xml", this.getClass()));
    }

    private static class PublishingTemplate {
        private final ArtifactToken parentArtifactToken;
        private final String name;
        private final String rendererOptionsJson;
        private final String templateContentFileName;
        private final List<PublishingTemplateMatchCriterion> matchCriteria;

        public PublishingTemplate(ArtifactToken parentArtifactToken, String name, String rendererOptionsJson, String templateContentFileName, List<PublishingTemplateMatchCriterion> matchCriteria) {
            this.parentArtifactToken = parentArtifactToken;
            this.name = name;
            this.rendererOptionsJson = rendererOptionsJson;
            this.templateContentFileName = templateContentFileName;
            this.matchCriteria = matchCriteria;
        }

        public void createPublishingTemplate(TransactionBuilder tx) {
            ArtifactToken publishingTemplateArtifact = tx.createArtifact((ArtifactId)this.parentArtifactToken, CoreArtifactTypes.RendererTemplateWholeWord, this.name);
            if (Objects.nonNull(this.rendererOptionsJson)) {
                tx.setSoleAttributeValue((ArtifactId)publishingTemplateArtifact, (AttributeTypeToken)CoreAttributeTypes.RendererOptions, (Object)this.rendererOptionsJson);
            }
            if (Objects.nonNull(this.templateContentFileName)) {
                tx.setSoleAttributeValue((ArtifactId)publishingTemplateArtifact, (AttributeTypeToken)CoreAttributeTypes.WholeWordContent, (Object)OseeInf.getResourceContents((String)this.templateContentFileName, this.getClass()));
            }
            if (Objects.nonNull(this.matchCriteria)) {
                this.matchCriteria.forEach(matchCriterion -> matchCriterion.setTemplateMatchCriteria(tx, (ArtifactId)publishingTemplateArtifact));
            }
        }
    }

    private static class PublishingTemplateMatchCriterion {
        private final String rendererIdentifier;
        private final String matchString;

        public PublishingTemplateMatchCriterion(String rendererIdentifier, String matchString) {
            this.rendererIdentifier = rendererIdentifier;
            this.matchString = matchString;
        }

        public void setTemplateMatchCriteria(TransactionBuilder tx, ArtifactId templateArtifact) {
            tx.createAttribute(templateArtifact, (AttributeTypeToken)CoreAttributeTypes.TemplateMatchCriteria, (Object)(String.valueOf(this.rendererIdentifier) + " " + this.matchString));
        }
    }
}

