/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.rest.internal.notify;

import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.util.Conditions;
import org.eclipse.osee.orcs.OrcsApi;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.ServiceReference;
import org.osgi.service.packageadmin.PackageAdmin;

public final class ServiceUtil {
    private ServiceUtil() {
    }

    private static <T> T getService(Class<T> clazz) throws OseeCoreException {
        Bundle bundle = FrameworkUtil.getBundle(ServiceUtil.class);
        Conditions.checkNotNull((Object)bundle, (String)"bundle");
        BundleContext context = bundle.getBundleContext();
        Conditions.checkNotNull((Object)context, (String)"bundleContext");
        ServiceReference reference = context.getServiceReference(clazz);
        Conditions.checkNotNull((Object)reference, (String)"serviceReference");
        Object service = context.getService(reference);
        Conditions.checkNotNull((Object)service, (String)"service");
        return (T)service;
    }

    public static PackageAdmin getPackageAdmin() throws OseeCoreException {
        return ServiceUtil.getService(PackageAdmin.class);
    }

    public static OrcsApi getOrcsApi() {
        return ServiceUtil.getService(OrcsApi.class);
    }
}

