/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.rest.internal.writer;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.osee.framework.core.applicability.FeatureDefinition;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.jdk.core.util.Collections;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.framework.jdk.core.util.io.xml.ExcelXmlWriter;
import org.eclipse.osee.framework.jdk.core.util.io.xml.ISheetWriter;
import org.eclipse.osee.orcs.OrcsApi;

public class ApplicabilityFeatureMatrixGenerator {
    private final OrcsApi orcsApi;

    public ApplicabilityFeatureMatrixGenerator(OrcsApi orcsApi) {
        this.orcsApi = orcsApi;
    }

    public void runOperation(OrcsApi providedOrcs, Writer providedWriter, BranchId branch, String filter) throws IOException {
        ExcelXmlWriter writer = new ExcelXmlWriter(providedWriter);
        this.createConfigSheet((ISheetWriter)writer, branch, filter);
        this.createGroupsSheet((ISheetWriter)writer, branch, filter);
        writer.endWorkbook();
    }

    private void createConfigSheet(ISheetWriter writer, BranchId branch, String filter) throws IOException {
        ArrayList<String> headingsList = new ArrayList<String>();
        headingsList.add("Feature");
        headingsList.add("Description");
        List configurationsForBranch = this.orcsApi.getQueryFactory().applicabilityQuery().getConfigurationsForBranch(branch);
        if (Strings.isValid((String)filter)) {
            configurationsForBranch.removeIf(art -> art.getName().matches(filter));
        }
        for (ArtifactToken art2 : configurationsForBranch) {
            headingsList.add(art2.getName());
        }
        Object[] headings = headingsList.toArray();
        writer.startSheet("Configurations", configurationsForBranch.size() + 2);
        writer.writeRow(headings);
        this.printMatrix(writer, branch, configurationsForBranch);
        writer.endSheet();
    }

    private void createGroupsSheet(ISheetWriter writer, BranchId branch, String filter) throws IOException {
        ArrayList<String> headingsList = new ArrayList<String>();
        headingsList.add("Feature");
        headingsList.add("Description");
        List configurationsForBranch = this.orcsApi.getQueryFactory().applicabilityQuery().getConfigurationGroupsForBranch(branch);
        if (Strings.isValid((String)filter)) {
            configurationsForBranch.removeIf(art -> art.getName().matches(filter));
        }
        for (ArtifactToken art2 : configurationsForBranch) {
            headingsList.add(art2.getName().toString());
        }
        Object[] headings = headingsList.toArray();
        writer.startSheet("Configuration Groups", configurationsForBranch.size() + 2);
        writer.writeRow(headings);
        this.printMatrix(writer, branch, configurationsForBranch);
        writer.endSheet();
    }

    private void printMatrix(ISheetWriter writer, BranchId branch, List<ArtifactToken> configurationsForBranch) throws IOException {
        List featureDefinitionData = this.orcsApi.getQueryFactory().applicabilityQuery().getFeatureDefinitionData(branch);
        java.util.Collections.sort(featureDefinitionData, new Comparator<FeatureDefinition>(){

            @Override
            public int compare(FeatureDefinition obj1, FeatureDefinition obj2) {
                return obj1.getName().compareTo(obj2.getName());
            }
        });
        HashMap<ArtifactId, Map> branchViewsMap = new HashMap<ArtifactId, Map>();
        for (ArtifactId artifactId : configurationsForBranch) {
            branchViewsMap.put(artifactId, this.orcsApi.getQueryFactory().applicabilityQuery().getNamedViewApplicabilityMap(branch, artifactId));
        }
        for (FeatureDefinition featureDefinition : featureDefinitionData) {
            writer.writeCell((Object)featureDefinition.getName());
            writer.writeCell((Object)featureDefinition.getDescription());
            for (ArtifactId artifactId : configurationsForBranch) {
                List list = (List)((Map)branchViewsMap.get(artifactId)).get(featureDefinition.getName());
                if (list != null) {
                    writer.writeCell((Object)Collections.toString((String)",", (Iterable)list));
                    continue;
                }
                writer.writeEmptyCell();
            }
            writer.endRow();
        }
    }
}

