/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.rest.internal;

import java.util.HashSet;
import java.util.Set;
import javax.ws.rs.ApplicationPath;
import javax.ws.rs.core.Application;
import org.eclipse.osee.activity.api.ActivityLog;
import org.eclipse.osee.framework.resource.management.IResourceManager;
import org.eclipse.osee.jdbc.JdbcService;
import org.eclipse.osee.orcs.OrcsApi;
import org.eclipse.osee.orcs.rest.TransactionBuilderMessageReader;
import org.eclipse.osee.orcs.rest.admin.LinkUpdateResource;
import org.eclipse.osee.orcs.rest.internal.BranchEndpointImpl;
import org.eclipse.osee.orcs.rest.internal.BranchesResource;
import org.eclipse.osee.orcs.rest.internal.DatastoreEndpointImpl;
import org.eclipse.osee.orcs.rest.internal.IndexerEndpointImpl;
import org.eclipse.osee.orcs.rest.internal.KeyValueResource;
import org.eclipse.osee.orcs.rest.internal.ReportEndpointImpl;
import org.eclipse.osee.orcs.rest.internal.ResourcesEndpointImpl;
import org.eclipse.osee.orcs.rest.internal.TransactionEndpointImpl;
import org.eclipse.osee.orcs.rest.internal.applicability.ApplicabilityUiEndpointImpl;
import org.eclipse.osee.orcs.rest.internal.types.TypesEndpointImpl;
import org.eclipse.osee.orcs.rest.internal.writer.OrcsWriterEndpointImpl;
import org.osgi.service.event.EventAdmin;

@ApplicationPath(value="orcs")
public class OrcsApplication
extends Application {
    private final Set<Object> singletons = new HashSet<Object>();
    private OrcsApi orcsApi;
    private IResourceManager resourceManager;
    private ActivityLog activityLog;
    private JdbcService jdbcService;

    public void setOrcsApi(OrcsApi orcsApi) {
        this.orcsApi = orcsApi;
    }

    public void setJdbcService(JdbcService jdbcService) {
        this.jdbcService = jdbcService;
    }

    public void setActivityLog(ActivityLog activityLog) {
        this.activityLog = activityLog;
    }

    public void setEventAdmin(EventAdmin eventAdmin) {
    }

    public void setResourceManager(IResourceManager resourceManager) {
        this.resourceManager = resourceManager;
    }

    public void start() {
        this.singletons.add(new BranchesResource(this.orcsApi));
        this.singletons.add(new BranchEndpointImpl(this.orcsApi, this.activityLog));
        this.singletons.add(new ApplicabilityUiEndpointImpl(this.orcsApi));
        this.singletons.add(new OrcsWriterEndpointImpl(this.orcsApi));
        this.singletons.add(new TransactionEndpointImpl(this.orcsApi));
        this.singletons.add(new TypesEndpointImpl(this.orcsApi, this.jdbcService));
        this.singletons.add(new IndexerEndpointImpl(this.orcsApi));
        this.singletons.add(new ResourcesEndpointImpl(this.resourceManager));
        this.singletons.add(new DatastoreEndpointImpl(this.orcsApi, this.activityLog));
        this.singletons.add(new KeyValueResource(this.orcsApi));
        this.singletons.add(new LinkUpdateResource(this.orcsApi));
        this.singletons.add(new ReportEndpointImpl(this.orcsApi));
        this.singletons.add(new TransactionBuilderMessageReader(this.orcsApi));
    }

    public void stop() {
        this.singletons.clear();
    }

    public Set<Object> getSingletons() {
        return this.singletons;
    }
}

