/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.util.widgets;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.osee.ats.api.program.IAtsProgram;
import org.eclipse.osee.ats.ide.config.program.IAtsProgramManager;
import org.eclipse.osee.ats.ide.config.program.ProgramManagers;
import org.eclipse.osee.ats.ide.util.widgets.AtsProgramLabelProvider;
import org.eclipse.osee.ats.ide.util.widgets.AtsProgramViewerSorter;
import org.eclipse.osee.framework.ui.skynet.util.StringNameComparator;
import org.eclipse.osee.framework.ui.skynet.widgets.XComboViewer;
import org.eclipse.swt.widgets.Composite;

public class XAtsProgramComboWidget
extends XComboViewer {
    protected Collection<IAtsProgram> atsPrograms = new ArrayList<IAtsProgram>();

    public XAtsProgramComboWidget(String displayLabel, Collection<IAtsProgram> atsPrograms) {
        super(displayLabel, 8);
        this.atsPrograms = atsPrograms;
        this.setLabelProvider(new AtsProgramLabelProvider());
        this.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.setComparator((ViewerComparator)new StringNameComparator());
    }

    public XAtsProgramComboWidget(Collection<IAtsProgram> atsPrograms) {
        this("ATS Program", atsPrograms);
    }

    public XAtsProgramComboWidget() {
        this("ATS Program", XAtsProgramComboWidget.getAllPrograms());
    }

    private static Collection<IAtsProgram> getAllPrograms() {
        ArrayList<IAtsProgram> programs = new ArrayList<IAtsProgram>();
        for (IAtsProgramManager manager : ProgramManagers.getAtsProgramManagers()) {
            programs.addAll(manager.getPrograms());
        }
        return programs;
    }

    protected void createControls(Composite parent, int horizontalSpan) {
        super.createControls(parent, horizontalSpan);
        this.setComparator((ViewerComparator)new AtsProgramViewerSorter());
        this.reload();
    }

    public void reload() {
        ArrayList<IAtsProgram> objs = new ArrayList<IAtsProgram>();
        for (IAtsProgram proj : this.atsPrograms) {
            objs.add(proj);
        }
        this.setInput(objs);
    }
}

