/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.util;

import org.eclipse.osee.ats.api.IAtsWorkItem;
import org.eclipse.osee.ats.api.data.AtsAttributeTypes;
import org.eclipse.osee.ats.api.util.IAtsChangeSet;
import org.eclipse.osee.ats.ide.editor.WorkflowEditor;
import org.eclipse.osee.ats.ide.workflow.AbstractWorkflowArtifact;
import org.eclipse.osee.framework.core.data.AttributeTypeId;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.util.Result;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.framework.skynet.core.artifact.Artifact;
import org.eclipse.osee.framework.ui.skynet.widgets.ArtifactWidget;
import org.eclipse.osee.framework.ui.skynet.widgets.XText;
import org.eclipse.osee.framework.ui.swt.Widgets;
import org.eclipse.swt.widgets.Widget;

public class XCancellationReasonTextWidget
extends XText
implements ArtifactWidget {
    private AbstractWorkflowArtifact awa;

    public XCancellationReasonTextWidget(AbstractWorkflowArtifact sma, WorkflowEditor editor) {
        super("Cancellation Reason");
        this.setArtifact(sma);
    }

    public Result isDirty() {
        if (!Widgets.isAccessible((Widget)this.getControl())) {
            return Result.FalseResult;
        }
        if (!this.getText().equals(this.awa.getCancelledReason())) {
            return new Result(true, "Cancellation Reason dirty");
        }
        return Result.FalseResult;
    }

    public void revert() {
    }

    public void saveToArtifact() {
        if (Strings.isValid((String)this.getText())) {
            this.setCancellationReason(this.getText(), null);
        }
    }

    public void setArtifact(Artifact artifact) {
        if (artifact instanceof AbstractWorkflowArtifact) {
            this.awa = (AbstractWorkflowArtifact)artifact;
            this.refresh();
        }
    }

    public AbstractWorkflowArtifact getArtifact() {
        return this.awa;
    }

    public void refresh() {
        this.setText(this.awa.getCancelledReason());
    }

    public void setCancellationReason(String reason, IAtsChangeSet changes) {
        if (changes == null) {
            this.awa.setSoleAttributeValue((AttributeTypeId)AtsAttributeTypes.CancelledReason, reason);
        } else {
            changes.setSoleAttributeValue((IAtsWorkItem)this, (AttributeTypeToken)AtsAttributeTypes.CancelledReason, reason);
        }
    }
}

