/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.util;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import org.eclipse.osee.ats.api.data.AtsArtifactTypes;
import org.eclipse.osee.ats.api.util.AtsUtil;
import org.eclipse.osee.ats.api.workflow.transition.TransitionResult;
import org.eclipse.osee.ats.api.workflow.transition.TransitionResults;
import org.eclipse.osee.ats.api.workflow.transition.TransitionWorkItemResult;
import org.eclipse.osee.ats.ide.internal.Activator;
import org.eclipse.osee.ats.ide.internal.AtsApiService;
import org.eclipse.osee.framework.core.data.ArtifactTypeToken;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.framework.logging.OseeLog;
import org.eclipse.osee.framework.skynet.core.event.filter.ArtifactTypeEventFilter;
import org.eclipse.osee.framework.skynet.core.event.filter.BranchIdEventFilter;
import org.eclipse.osee.framework.skynet.core.event.filter.IEventFilter;
import org.eclipse.osee.framework.skynet.core.topic.event.filter.ArtifactTopicTypeEventFilter;
import org.eclipse.osee.framework.skynet.core.topic.event.filter.BranchIdTopicEventFilter;
import org.eclipse.osee.framework.skynet.core.topic.event.filter.ITopicEventFilter;
import org.eclipse.osee.framework.skynet.core.utility.DbUtil;

public class AtsUtilClient {
    private static ArtifactTypeEventFilter atsObjectArtifactTypesFilter = new ArtifactTypeEventFilter(new ArtifactTypeToken[]{AtsArtifactTypes.TeamWorkflow, AtsArtifactTypes.Action, AtsArtifactTypes.Task, AtsArtifactTypes.Goal, AtsArtifactTypes.AgileSprint, AtsArtifactTypes.PeerToPeerReview, AtsArtifactTypes.DecisionReview, AtsArtifactTypes.Version});
    private static ArtifactTypeEventFilter reviewArtifactTypesFilter = new ArtifactTypeEventFilter(new ArtifactTypeToken[]{AtsArtifactTypes.PeerToPeerReview, AtsArtifactTypes.DecisionReview});
    private static ArtifactTypeEventFilter teamWorkflowArtifactTypesFilter = new ArtifactTypeEventFilter(new ArtifactTypeToken[]{AtsArtifactTypes.TeamWorkflow});
    private static ArtifactTopicTypeEventFilter atsTopicObjectArtifactTypesFilter = new ArtifactTopicTypeEventFilter(new ArtifactTypeToken[]{AtsArtifactTypes.TeamWorkflow, AtsArtifactTypes.Action, AtsArtifactTypes.Task, AtsArtifactTypes.Goal, AtsArtifactTypes.AgileSprint, AtsArtifactTypes.PeerToPeerReview, AtsArtifactTypes.DecisionReview, AtsArtifactTypes.Version});
    private static ArtifactTopicTypeEventFilter reviewTopicArtifactTypesFilter = new ArtifactTopicTypeEventFilter(new ArtifactTypeToken[]{AtsArtifactTypes.PeerToPeerReview, AtsArtifactTypes.DecisionReview});
    private static ArtifactTopicTypeEventFilter teamWorkflowTopicArtifactTypesFilter = new ArtifactTopicTypeEventFilter(new ArtifactTypeToken[]{AtsArtifactTypes.TeamWorkflow});
    private static List<IEventFilter> atsObjectEventFilter = new ArrayList<IEventFilter>(2);
    private static List<ITopicEventFilter> atsTopicObjectEventFilter = new ArrayList<ITopicEventFilter>(2);
    private static boolean emailEnabled = true;
    private static BranchIdEventFilter commonBranchIdEventFilter = new BranchIdEventFilter((BranchId)AtsApiService.get().getAtsBranch());
    private static BranchIdTopicEventFilter commonBranchTopicIdEventFilter = new BranchIdTopicEventFilter((BranchId)AtsApiService.get().getAtsBranch());

    public static boolean isEmailEnabled() {
        return emailEnabled;
    }

    public static void setEmailEnabled(boolean enabled) {
        if (!DbUtil.isDbInit() && !AtsUtil.isInTest()) {
            OseeLog.log(Activator.class, (Level)Level.INFO, (String)("Email " + (enabled ? "Enabled" : "Disabled")));
        }
        emailEnabled = enabled;
    }

    public static BranchIdEventFilter getAtsBranchFilter() {
        return commonBranchIdEventFilter;
    }

    public static BranchIdTopicEventFilter getAtsTopicBranchFilter() {
        return commonBranchTopicIdEventFilter;
    }

    public static synchronized List<IEventFilter> getAtsObjectEventFilters() {
        try {
            if (atsObjectEventFilter.isEmpty()) {
                atsObjectEventFilter.add((IEventFilter)AtsUtilClient.getAtsBranchFilter());
                atsObjectEventFilter.add((IEventFilter)AtsUtilClient.getAtsObjectArtifactTypeEventFilter());
            }
        }
        catch (Exception ex) {
            OseeLog.log(Activator.class, (Level)Level.SEVERE, (Throwable)ex);
        }
        return atsObjectEventFilter;
    }

    public static synchronized List<ITopicEventFilter> getAtsTopicObjectEventFilters() {
        try {
            if (atsTopicObjectEventFilter.isEmpty()) {
                atsTopicObjectEventFilter.add((ITopicEventFilter)AtsUtilClient.getAtsTopicBranchFilter());
                atsTopicObjectEventFilter.add((ITopicEventFilter)AtsUtilClient.getAtsTopicObjectArtifactTypeEventFilter());
            }
        }
        catch (Exception ex) {
            OseeLog.log(Activator.class, (Level)Level.SEVERE, (Throwable)ex);
        }
        return atsTopicObjectEventFilter;
    }

    public static ArtifactTypeEventFilter getAtsObjectArtifactTypeEventFilter() {
        return atsObjectArtifactTypesFilter;
    }

    public static ArtifactTypeEventFilter getTeamWorkflowArtifactTypeEventFilter() {
        return teamWorkflowArtifactTypesFilter;
    }

    public static ArtifactTypeEventFilter getReviewArtifactTypeEventFilter() {
        return reviewArtifactTypesFilter;
    }

    public static ArtifactTopicTypeEventFilter getAtsTopicObjectArtifactTypeEventFilter() {
        return atsTopicObjectArtifactTypesFilter;
    }

    public static ArtifactTopicTypeEventFilter getTeamWorkflowTopicArtifactTypeEventFilter() {
        return teamWorkflowTopicArtifactTypesFilter;
    }

    public static ArtifactTopicTypeEventFilter getReviewTopicArtifactTypeEventFilter() {
        return reviewTopicArtifactTypesFilter;
    }

    public static void logExceptions(TransitionResults transResult) {
        for (TransitionResult result : transResult.getResults()) {
            String ex = result.getException();
            if (!Strings.isValid((String)ex)) continue;
            OseeLog.log(TransitionResults.class, (Level)Level.SEVERE, (String)(String.valueOf(result.getDetails()) + "\n\n" + ex));
        }
        for (TransitionWorkItemResult transitionWorkItemResult : transResult.getTransitionWorkItems()) {
            for (TransitionResult result : transitionWorkItemResult.getResults()) {
                String ex = result.getException();
                if (!Strings.isValid((String)ex)) continue;
                String message = String.valueOf(transitionWorkItemResult.getWorkItemId().toStringWithId()) + " - " + result.getDetails();
                OseeLog.log(TransitionResults.class, (Level)Level.SEVERE, (String)(String.valueOf(message) + "\n\n" + ex));
            }
        }
    }
}

