/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.search.widget;

import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.osee.ats.api.util.AttributeValue;
import org.eclipse.osee.ats.api.util.AttributeValues;
import org.eclipse.osee.ats.ide.internal.Activator;
import org.eclipse.osee.ats.ide.internal.AtsApiService;
import org.eclipse.osee.ats.ide.search.AttributeTypeFilteredDialog;
import org.eclipse.osee.ats.ide.search.widget.EntryEnumDialog;
import org.eclipse.osee.ats.ide.world.WorldEditor;
import org.eclipse.osee.ats.ide.world.WorldEditorWidget;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.logging.OseeLog;
import org.eclipse.osee.framework.ui.plugin.util.AWorkbench;
import org.eclipse.osee.framework.ui.skynet.FrameworkImage;
import org.eclipse.osee.framework.ui.skynet.artifact.prompt.StringHandlePromptChange;
import org.eclipse.osee.framework.ui.skynet.widgets.XWidget;
import org.eclipse.osee.framework.ui.swt.ALayout;
import org.eclipse.osee.framework.ui.swt.Displays;
import org.eclipse.osee.framework.ui.swt.FontManager;
import org.eclipse.osee.framework.ui.swt.ImageManager;
import org.eclipse.osee.framework.ui.swt.KeyedImage;
import org.eclipse.osee.framework.ui.swt.Widgets;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.Hyperlink;

public class XDynamicAttrValuesWidget
extends XWidget
implements WorldEditorWidget {
    private Label label;
    private AttributeValues attrValues = new AttributeValues();
    private Composite comp;
    private final Map<AttributeTypeToken, Hyperlink> attrTypeToValuesLabel = new HashMap<AttributeTypeToken, Hyperlink>();
    private final Map<AttributeTypeToken, Composite> attrTypeToComp = new HashMap<AttributeTypeToken, Composite>();
    private WorldEditor editor;
    private Composite attrComp;

    public XDynamicAttrValuesWidget() {
        super("Attribute Values");
    }

    public Control getControl() {
        return null;
    }

    protected void createControls(Composite parent, int horizontalSpan) {
        this.comp = new Composite(parent, 0);
        GridData gd = new GridData(768);
        this.comp.setLayoutData((Object)gd);
        this.comp.setLayout((Layout)ALayout.getZeroMarginLayout((int)1, (boolean)false));
        this.comp.setBackground(parent.getBackground());
        Composite labelComp = new Composite(this.comp, 0);
        GridData layoutData = new GridData(16384, 0, false, false);
        layoutData.horizontalSpan = 2;
        labelComp.setLayoutData((Object)layoutData);
        labelComp.setLayout((Layout)ALayout.getZeroMarginLayout((int)2, (boolean)false));
        labelComp.setBackground(parent.getBackground());
        this.label = new Label(labelComp, 0);
        this.label.setText("Attribute Values: ");
        this.label.setBackground(Displays.getSystemColor((int)1));
        this.label.setToolTipText("Select \"Add\" to include other attribute types and their values in search criteria.");
        Hyperlink link = this.toolkit.createHyperlink(labelComp, "Add", 0);
        link.setToolTipText("Select \"Add\" to include other attribute types and their values in search criteria.");
        link.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                ArrayList<AttributeTypeToken> searchableAttrTypes = new ArrayList<AttributeTypeToken>();
                for (AttributeTypeToken type : AtsApiService.get().tokenService().getAttributeTypes()) {
                    if (!type.isTaggable()) continue;
                    searchableAttrTypes.add(type);
                }
                AttributeTypeFilteredDialog diag = new AttributeTypeFilteredDialog(org.eclipse.osee.framework.jdk.core.util.Collections.castAll(searchableAttrTypes));
                if (diag.open() == 0) {
                    if (diag.isNonExists()) {
                        XDynamicAttrValuesWidget.this.attrValues.addAttrValue(diag.getSelectedElement(), true);
                    } else {
                        XDynamicAttrValuesWidget.this.attrValues.addAttrValue((AttributeTypeToken)diag.getSelected(), new String[0]);
                    }
                    XDynamicAttrValuesWidget.this.createUpdateAttached();
                }
            }
        });
        this.createUpdateAttached();
    }

    private void createUpdateAttached() {
        for (Map.Entry<AttributeTypeToken, Composite> attrVal : this.attrTypeToComp.entrySet()) {
            Composite comp = attrVal.getValue();
            if (!Widgets.isAccessible((Widget)comp)) continue;
            comp.dispose();
        }
        if (!Widgets.isAccessible((Widget)this.attrComp)) {
            this.attrComp = new Composite(this.comp, 0);
            GridData gd = new GridData(768);
            gd.horizontalIndent = 30;
            this.attrComp.setLayoutData((Object)gd);
            this.attrComp.setLayout((Layout)ALayout.getZeroMarginLayout((int)2, (boolean)false));
            this.attrComp.setBackground(this.comp.getBackground());
        }
        List attrVals = this.attrValues.getAttributes();
        for (AttributeValue attrValue : attrVals) {
            try {
                Composite lComp = new Composite(this.attrComp, 0);
                this.attrTypeToComp.put(attrValue.getAttrType(), lComp);
                lComp.setLayout((Layout)new GridLayout(3, false));
                GridData gd = new GridData(768);
                lComp.setLayoutData((Object)gd);
                lComp.setBackground(this.attrComp.getBackground());
                Label typeLabel = new Label(lComp, 0);
                typeLabel.setText(String.valueOf(attrValue.getAttrType().getName()) + ":   ");
                typeLabel.setFont(FontManager.getCourierNew12Bold());
                typeLabel.setBackground(this.attrComp.getBackground());
                final AttributeValue fAttrValue = attrValue;
                if (attrValue.isNotExists()) {
                    this.toolkit.createLabel(lComp, "does not exist");
                    this.attrTypeToValuesLabel.put(attrValue.getAttrType(), null);
                } else {
                    Hyperlink valuesLink = this.toolkit.createHyperlink(lComp, "select to set values", 0);
                    valuesLink.setToolTipText("select to set values");
                    valuesLink.setBackground(this.attrComp.getBackground());
                    if (attrValue.hasValues()) {
                        valuesLink.setText((String)attrValue.getValues().iterator().next());
                    }
                    valuesLink.addListener(4, new Listener(){

                        public void handleEvent(Event event) {
                            XDynamicAttrValuesWidget.this.handleEditValues(fAttrValue);
                        }
                    });
                    this.attrTypeToValuesLabel.put(attrValue.getAttrType(), valuesLink);
                }
                Label deleteLabel = new Label(lComp, 0);
                deleteLabel.setImage(ImageManager.getImage((KeyedImage)FrameworkImage.X_RED));
                deleteLabel.setBackground(this.attrComp.getBackground());
                deleteLabel.addListener(4, new Listener(){

                    public void handleEvent(Event event) {
                        XDynamicAttrValuesWidget.this.handleDeleteEntry(fAttrValue);
                    }
                });
            }
            catch (Exception ex) {
                OseeLog.log(Activator.class, (Level)Level.WARNING, (String)("Error showing value " + attrValue.toString()), (Throwable)ex);
            }
        }
        this.updateLayout();
    }

    private void updateLayout() {
        this.comp.layout(true, true);
        this.comp.getParent().layout(true, true);
        if (this.editor != null) {
            this.editor.reflowParameterSection();
        }
    }

    private void handleDeleteEntry(AttributeValue attrValue) {
        this.attrValues.getAttributes().remove(attrValue);
        this.createUpdateAttached();
    }

    private void handleEditValues(AttributeValue attrValue) {
        AttributeTypeToken attrType = attrValue.getAttrType();
        String asFormatType = "String";
        if (attrType.isEnumerated()) {
            EntryEnumDialog diag = new EntryEnumDialog("Enter Enumeration", "Enter Enumeration", attrType);
            if (diag.open() == 0) {
                String value = diag.getEntry();
                this.setAttrValueAndUpdateLink(attrValue, attrType, value);
            }
        } else if (attrType.isArtifactId() || attrType.isString() || attrType.isDouble() || attrType.isInteger() || attrType.isLong()) {
            NumberFormat numFormat = null;
            if (attrType.isDouble()) {
                asFormatType = "Double";
                numFormat = NumberFormat.getInstance();
            } else if (attrType.isInteger()) {
                asFormatType = "Integer";
                numFormat = NumberFormat.getIntegerInstance();
            } else if (attrType.isLong()) {
                asFormatType = "Long";
                numFormat = NumberFormat.getNumberInstance();
            } else if (attrType.isArtifactId()) {
                asFormatType = "ArtifactId (Long)";
                numFormat = NumberFormat.getNumberInstance();
            } else if (attrType.isBranchId()) {
                asFormatType = "BranchId (Long)";
                numFormat = NumberFormat.getNumberInstance();
            }
            StringHandlePromptChange prompt = new StringHandlePromptChange(attrType, false, String.valueOf(attrType.getName()) + "\n\nAs " + asFormatType, Collections.emptyList(), numFormat);
            if (!attrValue.getValues().isEmpty()) {
                prompt.setInitialValue((String)attrValue.getValues().iterator().next());
            }
            if (prompt.promptOk()) {
                String value = prompt.getEntry();
                this.setAttrValueAndUpdateLink(attrValue, attrType, value);
            }
        } else if (attrType.isBoolean()) {
            asFormatType = "Boolean";
            String[] buttonLabels = new String[]{"true", "false", "Cancel"};
            MessageDialog dialog = new MessageDialog(Displays.getActiveShell(), attrType.getName(), null, String.valueOf(attrType.getName()) + "\n\nAs " + asFormatType, 3, 3, buttonLabels);
            int selectedNum = dialog.open();
            if (selectedNum == 0) {
                this.setAttrValueAndUpdateLink(attrValue, attrType, "true");
            } else if (selectedNum == 1) {
                this.setAttrValueAndUpdateLink(attrValue, attrType, "false");
            }
        } else {
            AWorkbench.popup((String)String.format("Unhandled Attr Type %s", attrType.toStringWithId()));
        }
    }

    private void setAttrValueAndUpdateLink(AttributeValue attrValue, AttributeTypeToken attrType, String value) {
        attrValue.setValues(org.eclipse.osee.framework.jdk.core.util.Collections.asList((Object[])new String[]{value}));
        Hyperlink hyperLinkLabel = this.attrTypeToValuesLabel.get(attrType);
        hyperLinkLabel.setText(value);
        this.updateLayout();
    }

    public void refresh() {
        if (Widgets.isAccessible((Widget)this.comp)) {
            this.createUpdateAttached();
        }
    }

    public void setFocus() {
    }

    public boolean isEmpty() {
        return false;
    }

    public AttributeValues getAttrValues() {
        return this.attrValues;
    }

    public void setAttrValues(AttributeValues attrValues) {
        this.attrValues = attrValues;
        this.refresh();
    }

    @Override
    public void setEditor(WorldEditor editor) {
        this.editor = editor;
    }
}

