/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.search.widget;

import java.util.HashSet;
import org.eclipse.osee.ats.api.AtsApi;
import org.eclipse.osee.ats.ide.internal.AtsApiService;
import org.eclipse.osee.framework.core.data.ArtifactTypeToken;
import org.eclipse.osee.framework.core.data.AttributeTypeEnum;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.enums.EnumToken;
import org.eclipse.osee.framework.ui.skynet.widgets.dialog.EntryDialog;
import org.eclipse.osee.framework.ui.skynet.widgets.dialog.FilteredListEnumDialog;
import org.eclipse.osee.framework.ui.swt.ALayout;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class EntryEnumDialog
extends EntryDialog {
    private final AttributeTypeToken attrType;
    private final AtsApi atsApi;

    public EntryEnumDialog(String dialogTitle, String dialogMessage, AttributeTypeToken attrType) {
        super(dialogTitle, dialogMessage);
        this.attrType = attrType;
        this.atsApi = AtsApiService.get();
    }

    protected void createExtendedArea(Composite parent) {
        new Label(parent, 0).setText(" ");
        Composite comp = new Composite(parent, 0);
        comp.setLayoutData((Object)new GridData());
        comp.setLayout((Layout)ALayout.getZeroMarginLayout((int)2, (boolean)false));
        Button enumValues = new Button(comp, 8);
        enumValues.setText("Show Active Enum Values");
        enumValues.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                HashSet enums = new HashSet();
                AttributeTypeEnum enumeratedType = (AttributeTypeEnum)EntryEnumDialog.this.atsApi.tokenService().getAttributeType(EntryEnumDialog.this.attrType.getId());
                for (ArtifactTypeToken art : EntryEnumDialog.this.atsApi.tokenService().getArtifactTypes()) {
                    enums.addAll(art.getValidEnumValues(enumeratedType));
                }
                FilteredListEnumDialog diag = new FilteredListEnumDialog("Select Enum", "Select Enum", enums);
                if (diag.open() == 0) {
                    EnumToken selected = (EnumToken)diag.getSelected();
                    EntryEnumDialog.this.setEntry(selected.getName());
                }
            }
        });
    }
}

