/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.agile;

import java.util.LinkedList;
import java.util.List;
import org.eclipse.nebula.widgets.xviewer.XViewer;
import org.eclipse.nebula.widgets.xviewer.XViewerSorter;
import org.eclipse.nebula.widgets.xviewer.core.model.CustomizeData;
import org.eclipse.nebula.widgets.xviewer.core.model.XViewerColumn;
import org.eclipse.osee.ats.api.column.AtsColumnTokens;
import org.eclipse.osee.ats.ide.agile.AgileFeatureGroupColumn;
import org.eclipse.osee.ats.ide.agile.SprintOrderColumn;
import org.eclipse.osee.ats.ide.column.AgileTeamPointsColumnUI;
import org.eclipse.osee.ats.ide.column.AssigneeColumnUI;
import org.eclipse.osee.ats.ide.column.ChangeTypeColumnUI;
import org.eclipse.osee.ats.ide.column.CreatedDateColumnUI;
import org.eclipse.osee.ats.ide.column.TargetedVersionColumnUI;
import org.eclipse.osee.ats.ide.util.xviewer.column.XViewerAtsAttributeValueColumn;
import org.eclipse.osee.ats.ide.workflow.priority.PriorityColumnUI;
import org.eclipse.osee.ats.ide.workflow.sprint.SprintArtifact;
import org.eclipse.osee.ats.ide.world.WorldXViewerFactory;
import org.eclipse.osee.ats.ide.world.WorldXViewerSorter;
import org.eclipse.osee.ats.ide.world.WorldXViewerUtil;
import org.eclipse.osee.framework.ui.skynet.widgets.xviewer.IOseeTreeReportProvider;
import org.eclipse.osee.framework.ui.skynet.widgets.xviewer.skynet.SkynetXViewerFactory;

public class SprintXViewerFactory
extends SkynetXViewerFactory {
    private final SprintArtifact soleSprintArtifact;
    private static String NAMESPACE = "SprintXViewer";

    public SprintXViewerFactory(SprintArtifact soleSprintArtifact, IOseeTreeReportProvider reportProvider) {
        super(NAMESPACE, reportProvider);
        this.soleSprintArtifact = soleSprintArtifact;
        List<XViewerAtsAttributeValueColumn> configCols = WorldXViewerUtil.getConfigurationColumns();
        LinkedList<XViewerColumn> sprintCols = new LinkedList<XViewerColumn>();
        WorldXViewerUtil.addColumn(this, SprintOrderColumn.getInstance(), 45, sprintCols);
        WorldXViewerUtil.addColumn(this, new XViewerAtsAttributeValueColumn(AtsColumnTokens.TitleColumn), 339, sprintCols);
        WorldXViewerUtil.addColumn(this, AgileTeamPointsColumnUI.getInstance(), AtsColumnTokens.AgileTeamPointsColumn.getWidth(), sprintCols);
        WorldXViewerUtil.addColumn(this, WorldXViewerFactory.getColumnServiceColumn(AtsColumnTokens.StateColumn), 74, sprintCols);
        WorldXViewerUtil.addColumn(this, PriorityColumnUI.getInstance(), 20, sprintCols);
        WorldXViewerUtil.addColumn(this, ChangeTypeColumnUI.getInstance(), 20, sprintCols);
        WorldXViewerUtil.addColumn(this, AssigneeColumnUI.getInstance(), 113, sprintCols);
        XViewerColumn unPlannedWorkColumn = WorldXViewerUtil.getConfigColumn("ats.Unplanned Work", configCols);
        if (unPlannedWorkColumn != null) {
            WorldXViewerUtil.addColumn(this, unPlannedWorkColumn, 40, sprintCols);
        } else {
            WorldXViewerUtil.addColumn(this, new XViewerAtsAttributeValueColumn(AtsColumnTokens.UnPlannedWorkColumn), 40, sprintCols);
        }
        WorldXViewerUtil.addColumn(this, TargetedVersionColumnUI.getInstance(), 50, sprintCols);
        WorldXViewerUtil.addColumn(this, AgileFeatureGroupColumn.getInstance(), 91, sprintCols);
        WorldXViewerUtil.addColumn(this, CreatedDateColumnUI.getInstance(), 82, sprintCols);
        WorldXViewerUtil.addColumn(this, WorldXViewerFactory.getColumnServiceColumn(AtsColumnTokens.AtsIdColumnShow), 50, sprintCols);
        XViewerColumn[] xViewerColumnArray = WorldXViewerFactory.getWorldViewColumns();
        int n = xViewerColumnArray.length;
        int n2 = 0;
        while (n2 < n) {
            XViewerColumn worldCol = xViewerColumnArray[n2];
            if (!sprintCols.contains(worldCol)) {
                XViewerColumn newCol = worldCol.copy();
                newCol.setShow(false);
                this.registerColumns(new XViewerColumn[]{newCol});
            }
            ++n2;
        }
        WorldXViewerUtil.registerAtsAttributeColumns(this);
        WorldXViewerUtil.registerPluginColumns(this);
        for (XViewerAtsAttributeValueColumn col : configCols) {
            this.registerColumns(new XViewerColumn[]{col});
        }
    }

    public XViewerSorter createNewXSorter(XViewer xViewer) {
        return new WorldXViewerSorter(xViewer);
    }

    public CustomizeData getDefaultTableCustomizeData() {
        CustomizeData customizeData = super.getDefaultTableCustomizeData();
        for (XViewerColumn xCol : customizeData.getColumnData().getColumns()) {
            if (!xCol.getId().equals(SprintOrderColumn.getInstance().getId())) continue;
            xCol.setSortForward(true);
        }
        customizeData.getSortingData().setSortingNames(new String[]{SprintOrderColumn.getInstance().getId()});
        return customizeData;
    }

    public SprintArtifact getSoleSprintArtifact() {
        return this.soleSprintArtifact;
    }
}

