/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.actions.wizard;

import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import org.eclipse.osee.ats.api.AtsApi;
import org.eclipse.osee.ats.api.IAtsObject;
import org.eclipse.osee.ats.api.IAtsWorkItem;
import org.eclipse.osee.ats.api.agile.IAgileFeatureGroup;
import org.eclipse.osee.ats.api.agile.IAgileSprint;
import org.eclipse.osee.ats.api.ai.IAtsActionableItem;
import org.eclipse.osee.ats.api.data.AtsAttributeTypes;
import org.eclipse.osee.ats.api.data.AtsRelationTypes;
import org.eclipse.osee.ats.api.ev.IAtsWorkPackage;
import org.eclipse.osee.ats.api.team.IAtsTeamDefinition;
import org.eclipse.osee.ats.api.util.IAtsChangeSet;
import org.eclipse.osee.ats.api.util.IExecuteListener;
import org.eclipse.osee.ats.api.version.IAtsVersion;
import org.eclipse.osee.ats.api.workflow.ActionResult;
import org.eclipse.osee.ats.api.workflow.IAtsTeamWorkflow;
import org.eclipse.osee.ats.ide.actions.wizard.IAtsWizardItem;
import org.eclipse.osee.ats.ide.actions.wizard.WizardFields;
import org.eclipse.osee.ats.ide.internal.AtsApiService;
import org.eclipse.osee.ats.ide.util.widgets.XAgileFeatureHyperlinkWidget;
import org.eclipse.osee.ats.ide.util.widgets.XAssigneesHyperlinkWidget;
import org.eclipse.osee.ats.ide.util.widgets.XHyperlinkLabelValuePointsSelection;
import org.eclipse.osee.ats.ide.util.widgets.XOriginatorHyperlinkWidget;
import org.eclipse.osee.ats.ide.util.widgets.XSprintHyperlinkWidget;
import org.eclipse.osee.ats.ide.util.widgets.XTargetedVersionHyperlinkWidget;
import org.eclipse.osee.ats.ide.util.widgets.XWorkPackageHyperlinkWidget;
import org.eclipse.osee.ats.ide.workflow.teamwf.TeamWorkFlowArtifact;
import org.eclipse.osee.framework.core.data.AttributeTypeGeneric;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.util.Result;
import org.eclipse.osee.framework.jdk.core.type.DoubleKeyHashMap;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.framework.ui.skynet.widgets.XCheckBox;
import org.eclipse.osee.framework.ui.skynet.widgets.XComboViewer;
import org.eclipse.osee.framework.ui.skynet.widgets.XFloat;
import org.eclipse.osee.framework.ui.skynet.widgets.XLabel;
import org.eclipse.osee.framework.ui.skynet.widgets.util.IDynamicWidgetLayoutListener;
import org.eclipse.osee.framework.ui.swt.ALayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;

public abstract class AbstractWizardItem
implements IAtsWizardItem,
IDynamicWidgetLayoutListener {
    private final DoubleKeyHashMap<IAtsTeamDefinition, WizardFields, Object> teamDefFieldToWidget = new DoubleKeyHashMap();
    private final AtsApi atsApi;
    private final XComboViewer versionCombo = null;
    private final XCheckBox createBranchCheck = null;

    public AbstractWizardItem(AtsApi atsApi) {
        this.atsApi = atsApi;
    }

    public Collection<WizardFields> getFields(IAtsTeamDefinition teamDef) {
        return Collections.emptyList();
    }

    @Override
    public void getWizardXWidgetExtensions(Collection<IAtsActionableItem> ais, Composite comp) {
        Collection teamDefs = AtsApiService.get().getActionableItemService().getImpactedTeamDefs(ais);
        boolean first = true;
        for (IAtsTeamDefinition teamDef : teamDefs) {
            if (!this.hasWizardXWidgetExtensions(teamDef)) continue;
            XLabel label = new XLabel(String.valueOf(first ? "" : "\n") + "Extra fields for team \"" + teamDef.getName() + "\"");
            label.createWidgets(comp, 1);
            Composite teamComp = new Composite(comp, 2048);
            teamComp.setLayout((Layout)new GridLayout(1, false));
            GridData gd = new GridData(4, 4, true, false);
            gd.widthHint = 500;
            teamComp.setLayoutData((Object)gd);
            for (WizardFields field : this.getFields(teamDef)) {
                if (field.equals((Object)WizardFields.Assignees)) {
                    this.createAssigneeWidget(teamDef, teamComp);
                    continue;
                }
                if (field.equals((Object)WizardFields.Originator)) {
                    this.createOriginatorWidget(teamDef, teamComp);
                    continue;
                }
                if (field.equals((Object)WizardFields.PointsNumeric)) {
                    this.createPointsNumericWidget(teamDef, teamComp);
                    continue;
                }
                if (field.equals((Object)WizardFields.Points)) {
                    this.createPointsWidget(teamDef, teamComp);
                    continue;
                }
                if (field.equals((Object)WizardFields.WorkPackage)) {
                    this.createWorkPackageWidget(teamDef, teamComp);
                    continue;
                }
                if (field.equals((Object)WizardFields.Sprint)) {
                    this.createSprintWidget(teamComp, teamDef);
                    continue;
                }
                if (field.equals((Object)WizardFields.TargetedVersion)) {
                    this.createTargetedVersionWidget(teamComp, teamDef);
                    continue;
                }
                if (field.equals((Object)WizardFields.UnPlannedWork)) {
                    this.createUnplannedWorkWidget(teamComp, teamDef);
                    continue;
                }
                if (!field.equals((Object)WizardFields.FeatureGroup)) continue;
                this.createFeatureGroupWidget(teamComp, teamDef);
            }
            teamComp.layout();
        }
    }

    protected boolean hasWizardXWidgetExtensions(IAtsTeamDefinition teamDef) {
        return false;
    }

    private void createWorkPackageWidget(IAtsTeamDefinition teamDef, Composite teamComp) {
        XWorkPackageHyperlinkWidget wpComp = new XWorkPackageHyperlinkWidget(teamDef);
        wpComp.setFillHorizontally(true);
        wpComp.createWidgets(teamComp, 1);
        this.teamDefFieldToWidget.put((Object)teamDef, (Object)WizardFields.WorkPackage, (Object)wpComp);
    }

    private void createPointsNumericWidget(IAtsTeamDefinition teamDef, Composite teamComp) {
        Composite pointsComp = new Composite(teamComp, 0);
        GridLayout layout = ALayout.getZeroMarginLayout((int)1, (boolean)false);
        pointsComp.setLayout((Layout)layout);
        pointsComp.setLayoutData((Object)new GridData(16384, 128, false, false));
        XFloat pointsNumeric = new XFloat(WizardFields.PointsNumeric.getDisplayName());
        pointsNumeric.setFillHorizontally(false);
        pointsNumeric.createWidgets(pointsComp, 1);
        this.teamDefFieldToWidget.put((Object)teamDef, (Object)WizardFields.PointsNumeric, (Object)pointsNumeric);
    }

    private void createPointsWidget(IAtsTeamDefinition teamDef, Composite teamComp) {
        Composite pointsComp = new Composite(teamComp, 0);
        GridLayout layout = ALayout.getZeroMarginLayout((int)1, (boolean)false);
        pointsComp.setLayout((Layout)layout);
        pointsComp.setLayoutData((Object)new GridData(16384, 128, false, false));
        XHyperlinkLabelValuePointsSelection widget = new XHyperlinkLabelValuePointsSelection(teamDef);
        widget.createWidgets(pointsComp, 1);
        this.teamDefFieldToWidget.put((Object)teamDef, (Object)WizardFields.Points, (Object)widget);
    }

    private void createAssigneeWidget(IAtsTeamDefinition teamDef, Composite teamComp) {
        XAssigneesHyperlinkWidget assigneesWidget = new XAssigneesHyperlinkWidget(teamDef);
        assigneesWidget.setToolTip("If not set here, configured Lead(s) will be assigned.");
        assigneesWidget.setFillHorizontally(true);
        assigneesWidget.createWidgets(teamComp, 1);
        this.teamDefFieldToWidget.put((Object)teamDef, (Object)WizardFields.Assignees, (Object)assigneesWidget);
    }

    private void createOriginatorWidget(IAtsTeamDefinition teamDef, Composite parent) {
        XOriginatorHyperlinkWidget originatorWidget = new XOriginatorHyperlinkWidget();
        originatorWidget.setFillHorizontally(true);
        originatorWidget.createWidgets(parent, 1);
        this.teamDefFieldToWidget.put((Object)teamDef, (Object)WizardFields.Originator, (Object)originatorWidget);
    }

    private void createTargetedVersionWidget(Composite parent, IAtsTeamDefinition teamDef) {
        XTargetedVersionHyperlinkWidget widget = new XTargetedVersionHyperlinkWidget();
        widget.setTeamDef(teamDef);
        widget.createWidgets(parent, 1);
        this.teamDefFieldToWidget.put((Object)teamDef, (Object)WizardFields.TargetedVersion, (Object)widget);
    }

    private void createUnplannedWorkWidget(Composite parent, IAtsTeamDefinition teamDef) {
        Composite comp = new Composite(parent, 0);
        comp.setLayout((Layout)ALayout.getZeroMarginLayout((int)2, (boolean)false));
        comp.setLayoutData((Object)new GridData(16384, 128, false, false));
        XCheckBox createBranchCheck = new XCheckBox("Unplanned Work");
        createBranchCheck.setFillHorizontally(false);
        createBranchCheck.createWidgets(comp, 2);
        this.teamDefFieldToWidget.put((Object)teamDef, (Object)WizardFields.UnPlannedWork, (Object)createBranchCheck);
    }

    private void createSprintWidget(Composite parent, IAtsTeamDefinition teamDef) {
        XSprintHyperlinkWidget widget = new XSprintHyperlinkWidget();
        widget.setTeamDef(teamDef);
        widget.createWidgets(parent, 1);
        this.teamDefFieldToWidget.put((Object)teamDef, (Object)WizardFields.Sprint, (Object)widget);
    }

    private void createFeatureGroupWidget(Composite parent, IAtsTeamDefinition teamDef) {
        XAgileFeatureHyperlinkWidget widget = new XAgileFeatureHyperlinkWidget();
        widget.setTeamDef(teamDef);
        widget.createWidgets(parent, 1);
        this.teamDefFieldToWidget.put((Object)teamDef, (Object)WizardFields.FeatureGroup, (Object)widget);
    }

    @Override
    public void wizardCompleted(ActionResult actionResult, IAtsChangeSet changes) {
        for (IAtsTeamWorkflow teamWf : actionResult.getTeamWfs()) {
            IAtsTeamDefinition teamDef = teamWf.getTeamDefinition();
            this.wizardCompletedAssignees(teamWf, teamDef);
            this.wizardCompletedOriginator(teamWf, teamDef, changes);
            this.wizardCompletedPointsNumeric(teamWf, teamDef, changes);
            this.wizardCompletedPoints(teamWf, teamDef, changes);
            this.wizardCompletedWorkPackage(teamWf, teamDef, changes);
            this.wizardCompletedSprint(teamWf, teamDef, changes);
            this.wizardCompletedTargetedVersion(teamWf, teamDef, changes);
            this.wizardCompletedFeatureGroup(teamWf, teamDef, changes);
            this.wizardCompletedUnPlanned(teamWf, teamDef, changes);
            if (this.versionCombo == null || this.versionCombo.getSelected() == null || this.createBranchCheck == null || !this.createBranchCheck.isChecked()) continue;
            changes.addExecuteListener((IExecuteListener)new CreateBranch(teamDef));
        }
    }

    private void wizardCompletedUnPlanned(IAtsTeamWorkflow teamWf, IAtsTeamDefinition teamDef, IAtsChangeSet changes) {
        XCheckBox unPlanedCheckBox = (XCheckBox)this.teamDefFieldToWidget.get((Object)teamDef, (Object)WizardFields.UnPlannedWork);
        if (unPlanedCheckBox != null) {
            boolean unplanned = unPlanedCheckBox.isChecked();
            changes.setSoleAttributeValue((IAtsObject)teamWf, (AttributeTypeToken)AtsAttributeTypes.UnplannedWork, (Object)unplanned);
        }
    }

    private void wizardCompletedFeatureGroup(IAtsTeamWorkflow teamWf, IAtsTeamDefinition teamDef, IAtsChangeSet changes) {
        XAgileFeatureHyperlinkWidget featureCombo = (XAgileFeatureHyperlinkWidget)((Object)this.teamDefFieldToWidget.get((Object)teamDef, (Object)WizardFields.FeatureGroup));
        if (featureCombo != null) {
            for (IAgileFeatureGroup featureGroup : featureCombo.getFeatures()) {
                changes.relate((Object)featureGroup, AtsRelationTypes.AgileFeatureToItem_AtsItem, (Object)teamWf);
            }
        }
    }

    private void wizardCompletedTargetedVersion(IAtsTeamWorkflow teamWf, IAtsTeamDefinition teamDef, IAtsChangeSet changes) {
        IAtsVersion version;
        XTargetedVersionHyperlinkWidget widget = (XTargetedVersionHyperlinkWidget)((Object)this.teamDefFieldToWidget.get((Object)teamDef, (Object)WizardFields.TargetedVersion));
        if (widget != null && (version = widget.getSelected()) != null) {
            this.atsApi.getVersionService().setTargetedVersion(teamWf, version, changes);
        }
    }

    private void wizardCompletedSprint(IAtsTeamWorkflow teamWf, IAtsTeamDefinition teamDef, IAtsChangeSet changes) {
        IAgileSprint sprint;
        XSprintHyperlinkWidget sprintCombo = (XSprintHyperlinkWidget)((Object)this.teamDefFieldToWidget.get((Object)teamDef, (Object)WizardFields.Sprint));
        if (sprintCombo != null && (sprint = sprintCombo.getSelected()) != null) {
            changes.relate((Object)sprint, AtsRelationTypes.AgileSprintToItem_AtsItem, (Object)teamWf);
        }
    }

    private void wizardCompletedWorkPackage(IAtsTeamWorkflow teamWf, IAtsTeamDefinition teamDef, IAtsChangeSet changes) {
        IAtsWorkPackage workPackage;
        XWorkPackageHyperlinkWidget workPackageWidget = (XWorkPackageHyperlinkWidget)((Object)this.teamDefFieldToWidget.get((Object)teamDef, (Object)WizardFields.WorkPackage));
        if (workPackageWidget != null && (workPackage = workPackageWidget.getSelected()) != null) {
            this.atsApi.getEarnedValueService().setWorkPackage(workPackage, (IAtsWorkItem)teamWf, changes);
        }
    }

    private void wizardCompletedPointsNumeric(IAtsTeamWorkflow teamWf, IAtsTeamDefinition teamDef, IAtsChangeSet changes) {
        String pointsNumeric;
        XFloat xFloat = (XFloat)this.teamDefFieldToWidget.get((Object)teamDef, (Object)WizardFields.PointsNumeric);
        if (xFloat != null && Strings.isValid((String)(pointsNumeric = xFloat.get()))) {
            changes.setSoleAttributeFromString((IAtsObject)teamWf, (AttributeTypeGeneric)AtsAttributeTypes.PointsNumeric, pointsNumeric);
        }
    }

    private void wizardCompletedPoints(IAtsTeamWorkflow teamWf, IAtsTeamDefinition teamDef, IAtsChangeSet changes) {
        XHyperlinkLabelValuePointsSelection pointsWidget = (XHyperlinkLabelValuePointsSelection)((Object)this.teamDefFieldToWidget.get((Object)teamDef, (Object)WizardFields.Points));
        if (pointsWidget != null) {
            AttributeTypeToken pointsAttrType = this.atsApi.getAgileService().getPointsAttrType(teamDef);
            String value = pointsWidget.getValue();
            if (Strings.isValid((String)value)) {
                if (pointsAttrType.equals(AtsAttributeTypes.Points)) {
                    changes.setSoleAttributeValue((IAtsWorkItem)teamWf, pointsAttrType, value);
                } else {
                    changes.setSoleAttributeValue((IAtsObject)teamWf, pointsAttrType, (Object)Double.valueOf(value));
                }
            }
        }
    }

    private void wizardCompletedAssignees(IAtsTeamWorkflow teamWf, IAtsTeamDefinition teamDef) {
        XAssigneesHyperlinkWidget assigneesWidget = (XAssigneesHyperlinkWidget)((Object)this.teamDefFieldToWidget.get((Object)teamDef, (Object)WizardFields.Assignees));
        if (assigneesWidget != null && !assigneesWidget.getSelected().isEmpty()) {
            teamWf.getStateMgr().setAssignees(assigneesWidget.getSelected());
        }
    }

    private void wizardCompletedOriginator(IAtsTeamWorkflow teamWf, IAtsTeamDefinition teamDef, IAtsChangeSet changes) {
        XOriginatorHyperlinkWidget originatorWidget = (XOriginatorHyperlinkWidget)((Object)this.teamDefFieldToWidget.get((Object)teamDef, (Object)WizardFields.Originator));
        if (originatorWidget != null && originatorWidget.getSelected() != null) {
            teamWf.getStateMgr().setCreatedBy(originatorWidget.getSelected(), true, new Date(), changes);
        }
    }

    @Override
    public abstract String getName();

    private class CreateBranch
    implements IExecuteListener {
        private final IAtsTeamDefinition teamDef;

        public CreateBranch(IAtsTeamDefinition teamDef) {
            this.teamDef = teamDef;
        }

        public void changesStored(IAtsChangeSet changes) {
            for (IAtsWorkItem workItem : changes.getWorkItemsCreated()) {
                if (!workItem.isTeamWorkflow() || !workItem.getParentTeamWorkflow().getTeamDefinition().equals(this.teamDef)) continue;
                TeamWorkFlowArtifact teamArt = (TeamWorkFlowArtifact)workItem.getParentTeamWorkflow().getStoreObject();
                Result result = AtsApiService.get().getBranchServiceIde().createWorkingBranch_Validate(teamArt);
                if (!result.isTrue()) continue;
                AtsApiService.get().getBranchServiceIde().createWorkingBranch_Create(teamArt);
            }
        }
    }
}

