/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.actions;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.osee.ats.ide.actions.AbstractAtsAction;
import org.eclipse.osee.ats.ide.actions.IAtsTaskArtifactProvider;
import org.eclipse.osee.ats.ide.editor.WorkflowEditor;
import org.eclipse.osee.ats.ide.internal.Activator;
import org.eclipse.osee.ats.ide.internal.AtsApiService;
import org.eclipse.osee.ats.ide.workflow.task.TaskArtifact;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.operation.IOperation;
import org.eclipse.osee.framework.core.operation.Operations;
import org.eclipse.osee.framework.logging.OseeLevel;
import org.eclipse.osee.framework.logging.OseeLog;
import org.eclipse.osee.framework.skynet.core.artifact.Artifact;
import org.eclipse.osee.framework.skynet.core.artifact.PurgeArtifacts;
import org.eclipse.osee.framework.skynet.core.transaction.SkynetTransaction;
import org.eclipse.osee.framework.skynet.core.transaction.TransactionManager;
import org.eclipse.osee.framework.ui.plugin.util.AWorkbench;
import org.eclipse.osee.framework.ui.skynet.FrameworkImage;
import org.eclipse.osee.framework.ui.swt.ImageManager;
import org.eclipse.osee.framework.ui.swt.KeyedImage;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class DeleteTasksAction
extends AbstractAtsAction {
    private final IAtsTaskArtifactProvider taskProvider;

    public DeleteTasksAction(IAtsTaskArtifactProvider taskProvider) {
        super("Delete Tasks", 1);
        this.taskProvider = taskProvider;
        this.setImageDescriptor(ImageManager.getImageDescriptor((KeyedImage)FrameworkImage.X_RED));
        this.setToolTipText(this.getText());
    }

    public void updateEnablement(Collection<Artifact> selected) {
        if (selected.isEmpty()) {
            this.setEnabled(false);
        } else {
            for (Artifact art : selected) {
                if (art instanceof TaskArtifact) continue;
                this.setEnabled(false);
                return;
            }
            this.setEnabled(true);
        }
    }

    @Override
    public void run() {
        List<TaskArtifact> items = this.taskProvider.getSelectedArtifacts();
        if (items.isEmpty()) {
            AWorkbench.popup((String)"ERROR", (String)"No Tasks Selected");
            return;
        }
        StringBuilder builder = new StringBuilder();
        if (items.size() > 15) {
            builder.append("Are you sure you wish to delete " + items.size() + " Tasks?\n\n");
        } else {
            builder.append("Are you sure you wish to delete ");
            if (items.size() == 1) {
                builder.append("this Task?\n\n");
            } else {
                builder.append("these Tasks?\n\n");
            }
            for (TaskArtifact taskItem : items) {
                builder.append("\"" + taskItem.getName() + "\"\n");
            }
            builder.append("\n\nNote: Workflow will be saved.");
        }
        boolean delete = MessageDialog.openQuestion((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)"Delete Task", (String)builder.toString());
        if (delete) {
            try {
                SkynetTransaction transaction = TransactionManager.createTransaction((BranchId)AtsApiService.get().getAtsBranch(), (String)"Delete Tasks");
                ArrayList<TaskArtifact> delItems = new ArrayList<TaskArtifact>();
                ArrayList<TaskArtifact> tasksNotInDb = new ArrayList<TaskArtifact>();
                delItems.addAll(items);
                for (TaskArtifact taskArt : delItems) {
                    WorkflowEditor.close(Collections.singleton(taskArt), false);
                    if (taskArt.isInDb()) {
                        taskArt.deleteAndPersist(transaction);
                        continue;
                    }
                    tasksNotInDb.add(taskArt);
                }
                transaction.execute();
                if (tasksNotInDb.size() > 0) {
                    Operations.executeWorkAndCheckStatus((IOperation)new PurgeArtifacts(tasksNotInDb));
                }
            }
            catch (Exception ex) {
                OseeLog.log(Activator.class, (Level)OseeLevel.SEVERE_POPUP, (Throwable)ex);
            }
        }
    }
}

