/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.core.internal.search;

import java.sql.Timestamp;
import java.util.Arrays;
import java.util.Collection;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.TransactionId;
import org.eclipse.osee.framework.core.data.TransactionToken;
import org.eclipse.osee.framework.core.enums.TransactionDetailsType;
import org.eclipse.osee.orcs.core.ds.Criteria;
import org.eclipse.osee.orcs.core.ds.Options;
import org.eclipse.osee.orcs.core.ds.QueryData;
import org.eclipse.osee.orcs.core.ds.criteria.CriteriaAuthorIds;
import org.eclipse.osee.orcs.core.ds.criteria.CriteriaCommitIds;
import org.eclipse.osee.orcs.core.ds.criteria.CriteriaTxGetPrior;
import org.eclipse.osee.orcs.core.ds.criteria.CriteriaTxIds;
import org.eclipse.osee.orcs.core.internal.search.TransactionCriteriaFactory;
import org.eclipse.osee.orcs.search.Operator;
import org.eclipse.osee.orcs.search.TxQueryBuilder;

public class TxQueryBuilderImpl<T>
implements TxQueryBuilder<T> {
    private final TransactionCriteriaFactory criteriaFactory;
    private final QueryData queryData;

    public TxQueryBuilderImpl(TransactionCriteriaFactory criteriaFactory, QueryData queryData) {
        this.criteriaFactory = criteriaFactory;
        this.queryData = queryData;
    }

    private Options getOptions() {
        return this.queryData.getOptions();
    }

    public T andTxIds(Collection<TransactionId> ids) {
        return this.addAndCheck(this.queryData, new CriteriaTxIds(ids));
    }

    public T andTxId(Operator op, int id) {
        Criteria criteria = this.criteriaFactory.newByIdWithOperator(op, id);
        return this.addAndCheck(this.queryData, criteria);
    }

    public T andTxId(Operator op1, int id1, Operator op2, int id2) {
        Criteria criteria = this.criteriaFactory.newByIdWithTwoOperators(op1, id1, op2, id2);
        return this.addAndCheck(this.queryData, criteria);
    }

    public T andCommentEquals(String value) {
        Criteria criteria = this.criteriaFactory.newCommentCriteria(value, false);
        return this.addAndCheck(this.queryData, criteria);
    }

    public T andCommentPattern(String pattern) {
        Criteria criteria = this.criteriaFactory.newCommentCriteria(pattern, true);
        return this.addAndCheck(this.queryData, criteria);
    }

    public T andIs(TransactionDetailsType ... types) {
        return this.andIs(Arrays.asList(types));
    }

    public T andIs(Collection<TransactionDetailsType> types) {
        Criteria criteria = this.criteriaFactory.newTxTypeCriteria(types);
        return this.addAndCheck(this.queryData, criteria);
    }

    public T andBranch(BranchId ... ids) {
        return this.andBranch(Arrays.asList(ids));
    }

    public T andBranch(Collection<? extends BranchId> ids) {
        Criteria criteria = this.criteriaFactory.newTxBranchIdCriteria(ids);
        return this.addAndCheck(this.queryData, criteria);
    }

    public T andBranchIds(Collection<? extends BranchId> ids) {
        Criteria criteria = this.criteriaFactory.newTxBranchIdCriteria(ids);
        return this.addAndCheck(this.queryData, criteria);
    }

    public T andDate(Operator op, Timestamp date) {
        Criteria criteria = this.criteriaFactory.newByDateWithOperator(op, date);
        return this.addAndCheck(this.queryData, criteria);
    }

    public T andDate(Timestamp from, Timestamp to) {
        Criteria criteria = this.criteriaFactory.newByDateRange(from, to);
        return this.addAndCheck(this.queryData, criteria);
    }

    public T andAuthorId(ArtifactId author) {
        return this.addAndCheck(this.queryData, new CriteriaAuthorIds(author));
    }

    public T andAuthorIds(Collection<ArtifactId> authors) {
        return this.addAndCheck(this.queryData, new CriteriaAuthorIds(authors));
    }

    public T andNullCommitId() {
        return this.andCommitId(null);
    }

    public T andCommitIds(Collection<ArtifactId> ids) {
        return this.addAndCheck(this.queryData, new CriteriaCommitIds(ids));
    }

    public T andCommitId(ArtifactId id) {
        return this.addAndCheck(this.queryData, new CriteriaCommitIds(id));
    }

    public T andIsHead(BranchId branch) {
        Criteria criteria = this.criteriaFactory.newGetHead(branch);
        return this.addAndCheck(this.queryData, criteria);
    }

    public T andIsPriorTx(TransactionToken tx) {
        return this.addAndCheck(this.queryData, new CriteriaTxGetPrior(tx));
    }

    private T addAndCheck(QueryData queryData, Criteria criteria) {
        criteria.checkValid(this.getOptions());
        queryData.addCriteria(criteria);
        return (T)this;
    }

    public QueryData build() {
        if (this.queryData.hasNoCriteria()) {
            this.addAndCheck(this.queryData, this.criteriaFactory.createAllTransactionsCriteria());
        }
        return this.queryData;
    }

    public T andTxId(TransactionId id) {
        return this.addAndCheck(this.queryData, new CriteriaTxIds(id));
    }
}

