/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.xviewer.action;

import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuCreator;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.nebula.widgets.xviewer.XViewer;
import org.eclipse.nebula.widgets.xviewer.XViewerText;
import org.eclipse.nebula.widgets.xviewer.action.TableCustomizationAction;
import org.eclipse.nebula.widgets.xviewer.action.TableCustomizationCustomizeDataAction;
import org.eclipse.nebula.widgets.xviewer.core.model.CustomizeData;
import org.eclipse.nebula.widgets.xviewer.util.internal.XViewerLog;
import org.eclipse.nebula.widgets.xviewer.util.internal.images.XViewerImageCache;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;

public class TableCustomizationDropDownAction
extends Action
implements IMenuCreator {
    private Menu fMenu;
    private final XViewer xViewer;

    public TableCustomizationDropDownAction(XViewer xViewer) {
        this.xViewer = xViewer;
        this.setText(XViewerText.get("action.tableCustomization"));
        this.setMenuCreator(this);
    }

    public ImageDescriptor getImageDescriptor() {
        return XViewerImageCache.getImageDescriptor("customize.gif");
    }

    public void run() {
        this.xViewer.getCustomizeMgr().handleTableCustomization();
    }

    public String getToolTipText() {
        return XViewerText.get("toolTip.customizeTable");
    }

    public Menu getMenu(Control parent) {
        if (this.fMenu != null) {
            this.fMenu.dispose();
        }
        this.fMenu = new Menu(parent);
        this.addActionToMenu(this.fMenu, new TableCustomizationAction(this.xViewer));
        this.addActionToMenu(this.fMenu, new TableCustomizationCustomizeDataAction(this.xViewer, this.xViewer.getCustomizeMgr().getTableDefaultCustData()));
        new MenuItem(this.fMenu, 2);
        try {
            List<CustomizeData> savedCustDatas = this.xViewer.getCustomizeMgr().getSavedCustDatas();
            Collections.sort(savedCustDatas);
            for (CustomizeData custData : savedCustDatas) {
                this.addActionToMenu(this.fMenu, new TableCustomizationCustomizeDataAction(this.xViewer, custData));
            }
        }
        catch (Exception ex) {
            XViewerLog.log(TableCustomizationDropDownAction.class, Level.SEVERE, ex);
        }
        return this.fMenu;
    }

    public void dispose() {
        if (this.fMenu != null) {
            this.fMenu.dispose();
            this.fMenu = null;
        }
    }

    public Menu getMenu(Menu parent) {
        return null;
    }

    protected void addActionToMenu(Menu parent, Action action) {
        ActionContributionItem item = new ActionContributionItem((IAction)action);
        item.fill(parent, -1);
    }

    void clear() {
        this.dispose();
    }
}

