/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.define.rest.synchronization.forest.denizens;

import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Objects;
import org.eclipse.osee.define.rest.synchronization.RootList;
import org.eclipse.osee.framework.core.data.OseeCodeVersion;
import org.eclipse.osee.framework.core.server.OseeInfo;
import org.eclipse.osee.framework.jdk.core.type.Id;
import org.eclipse.osee.framework.jdk.core.util.IndentedString;
import org.eclipse.osee.framework.jdk.core.util.ToMessage;
import org.eclipse.osee.jdbc.JdbcClient;
import org.eclipse.osee.jdbc.JdbcService;
import org.eclipse.osee.orcs.OrcsApi;

public final class NativeHeader
implements Id,
ToMessage {
    Long id;
    private final OrcsApi orcsApi;
    private final RootList rootList;

    public NativeHeader(Long id, OrcsApi orcsApi, RootList rootList) {
        this.id = Objects.requireNonNull(id);
        this.orcsApi = Objects.requireNonNull(orcsApi);
        this.rootList = Objects.requireNonNull(rootList);
    }

    public Long getId() {
        return this.id;
    }

    public String getComment() {
        return this.rootList.toText(null).toString();
    }

    public String getRepositoryId() {
        JdbcService jdbcService = this.orcsApi.getJdbcService();
        JdbcClient jdbcClient = jdbcService.getClient();
        String databaseName = OseeInfo.getValue((JdbcClient)jdbcClient, (String)"osee.db");
        if (Objects.isNull(databaseName) || databaseName.isEmpty()) {
            databaseName = "(no-database-name)";
        }
        String databaseId = OseeInfo.getValue((JdbcClient)jdbcClient, (String)"osee.db.guid");
        return databaseName + "( " + databaseId + " )";
    }

    public String getSourceToolId() {
        return OseeCodeVersion.getVersionId().toString();
    }

    public GregorianCalendar getTime() {
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(new Date());
        return calendar;
    }

    public String getTitle() {
        return "OSEE Synchronization Artifact";
    }

    public StringBuilder toMessage(int indent, StringBuilder message) {
        StringBuilder outMessage = message != null ? message : new StringBuilder(1024);
        String indent0 = IndentedString.indentString((int)(indent + 0));
        String indent1 = IndentedString.indentString((int)(indent + 1));
        String name = this.getClass().getName();
        outMessage.append(indent0).append(name).append("\n").append(indent1).append("ORCS API: ").append(Objects.nonNull(this.orcsApi) ? "(is set)" : "(is not set)").append("\n");
        if (Objects.isNull(this.rootList)) {
            outMessage.append(indent1).append("Root List: ").append("(is not set)").append("\n");
        } else {
            this.rootList.toMessage(indent + 1, outMessage);
        }
        return outMessage;
    }
}

