/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.define.rest.synchronization;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.osee.define.api.synchronization.Root;
import org.eclipse.osee.define.rest.synchronization.BadDocumentRootException;
import org.eclipse.osee.define.rest.synchronization.UnknownSynchronizationArtifactTypeException;
import org.eclipse.osee.framework.core.data.ArtifactReadable;
import org.eclipse.osee.framework.jdk.core.type.ItemDoesNotExist;
import org.eclipse.osee.framework.jdk.core.type.MultipleItemsExist;
import org.eclipse.osee.framework.jdk.core.type.ResultSet;
import org.eclipse.osee.framework.jdk.core.util.IndentedString;
import org.eclipse.osee.framework.jdk.core.util.ToMessage;
import org.eclipse.osee.orcs.OrcsApi;

public class RootList
implements Iterable<ArtifactReadable>,
ToMessage {
    String synchronizationArtifactType;
    OrcsApi orcsApi;
    List<Root> rootsList;
    List<ArtifactReadable> artifactReadableRoots;

    private RootList(OrcsApi orcsApi, String synchronizationArtifactType) {
        this.synchronizationArtifactType = synchronizationArtifactType;
        this.orcsApi = orcsApi;
        this.rootsList = new ArrayList<Root>();
        this.artifactReadableRoots = null;
    }

    public static RootList create(OrcsApi orcsApi, String synchronizationArtifactType) {
        Objects.requireNonNull(orcsApi, "RootList::create, parameter \"orcsApi\" is null.");
        Objects.requireNonNull(synchronizationArtifactType, "RootList::create, parameter \"synchronizationArtifact\" is null.");
        if (synchronizationArtifactType.isEmpty()) {
            throw new UnknownSynchronizationArtifactTypeException(synchronizationArtifactType);
        }
        return new RootList(orcsApi, synchronizationArtifactType);
    }

    public void add(Root root) {
        if (Objects.nonNull(this.artifactReadableRoots)) {
            throw new IllegalStateException("Attempt to add an additional document root after the list has been validated.\n");
        }
        this.rootsList.add(root);
    }

    public OrcsApi getOrcsApi() {
        return this.orcsApi;
    }

    public String getSynchronizationArtifactType() {
        return this.synchronizationArtifactType;
    }

    @Override
    public Iterator<ArtifactReadable> iterator() {
        if (Objects.isNull(this.artifactReadableRoots)) {
            throw new IllegalStateException("Attempt to iterate the RootList before validation.\n");
        }
        return this.artifactReadableRoots.iterator();
    }

    public Stream<ArtifactReadable> stream() {
        if (Objects.isNull(this.artifactReadableRoots)) {
            throw new IllegalStateException("Attempt to iterate the RootList before validation.\n");
        }
        return this.artifactReadableRoots.stream();
    }

    private ArtifactReadable validateRoot(Root root, StringBuilder message) {
        try {
            ResultSet artifactReadableSet = this.orcsApi.getQueryFactory().fromBranch(root.getBranchId()).andId(root.getArtifactId()).getResults();
            return (ArtifactReadable)artifactReadableSet.getExactlyOne();
        }
        catch (ItemDoesNotExist | MultipleItemsExist e) {
            String indent1 = IndentedString.indentString((int)1);
            message.append("The document root is not a valid OSEE Artifact.").append("\n");
            root.toMessage(1, message);
            message.append("Reason:").append("\n").append(indent1).append(e.getMessage()).append("\n");
            return null;
        }
        catch (Exception e) {
            StringBuilder eMessage = new StringBuilder(1024).append("RootList::validateRoot, Failed to build ORCS query for document root.").append("\n");
            root.toMessage(1, eMessage);
            throw new Error(eMessage.toString(), e);
        }
    }

    public void validate() {
        if (Objects.nonNull(this.artifactReadableRoots)) {
            throw new IllegalStateException("Attempt to validate a RootList that has already been validated.\n");
        }
        StringBuilder message = new StringBuilder(1024);
        this.artifactReadableRoots = this.rootsList.stream().map(root -> this.validateRoot((Root)root, message)).filter(Objects::nonNull).collect(Collectors.toList());
        if (message.length() > 0) {
            throw new BadDocumentRootException(message.toString());
        }
    }

    public StringBuilder toText(StringBuilder message) {
        StringBuilder outMessage = message != null ? message : new StringBuilder(1024);
        boolean first = true;
        this.rootsList.stream().forEach(root -> {
            if (!first) {
                outMessage.append(", ");
            }
            root.toText(outMessage);
        });
        return outMessage;
    }

    public StringBuilder toMessage(int indent, StringBuilder message) {
        StringBuilder outMessage = message != null ? message : new StringBuilder(1024);
        String indent0 = IndentedString.indentString((int)(indent + 0));
        outMessage.append(indent0).append("Root List:").append("\n");
        this.rootsList.stream().forEach(root -> {
            StringBuilder stringBuilder2 = root.toMessage(indent + 1, outMessage);
        });
        return outMessage;
    }

    public String toString() {
        return this.toMessage(0, null).toString();
    }
}

