/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.define.rest.internal.wordupdate;

import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import org.eclipse.osee.ats.api.AtsApi;
import org.eclipse.osee.ats.api.IAtsWorkItem;
import org.eclipse.osee.ats.api.ai.ActionableItem;
import org.eclipse.osee.ats.api.config.TeamDefinition;
import org.eclipse.osee.ats.api.data.AtsArtifactToken;
import org.eclipse.osee.ats.api.data.AtsAttributeTypes;
import org.eclipse.osee.ats.api.team.CreateTeamOption;
import org.eclipse.osee.ats.api.team.IAtsTeamDefinition;
import org.eclipse.osee.ats.api.user.AtsCoreUsers;
import org.eclipse.osee.ats.api.user.AtsUser;
import org.eclipse.osee.ats.api.util.IAtsChangeSet;
import org.eclipse.osee.ats.api.workflow.IAtsAction;
import org.eclipse.osee.ats.api.workflow.IAtsTeamWorkflow;
import org.eclipse.osee.ats.api.workflow.INewActionListener;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactReadable;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.data.Branch;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.enums.CoreAttributeTypes;
import org.eclipse.osee.framework.jdk.core.type.Id;
import org.eclipse.osee.framework.jdk.core.type.OseeArgumentException;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.util.Conditions;
import org.eclipse.osee.logger.Log;
import org.eclipse.osee.orcs.OrcsApi;
import org.eclipse.osee.orcs.search.BranchQuery;
import org.eclipse.osee.orcs.search.QueryFactory;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;

public class SafetyWorkflowEventHandler
implements EventHandler {
    public static final String SAFETY_EVENT_TOPIC = "org/eclipse/osee/define/safetyworkflow/modified";
    public static final String SAFETY_EVENT_BRANCH_ID = "org/eclipse/osee/define/report/internal/BRANCH_ID";
    public static final String SAFETY_EVENT_USER_ART = "org/eclipse/osee/define/report/internal/USER_ART";
    private QueryFactory queryFactory;
    private AtsApi atsApi;
    private Log logger;

    public void setOrcsApi(OrcsApi orcsApi) {
        this.queryFactory = orcsApi.getQueryFactory();
    }

    public void setLogger(Log logger) {
        this.logger = logger;
    }

    public void setAtsApi(AtsApi atsApi) {
        this.atsApi = atsApi;
    }

    public void handleEvent(Event event) {
        try {
            ArtifactReadable assocArt;
            IAtsTeamWorkflow safetyWf;
            Object branchId = event.getProperty(SAFETY_EVENT_BRANCH_ID);
            Object userArt = event.getProperty(SAFETY_EVENT_USER_ART);
            this.checkEventObjects(branchId, userArt);
            Branch branch = (Branch)((BranchQuery)this.queryFactory.branchQuery().andId((BranchId)branchId)).getResults().getExactlyOne();
            ArtifactId workflowId = branch.getAssociatedArtifact();
            if (workflowId.notEqual((Id)ArtifactId.SENTINEL) && (safetyWf = this.getSafetyWorkflow(assocArt = (ArtifactReadable)this.atsApi.getQueryService().getArtifact(workflowId))) == null) {
                IAtsTeamWorkflow teamWf = this.atsApi.getWorkItemService().getTeamWf((ArtifactToken)assocArt);
                safetyWf = this.createSafetyAction(teamWf, (ArtifactId)userArt);
            }
        }
        catch (Exception ex) {
            this.logger.error((Throwable)ex, "Could not create safety workflow", new Object[0]);
        }
    }

    private void checkEventObjects(Object branchId, Object userArt) {
        if (!(branchId instanceof BranchId)) {
            throw new OseeArgumentException("BranchID provided to safety workflow creation event incorrect type: %s", new Object[]{branchId.getClass()});
        }
        if (!(userArt instanceof ArtifactId)) {
            throw new OseeArgumentException("User Artifact provided to safety workflow creation event incorrect type: %s", new Object[]{userArt.getClass()});
        }
    }

    private IAtsTeamWorkflow getSafetyWorkflow(ArtifactReadable workflowArt) {
        Conditions.checkNotNull((Object)workflowArt, (String)"work flow artifact");
        IAtsTeamWorkflow safetyWorkflow = null;
        ArtifactReadable safetyActionableItemArt = (ArtifactReadable)this.atsApi.getQueryService().getArtifact((ArtifactId)AtsArtifactToken.SafetyActionableItem);
        IAtsTeamWorkflow teamWf = this.atsApi.getWorkItemService().getTeamWf((ArtifactToken)workflowArt);
        ActionableItem actionableItem = this.atsApi.getActionableItemService().getActionableItemById((ArtifactId)safetyActionableItemArt);
        for (IAtsTeamWorkflow sibling : this.atsApi.getActionService().getSiblingTeamWorkflows(teamWf)) {
            if (!sibling.getActionableItems().contains(actionableItem)) continue;
            safetyWorkflow = sibling;
            break;
        }
        return safetyWorkflow;
    }

    private IAtsTeamWorkflow createSafetyAction(IAtsTeamWorkflow teamWf, ArtifactId userArt) {
        IAtsTeamWorkflow teamWorkflow = null;
        try {
            ActionableItem ai = this.atsApi.getActionableItemService().getActionableItemById((ArtifactId)AtsArtifactToken.SafetyActionableItem);
            if (ai == null) {
                throw new OseeCoreException("Safety Actionable Item not configured", new Object[0]);
            }
            TeamDefinition teamDef = this.atsApi.getTeamDefinitionService().getTeamDefinitionById((ArtifactId)AtsArtifactToken.SafetyTeamDefinition);
            if (teamDef == null) {
                throw new OseeCoreException("Safety Team Definition not configured", new Object[0]);
            }
            AtsUser createdBy = AtsCoreUsers.SYSTEM_USER;
            IAtsChangeSet changes = this.atsApi.getStoreService().createAtsChangeSet("Create System Safety Workflow", this.atsApi.getUserService().getUserById(userArt));
            IAtsAction action = this.atsApi.getActionService().getAction(teamWf);
            teamWorkflow = this.atsApi.getActionService().createTeamWorkflow(action, (IAtsTeamDefinition)teamDef, Collections.singleton(ai), Arrays.asList(AtsCoreUsers.UNASSIGNED_USER), changes, new Date(), createdBy, Arrays.asList(new INewActionListener(){

                public void teamCreated(IAtsAction action, IAtsTeamWorkflow teamWf, IAtsChangeSet changes) {
                    changes.setSoleAttributeValue((IAtsWorkItem)teamWf, (AttributeTypeToken)AtsAttributeTypes.Description, "Review System Safety Changes for the associated RPCR to Complete the Workflow");
                }
            }), new CreateTeamOption[0]);
            changes.setSoleAttributeValue((IAtsWorkItem)teamWorkflow, (AttributeTypeToken)CoreAttributeTypes.Name, "Safety Workflow for " + teamWf.getAtsId());
            changes.execute();
        }
        catch (Exception ex) {
            this.logger.error((Throwable)ex, "WordUpdateData Safety Action creation", new Object[0]);
        }
        return teamWorkflow;
    }
}

