/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.define.rest;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.ws.rs.core.Response;
import org.eclipse.osee.activity.api.ActivityLog;
import org.eclipse.osee.app.OseeAppletPage;
import org.eclipse.osee.define.api.CertBaselineData;
import org.eclipse.osee.define.api.CertFileData;
import org.eclipse.osee.define.api.DefineApi;
import org.eclipse.osee.define.api.GitOperations;
import org.eclipse.osee.define.api.TraceData;
import org.eclipse.osee.define.api.TraceabilityEndpoint;
import org.eclipse.osee.define.api.TraceabilityOperations;
import org.eclipse.osee.define.rest.internal.PublishLowHighReqStreamingOutput;
import org.eclipse.osee.define.rest.internal.PublishPidsVerificationReport;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactReadable;
import org.eclipse.osee.framework.core.data.ArtifactTypeId;
import org.eclipse.osee.framework.core.data.ArtifactTypeToken;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.TransactionToken;
import org.eclipse.osee.framework.jdk.core.type.IResourceRegistry;
import org.eclipse.osee.framework.jdk.core.util.Conditions;
import org.eclipse.osee.orcs.OrcsApi;
import org.eclipse.osee.orcs.search.QueryFactory;
import org.eclipse.osee.template.engine.AppendableRule;
import org.eclipse.osee.template.engine.ArtifactTypeOptionsRule;

public final class TraceabilityEndpointImpl
implements TraceabilityEndpoint {
    private final OrcsApi orcsApi;
    private final TraceabilityOperations traceOps;
    private final GitOperations gitOps;
    private final IResourceRegistry resourceRegistry;
    private final ActivityLog activityLog;
    private final QueryFactory queryFactory;

    public TraceabilityEndpointImpl(ActivityLog activityLog, IResourceRegistry resourceRegistry, OrcsApi orcsApi, DefineApi defineApi) {
        this.orcsApi = orcsApi;
        this.traceOps = defineApi.getTraceabilityOperations();
        this.gitOps = defineApi.gitOperations();
        this.resourceRegistry = resourceRegistry;
        this.activityLog = activityLog;
        this.queryFactory = orcsApi.getQueryFactory();
    }

    public Response getLowHighReqReport(BranchId branch, String selectedTypes) {
        Conditions.checkNotNull((Object)branch, (String)"branch query param");
        Conditions.checkNotNull((Object)selectedTypes, (String)"selected_types query param");
        PublishLowHighReqStreamingOutput streamingOutput = new PublishLowHighReqStreamingOutput(this.activityLog, this.orcsApi, branch, selectedTypes);
        String fileName = "Requirement_Trace_Report.xml";
        Response.ResponseBuilder builder = Response.ok((Object)streamingOutput);
        builder.header("Content-Disposition", (Object)("attachment; filename=" + fileName));
        return builder.build();
    }

    public TraceData getSrsToImpd(BranchId branch, ArtifactTypeId excludeType) {
        return this.traceOps.getSrsToImpd(branch, excludeType);
    }

    public String getSinglePageApp() {
        OseeAppletPage pageUtil = new OseeAppletPage(this.queryFactory.branchQuery());
        ArtifactTypeOptionsRule selectRule = new ArtifactTypeOptionsRule("artifactTypeSelect", this.getTypes(), new HashSet());
        return pageUtil.realizeApplet(this.resourceRegistry, "publishLowHighReport.html", this.getClass(), new AppendableRule[]{selectRule});
    }

    private Set<String> getTypes() {
        HashSet<String> toReturn = new HashSet<String>();
        for (ArtifactTypeToken type : this.orcsApi.tokenService().getArtifactTypes()) {
            toReturn.add(type.getName());
        }
        return toReturn;
    }

    public Response getPidsVerificationReport(BranchId branch, ArtifactId rootArtifact) {
        PublishPidsVerificationReport streamingOutput = new PublishPidsVerificationReport(this.activityLog, this.orcsApi, branch, rootArtifact);
        String fileName = "PidsVerificationReport.xml";
        Response.ResponseBuilder builder = Response.ok((Object)streamingOutput);
        builder.header("Content-Disposition", (Object)("attachment; filename=" + fileName));
        return builder.build();
    }

    public ArtifactId baselineFiles(BranchId branch, String repositoryName, CertBaselineData baselineData) {
        return this.traceOps.baselineFiles(branch, this.gitOps.getRepoArtifact(branch, repositoryName), baselineData, null);
    }

    public List<CertBaselineData> getBaselineData(BranchId branch, String repositoryName) {
        return this.traceOps.getBaselineData(branch, this.gitOps.getRepoArtifact(branch, repositoryName));
    }

    public TransactionToken copyCertBaselineData(BranchId destinationBranch, String repositoryName, BranchId sourceBranch) {
        return this.traceOps.copyCertBaselineData(destinationBranch, repositoryName, sourceBranch);
    }

    public List<CertFileData> getCertFileData(BranchId branch, String repositoryName) {
        return this.traceOps.getCertFileData(branch, this.gitOps.getRepoArtifact(branch, repositoryName));
    }

    public CertBaselineData getBaselineData(BranchId branch, ArtifactId certBaselineData) {
        ArtifactReadable baselineArtifact = this.queryFactory.fromBranch(branch).andId(certBaselineData).getArtifact();
        return this.traceOps.getBaselineData(baselineArtifact);
    }
}

