/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.jaxrs.server.internal.security.oauth2.rs;

import java.util.Map;
import org.eclipse.osee.jaxrs.server.internal.JaxRsUtils;

public class OAuth2ResourceServerConfig {
    private static final String NAMESPACE = "jaxrs.oauth2.rs";
    public static final String OAUTH2_RS__SERVICE_ENABLED = OAuth2ResourceServerConfig.qualify("enabled");
    public static final String OAUTH2_RS__REALM = OAuth2ResourceServerConfig.qualify("realm");
    public static final String OAUTH2_RS__AUDIENCE_IS_ENDPOINT_ADDRESS = OAuth2ResourceServerConfig.qualify("audience.is.endpoint.address");
    public static final String OAUTH2_RS__FILTER_CHECKS_FORM_DATA = OAuth2ResourceServerConfig.qualify("filter.checks.form.data.for.token");
    public static final String OAUTH2_RS__USE_USER_SUBJECT = OAuth2ResourceServerConfig.qualify("use.user.subject");
    public static final String OAUTH2_RS__RESOURCE_SERVER_KEY = OAuth2ResourceServerConfig.qualify("resource.server.key");
    public static final String OAUTH2_RS__RESOURCE_SERVER_SECRET = OAuth2ResourceServerConfig.qualify("resource.server.secret");
    public static final String OAUTH2_RS__TOKEN_VALIDATION_URI = OAuth2ResourceServerConfig.qualify("token.validation.uri");
    public static final String OAUTH2_RS__IS_CACHE_TOKENS_ALLOWED = OAuth2ResourceServerConfig.qualify("is.cache.tokens.allowed");
    public static final String OAUTH2_RS__TOKEN_CACHE_MAX_SIZE = OAuth2ResourceServerConfig.qualify("token.cache.max.size");
    public static final String OAUTH2_RS__TOKEN_CACHE_EVICT_TIMEOUT_MILLIS = OAuth2ResourceServerConfig.qualify("token.cache.evict.timeout");
    public static final boolean DEFAULT_OAUTH2_RS__SERVICE_ENABLED = false;
    public static final String DEFAULT_OAUTH2_RS__REALM = "OAuth2-Resource-Server-OSEE";
    public static final boolean DEFAULT_OAUTH2_RS__AUDIENCE_IS_ENDPOINT_ADDRESS = false;
    public static final boolean DEFAULT_OAUTH2_RS__FILTER_CHECKS_FORM_DATA = false;
    public static final boolean DEFAULT_OAUTH2_RS__USE_USER_SUBJECT = false;
    public static final boolean DEFAULT_OAUTH2_RS__IS_CACHE_TOKENS_ALLOWED = true;
    public static final int DEFAULT_OAUTH2_RS__TOKEN_CACHE_MAX_SIZE = 5000;
    public static final long DEFAULT_OAUTH2_RS__TOKEN_CACHE_EVICT_TIMEOUT_MILLIS = 14400000L;
    public static final long OAUTH2_RS__MAX_TOKEN_CACHE_EVICT_TIMEOUT_MILLIS = 86400000L;
    private final Map<String, Object> props;

    private static String qualify(String value) {
        return String.format("%s.%s", NAMESPACE, value);
    }

    public static OAuth2ResourceServerConfig fromProperties(Map<String, Object> props) {
        return new OAuth2ResourceServerConfig(props);
    }

    private OAuth2ResourceServerConfig(Map<String, Object> props) {
        this.props = props;
    }

    public boolean isEnabled() {
        return JaxRsUtils.getBoolean(this.props, OAUTH2_RS__SERVICE_ENABLED, false);
    }

    public String getRealm() {
        return JaxRsUtils.get(this.props, OAUTH2_RS__REALM, DEFAULT_OAUTH2_RS__REALM);
    }

    public boolean isAudienceIsEndpointAddress() {
        return JaxRsUtils.getBoolean(this.props, OAUTH2_RS__AUDIENCE_IS_ENDPOINT_ADDRESS, false);
    }

    public boolean isFilterChecksFormDataForToken() {
        return JaxRsUtils.getBoolean(this.props, OAUTH2_RS__FILTER_CHECKS_FORM_DATA, false);
    }

    public boolean isUseUserSubject() {
        return JaxRsUtils.getBoolean(this.props, OAUTH2_RS__USE_USER_SUBJECT, false);
    }

    public String getResourceServerKey() {
        return JaxRsUtils.get(this.props, OAUTH2_RS__RESOURCE_SERVER_KEY, null);
    }

    public String getResourceServerSecret() {
        return JaxRsUtils.get(this.props, OAUTH2_RS__RESOURCE_SERVER_SECRET, null);
    }

    public String getValidationServerUri() {
        return JaxRsUtils.get(this.props, OAUTH2_RS__TOKEN_VALIDATION_URI, null);
    }

    public boolean isCacheTokensAllowed() {
        return JaxRsUtils.getBoolean(this.props, OAUTH2_RS__IS_CACHE_TOKENS_ALLOWED, true);
    }

    public int getTokenCacheMaxSize() {
        return JaxRsUtils.getInt(this.props, OAUTH2_RS__TOKEN_CACHE_MAX_SIZE, 5000);
    }

    public long getTokenCacheEvictTimeoutMillis() {
        return JaxRsUtils.getLong(this.props, OAUTH2_RS__TOKEN_CACHE_EVICT_TIMEOUT_MILLIS, 14400000L);
    }
}

