/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.account.admin;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.osee.account.admin.CreateAccountRequest;

public final class CreateAccountRequestBuilder {
    private boolean active;
    private String userName;
    private String email;
    private String displayName;
    private final Map<String, String> preferences = new HashMap<String, String>();

    private CreateAccountRequestBuilder() {
    }

    public static CreateAccountRequestBuilder newBuilder() {
        return new CreateAccountRequestBuilder();
    }

    public CreateAccountRequestBuilder active(boolean active) {
        this.active = active;
        return this;
    }

    public CreateAccountRequestBuilder userName(String userName) {
        this.userName = userName;
        return this;
    }

    public CreateAccountRequestBuilder email(String email) {
        this.email = email;
        return this;
    }

    public CreateAccountRequestBuilder displayName(String displayName) {
        this.displayName = displayName;
        return this;
    }

    public CreateAccountRequestBuilder prefs(Map<String, String> other) {
        if (other != null && !other.isEmpty()) {
            this.preferences.putAll(other);
        }
        return this;
    }

    public CreateAccountRequestBuilder pref(String key, String value) {
        this.preferences.put(key, value);
        return this;
    }

    public CreateAccountRequest build() {
        HashMap<String, String> prefs = new HashMap<String, String>(this.preferences);
        return new CreateAccountRequestImpl(this.active, this.userName, this.email, this.displayName, prefs);
    }

    public static final class CreateAccountRequestImpl
    implements CreateAccountRequest {
        private final boolean active;
        private final String userName;
        private final String email;
        private final String displayName;
        private final Map<String, String> prefs;

        public CreateAccountRequestImpl(boolean active, String userName, String email, String displayName, Map<String, String> prefs) {
            this.active = active;
            this.userName = userName;
            this.email = email;
            this.displayName = displayName;
            this.prefs = prefs;
        }

        @Override
        public String getUserName() {
            return this.userName;
        }

        @Override
        public String getDisplayName() {
            return this.displayName;
        }

        @Override
        public String getEmail() {
            return this.email;
        }

        @Override
        public boolean isActive() {
            return this.active;
        }

        @Override
        public Map<String, String> getPreferences() {
            return this.prefs;
        }

        public String toString() {
            return "CreateAccountRequest [displayName=" + this.displayName + ", userName=" + this.userName + ", email=" + this.email + ", active=" + this.active + ", prefs=" + this.prefs + "]";
        }
    }
}

