/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.core.internal.search;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.function.BiConsumer;
import org.eclipse.osee.framework.core.applicability.FeatureDefinition;
import org.eclipse.osee.framework.core.data.ApplicabilityId;
import org.eclipse.osee.framework.core.data.ApplicabilityToken;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactReadable;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.ArtifactTypeToken;
import org.eclipse.osee.framework.core.data.AttributeTypeId;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.data.Branch;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.GammaId;
import org.eclipse.osee.framework.core.data.TransactionId;
import org.eclipse.osee.framework.core.data.TupleTypeId;
import org.eclipse.osee.framework.core.data.UserId;
import org.eclipse.osee.framework.core.enums.BranchType;
import org.eclipse.osee.framework.core.enums.CoreArtifactTokens;
import org.eclipse.osee.framework.core.enums.CoreArtifactTypes;
import org.eclipse.osee.framework.core.enums.CoreAttributeTypes;
import org.eclipse.osee.framework.core.enums.CoreRelationTypes;
import org.eclipse.osee.framework.core.enums.CoreTupleTypes;
import org.eclipse.osee.framework.core.enums.SystemUser;
import org.eclipse.osee.framework.jdk.core.type.Pair;
import org.eclipse.osee.framework.jdk.core.util.NamedComparator;
import org.eclipse.osee.framework.jdk.core.util.SortOrder;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.orcs.OrcsApi;
import org.eclipse.osee.orcs.core.ds.ApplicabilityDsQuery;
import org.eclipse.osee.orcs.data.TransactionReadable;
import org.eclipse.osee.orcs.search.ApplicabilityQuery;
import org.eclipse.osee.orcs.search.BranchQuery;
import org.eclipse.osee.orcs.search.QueryFactory;
import org.eclipse.osee.orcs.search.TransactionQuery;
import org.eclipse.osee.orcs.search.TupleQuery;
import org.eclipse.osee.orcs.transaction.TransactionBuilder;

public class ApplicabilityQueryImpl
implements ApplicabilityQuery {
    private final TupleQuery tupleQuery;
    private final ApplicabilityDsQuery applicabilityDsQuery;
    private final TransactionQuery transactionQuery;
    private final BranchQuery branchQuery;
    private final QueryFactory queryFactory;
    private final OrcsApi orcsApi;

    public ApplicabilityQueryImpl(ApplicabilityDsQuery applicabilityDsQuery, QueryFactory queryFactory, OrcsApi orcsApi) {
        this.orcsApi = orcsApi;
        this.tupleQuery = queryFactory.tupleQuery();
        this.applicabilityDsQuery = applicabilityDsQuery;
        this.transactionQuery = queryFactory.transactionQuery();
        this.branchQuery = queryFactory.branchQuery();
        this.queryFactory = queryFactory;
    }

    public ApplicabilityToken getApplicabilityToken(ArtifactId artId, BranchId branch) {
        return this.applicabilityDsQuery.getApplicabilityToken(artId, branch);
    }

    public List<Pair<ArtifactId, ApplicabilityToken>> getApplicabilityTokens(List<? extends ArtifactId> artIds, BranchId branch) {
        return this.applicabilityDsQuery.getApplicabilityTokens(artIds, branch);
    }

    public HashMap<Long, ApplicabilityToken> getApplicabilityTokens(BranchId branch) {
        HashMap<Long, ApplicabilityToken> tokens = new HashMap<Long, ApplicabilityToken>();
        BiConsumer<Long, String> consumer = (id, name) -> {
            ApplicabilityToken applicabilityToken = tokens.put((Long)id, new ApplicabilityToken(id, name));
        };
        this.tupleQuery.getTuple2UniqueE2Pair(CoreTupleTypes.ApplicabilityDefinition, branch, consumer);
        if (tokens.isEmpty()) {
            tokens.put(ApplicabilityToken.BASE.getId(), ApplicabilityToken.BASE);
        }
        return tokens;
    }

    public HashMap<Long, ApplicabilityToken> getApplicabilityTokens(BranchId branch1, BranchId branch2) {
        HashMap<Long, ApplicabilityToken> tokens = new HashMap<Long, ApplicabilityToken>();
        BiConsumer<Long, String> consumer = (id, name) -> {
            ApplicabilityToken applicabilityToken = tokens.put((Long)id, new ApplicabilityToken(id, name));
        };
        this.tupleQuery.getTuple2UniqueE2Pair(CoreTupleTypes.ApplicabilityDefinition, branch1, consumer);
        this.tupleQuery.getTuple2UniqueE2Pair(CoreTupleTypes.ApplicabilityDefinition, branch2, consumer);
        return tokens;
    }

    public List<ApplicabilityId> getApplicabilitiesReferenced(ArtifactId artifact, BranchId branch) {
        LinkedList<ApplicabilityId> appIds = new LinkedList<ApplicabilityId>();
        Iterable existingAppIds = this.tupleQuery.getTuple2(CoreTupleTypes.ArtifactReferenceApplicabilityType, branch, (Object)artifact);
        for (ApplicabilityId tuple2 : existingAppIds) {
            appIds.add(tuple2);
        }
        return appIds;
    }

    public List<ApplicabilityToken> getApplicabilityReferenceTokens(ArtifactId artifact, BranchId branch) {
        LinkedList<ApplicabilityToken> tokens = new LinkedList<ApplicabilityToken>();
        this.tupleQuery.getTuple2NamedId(CoreTupleTypes.ArtifactReferenceApplicabilityType, branch, (Object)artifact, (e2, value) -> {
            boolean bl = tokens.add(ApplicabilityToken.valueOf((long)e2, (String)value));
        });
        return tokens;
    }

    public List<ApplicabilityToken> getViewApplicabilityTokens(ArtifactId artId, BranchId branch) {
        ArrayList<ApplicabilityToken> result = new ArrayList<ApplicabilityToken>();
        BiConsumer<Long, String> consumer = (id, name) -> {
            boolean bl = result.add(new ApplicabilityToken(id, name));
        };
        this.tupleQuery.getTuple2KeyValuePair(CoreTupleTypes.ViewApplicability, (Object)artId, branch, consumer);
        return result;
    }

    public List<FeatureDefinition> getFeatureDefinitionData(BranchId branch) {
        BranchId branchToUse = branch;
        Branch br = (Branch)((BranchQuery)this.branchQuery.andId(branch)).getResults().getExactlyOne();
        if (br.getBranchType().equals((Object)BranchType.MERGE)) {
            branchToUse = br.getParentBranch();
        }
        ArrayList<FeatureDefinition> featureDefinition = new ArrayList<FeatureDefinition>();
        List featureArts = this.queryFactory.fromBranch(branchToUse).andIsOfType(new ArtifactTypeToken[]{CoreArtifactTypes.Feature}).asArtifacts();
        Collections.sort(featureArts, new NamedComparator(SortOrder.ASCENDING));
        for (ArtifactToken featureArt : featureArts) {
            ArtifactReadable art = (ArtifactReadable)featureArt;
            FeatureDefinition feature = new FeatureDefinition();
            feature.setId(art.getId());
            feature.setName(art.getName());
            feature.setDefaultValue((String)art.getSoleAttributeValue((AttributeTypeToken)CoreAttributeTypes.DefaultValue, (Object)""));
            feature.setValues(art.getAttributeValues((AttributeTypeToken)CoreAttributeTypes.Value));
            feature.setValueType(art.getSoleAttributeAsString((AttributeTypeToken)CoreAttributeTypes.FeatureValueType, ""));
            feature.setMultiValued(((Boolean)art.getSoleAttributeValue((AttributeTypeToken)CoreAttributeTypes.FeatureMultivalued, (Object)false)).booleanValue());
            feature.setDescription(art.getSoleAttributeAsString((AttributeTypeToken)CoreAttributeTypes.Description, ""));
            feature.setData((Object)featureArt);
            featureDefinition.add(feature);
        }
        return featureDefinition;
    }

    public Map<String, List<String>> getNamedViewApplicabilityMap(BranchId branch, ArtifactId viewId) {
        TreeMap<String, List<String>> toReturn = new TreeMap<String, List<String>>();
        List<ApplicabilityToken> appTokens = this.getViewApplicabilityTokens(viewId, branch);
        for (ApplicabilityToken app : appTokens) {
            String[] split;
            if (app.getName().equalsIgnoreCase("Base") || app.getName().contains("|") || app.getName().contains("&") || app.getName().toLowerCase().startsWith("Config =") || (split = app.getName().split("=")).length != 2) continue;
            String name = split[0].trim();
            String value = split[1].trim();
            if (toReturn.containsKey(name)) {
                ArrayList<String> list = new ArrayList<String>();
                list.addAll((Collection)toReturn.get(name));
                list.add(value);
                toReturn.put(name, list);
                continue;
            }
            toReturn.put(name, Arrays.asList(value));
        }
        return toReturn;
    }

    public boolean applicabilityExistsOnBranchView(BranchId branch, ArtifactId viewId, String applicability) {
        ArrayList tuples = new ArrayList();
        this.queryFactory.tupleQuery().getTuple2GammaFromE1E2(CoreTupleTypes.ViewApplicability, branch, (Object)viewId, (Object)applicability, tuples::add);
        return !tuples.isEmpty();
    }

    public String getExistingFeatureApplicability(BranchId branch, ArtifactId viewId, String featureName) {
        String existingAppl = "";
        for (String appl : this.queryFactory.tupleQuery().getTuple2(CoreTupleTypes.ViewApplicability, branch, (Object)viewId)) {
            if (!(appl.startsWith(String.valueOf(featureName) + " =") & !appl.contains("|") & !appl.contains("&"))) continue;
            existingAppl = appl;
        }
        return existingAppl;
    }

    public List<ArtifactId> getBranchViewsForApplicability(BranchId branch, ApplicabilityId applId) {
        ArrayList<ArtifactId> arts = new ArrayList<ArtifactId>();
        for (Long long1 : this.queryFactory.tupleQuery().getTuple2E1ListRaw(CoreTupleTypes.ViewApplicability, branch, applId.getId())) {
            arts.add(ArtifactId.valueOf((Long)long1));
        }
        return arts;
    }

    public boolean featureExistsOnBranch(BranchId branch, String featureName) {
        if (ApplicabilityToken.BASE.getName().equals(featureName)) {
            return true;
        }
        ArtifactId feature = this.queryFactory.fromBranch(branch).andTypeEquals(new ArtifactTypeToken[]{CoreArtifactTypes.Feature}).andAttributeIs((AttributeTypeId)CoreAttributeTypes.Name, featureName).asArtifactIdOrSentinel();
        boolean returnValue = feature.isValid();
        return returnValue;
    }

    public boolean featureValueIsValid(BranchId branch, String featureName, String featureValue) {
        return true;
    }

    public List<ArtifactToken> getViewsForBranch(BranchId branch) {
        List views = this.queryFactory.fromBranch(branch).andIsOfType(new ArtifactTypeToken[]{CoreArtifactTypes.BranchView}).asArtifactTokens();
        List cfgGrps = this.queryFactory.fromBranch(branch).andIsOfType(new ArtifactTypeToken[]{CoreArtifactTypes.GroupArtifact}).andRelatedTo(CoreRelationTypes.DefaultHierarchical_Parent, (ArtifactId)CoreArtifactTokens.PlCfgGroupsFolder).asArtifactTokens();
        if (!cfgGrps.isEmpty()) {
            views.addAll(cfgGrps);
        }
        return views;
    }

    public List<ArtifactToken> getConfigurationsForBranch(BranchId branch) {
        return this.queryFactory.fromBranch(branch).andIsOfType(new ArtifactTypeToken[]{CoreArtifactTypes.BranchView}).asArtifactTokens();
    }

    public List<ArtifactToken> getConfigurationGroupsForBranch(BranchId branch) {
        List views = this.queryFactory.fromBranch(branch).andIsOfType(new ArtifactTypeToken[]{CoreArtifactTypes.GroupArtifact}).andRelatedTo(CoreRelationTypes.DefaultHierarchical_Parent, (ArtifactId)CoreArtifactTokens.PlCfgGroupsFolder).asArtifactTokens();
        return views;
    }

    public boolean viewExistsOnBranch(BranchId branch, ArtifactId viewId) {
        Boolean returnValue = false;
        for (ArtifactToken view : this.getViewsForBranch(branch)) {
            if (!view.equals(viewId)) continue;
            returnValue = true;
            break;
        }
        return returnValue;
    }

    public ArtifactToken getViewByName(BranchId branch, String viewName) {
        ArtifactToken viewToken = ArtifactToken.SENTINEL;
        for (ArtifactToken view : this.getViewsForBranch(branch)) {
            if (!view.getName().equals(viewName)) continue;
            viewToken = view;
            break;
        }
        return viewToken;
    }

    public String getViewTable(BranchId branch, String filter) {
        return this.getConfigMatrix(branch, "all", filter);
    }

    private void printTable(StringBuilder html, List<ArtifactToken> branchViews, BranchId branch, String filter) {
        html.append("<table border=\"1\">");
        if (Strings.isValid((String)filter)) {
            branchViews.removeIf(art -> art.getName().matches(filter));
        }
        List<FeatureDefinition> featureDefinitionData = this.getFeatureDefinitionData(branch);
        Collections.sort(featureDefinitionData, new Comparator<FeatureDefinition>(){

            @Override
            public int compare(FeatureDefinition obj1, FeatureDefinition obj2) {
                return obj1.getName().compareTo(obj2.getName());
            }
        });
        this.printColumnHeadings(html, branchViews, branch);
        HashMap<ArtifactId, Map<String, List<String>>> branchViewsMap = new HashMap<ArtifactId, Map<String, List<String>>>();
        for (ArtifactId artifactId : branchViews) {
            branchViewsMap.put(artifactId, this.getNamedViewApplicabilityMap(branch, artifactId));
        }
        for (FeatureDefinition featureDefinition : featureDefinitionData) {
            html.append("<tr>");
            html.append(String.format("<td>%s</td>", featureDefinition.getName()));
            html.append(String.format("<td>%s</td>", featureDefinition.getDescription()));
            for (ArtifactId artifactId : branchViews) {
                List list = (List)((Map)branchViewsMap.get(artifactId)).get(featureDefinition.getName());
                if (list != null) {
                    html.append("<td>" + org.eclipse.osee.framework.jdk.core.util.Collections.toString((String)",", (Iterable)list) + "</td>");
                    continue;
                }
                html.append("<td> </td>");
            }
            html.append("</tr>");
        }
        html.append("</table>");
    }

    public String getConfigMatrix(BranchId branch, String matrixType, String filter) {
        StringBuilder html = this.getHtmlStart();
        ArrayList<ArtifactToken> branchViews = new ArrayList();
        if (matrixType.equals("configs")) {
            html.append(String.format("<h3>Configurations Feature Matrix for branch: %s</h3>", ((Branch)((BranchQuery)this.branchQuery.andId(branch)).getResults().getExactlyOne()).getName()));
            branchViews = this.getConfigurationsForBranch(branch);
            this.printTable(html, branchViews, branch, filter);
        } else if (matrixType.equals("groups")) {
            html.append(String.format("<h3>Configuration Groups Feature Matrix for branch: %s</h3>", ((Branch)((BranchQuery)this.branchQuery.andId(branch)).getResults().getExactlyOne()).getName()));
            branchViews = this.getConfigurationGroupsForBranch(branch);
            this.printTable(html, branchViews, branch, filter);
        } else if (matrixType.equals("all")) {
            html.append(String.format("<h3>Configurations and Groups Feature Matrix for branch: %s</h3>", ((Branch)((BranchQuery)this.branchQuery.andId(branch)).getResults().getExactlyOne()).getName()));
            branchViews = this.getViewsForBranch(branch);
            this.printTable(html, branchViews, branch, filter);
        } else {
            html.append(String.format("<h3>Configuration Groups Feature Matrix for branch: %s</h3>", ((Branch)((BranchQuery)this.branchQuery.andId(branch)).getResults().getExactlyOne()).getName()));
            branchViews = this.getConfigurationGroupsForBranch(branch);
            this.printTable(html, branchViews, branch, filter);
            html.append(String.format("<h3>Configurations Feature Matrix for branch: %s</h3>", ((Branch)((BranchQuery)this.branchQuery.andId(branch)).getResults().getExactlyOne()).getName()));
            branchViews = this.getConfigurationsForBranch(branch);
            this.printTable(html, branchViews, branch, filter);
        }
        html.append("</body></html>");
        return html.toString();
    }

    private StringBuilder getHtmlStart() {
        StringBuilder html = new StringBuilder("<!DOCTYPE html><html><head><style> table { border-spacing: 0px } th,td { padding: 3px; } </style></head><body>");
        return html;
    }

    private void printColumnHeadings(StringBuilder html, List<ArtifactToken> branchViews, BranchId branch) {
        html.append("<tr>");
        html.append("<th>Feature Name</th>");
        html.append("<th>Feature Description</th>");
        for (ArtifactToken artId : branchViews) {
            html.append(String.format("<th>%s</th>", artId.getName()));
        }
        html.append("</tr>");
    }

    public ArtifactId getVersionConfig(ArtifactId art, BranchId branch) {
        Iterable tuple2 = this.tupleQuery.getTuple2Raw(CoreTupleTypes.VersionConfig, branch, (Object)art);
        if (tuple2.iterator().hasNext()) {
            return ArtifactId.valueOf((Long)((Long)tuple2.iterator().next()));
        }
        return ArtifactId.SENTINEL;
    }

    public List<BranchId> getAffectedBranches(Long injectDateMs, Long removalDateMs, List<ApplicabilityId> applicabilityIds, BranchId branch) {
        ArrayList<BranchId> toReturn = new ArrayList<BranchId>();
        if (injectDateMs == null || removalDateMs == null || applicabilityIds == null) {
            return toReturn;
        }
        Date injection = new Date(injectDateMs);
        Date removal = new Date(removalDateMs);
        List branchList = ((BranchQuery)((BranchQuery)this.branchQuery.andIsOfType(new BranchType[]{BranchType.BASELINE})).andIsChildOf(branch)).getResults().getList();
        HashMap<Long, ApplicabilityId> applicabilityIdsMap = new HashMap<Long, ApplicabilityId>();
        for (ApplicabilityId applicId : applicabilityIds) {
            applicabilityIdsMap.put(applicId.getId(), applicId);
        }
        for (Branch baseBranch : branchList) {
            Date baseDate = ((TransactionReadable)((TransactionQuery)this.transactionQuery.andTxId(baseBranch.getBaselineTx())).getResults().getExactlyOne()).getDate();
            if (!baseDate.after(injection) || removalDateMs != -1L && !baseDate.before(removal)) continue;
            block2: for (ArtifactId artifactId : this.getViewsForBranch((BranchId)baseBranch)) {
                List<ApplicabilityToken> viewApplicabilityTokens = this.getViewApplicabilityTokens(artifactId, (BranchId)baseBranch);
                for (ApplicabilityToken applicToken : viewApplicabilityTokens) {
                    if (!applicabilityIdsMap.containsKey(applicToken.getId())) continue;
                    toReturn.add(BranchId.create((Long)baseBranch.getId(), (ArtifactId)artifactId));
                    continue block2;
                }
            }
        }
        return toReturn;
    }

    public List<BranchId> getAffectedBranches(TransactionId injectionTx, TransactionId removalTx, List<ApplicabilityId> applicabilityIds, BranchId branch) {
        long timeInjectionMs = ((TransactionReadable)((TransactionQuery)this.transactionQuery.andTxId(injectionTx)).getResults().getExactlyOne()).getDate().getTime();
        long timeRemovalMs = removalTx.isInvalid() ? -1L : ((TransactionReadable)((TransactionQuery)this.transactionQuery.andTxId(removalTx)).getResults().getExactlyOne()).getDate().getTime();
        return this.getAffectedBranches(timeInjectionMs, timeRemovalMs, applicabilityIds, branch);
    }

    public Set<ArtifactId> getExcludedArtifacts(BranchId branch, ArtifactId view) {
        return this.applicabilityDsQuery.getExcludedArtifacts(branch, view);
    }

    public List<String> initializeAllApplicabilityTuples(BranchId branch) {
        String str;
        TransactionBuilder tx = this.orcsApi.getTransactionFactory().createTransaction(branch, (UserId)SystemUser.OseeSystem, "Adding Tuple2 Entires fro ApplicabilityDefinition Type");
        TupleQuery query = this.orcsApi.getQueryFactory().tupleQuery();
        GammaId gamma = GammaId.SENTINEL;
        gamma = query.getTuple2GammaFromE1E2(CoreTupleTypes.ApplicabilityDefinition, (Object)ArtifactId.valueOf((int)0), (Object)"Base");
        if (!gamma.isValid()) {
            tx.addTuple2(CoreTupleTypes.ApplicabilityDefinition, (Object)ArtifactId.valueOf((int)0), (Object)"Base");
        } else {
            tx.introduceTuple((TupleTypeId)CoreTupleTypes.ApplicabilityDefinition, gamma);
        }
        ArrayList<String> apps = new ArrayList<String>();
        HashMap<Long, ApplicabilityToken> appTokens = this.getApplicabilityTokens(branch);
        for (ApplicabilityToken app : appTokens.values()) {
            apps.add(app.getName());
        }
        ArrayList<String> applicsNoArtifacts = new ArrayList<String>();
        applicsNoArtifacts.addAll(apps);
        applicsNoArtifacts.remove("Base");
        for (ArtifactToken view : this.getConfigurationsForBranch(branch)) {
            gamma = query.getTuple2GammaFromE1E2(CoreTupleTypes.ApplicabilityDefinition, (Object)view, (Object)(str = "Config = " + view.getName()));
            if (!gamma.isValid()) {
                tx.addTuple2(CoreTupleTypes.ApplicabilityDefinition, (Object)view, (Object)str);
            } else {
                tx.introduceTuple((TupleTypeId)CoreTupleTypes.ApplicabilityDefinition, gamma);
            }
            if (!apps.contains(str)) {
                apps.add(str);
            }
            applicsNoArtifacts.remove(str);
        }
        for (FeatureDefinition feature : this.getFeatureDefinitionData(branch)) {
            for (String val : feature.getValues()) {
                String str2 = String.valueOf(feature.getName()) + " = " + val;
                gamma = query.getTuple2GammaFromE1E2(CoreTupleTypes.ApplicabilityDefinition, (Object)ArtifactId.valueOf((Long)feature.getId()), (Object)str2);
                if (!gamma.isValid()) {
                    tx.addTuple2(CoreTupleTypes.ApplicabilityDefinition, (Object)ArtifactId.valueOf((Long)feature.getId()), (Object)str2);
                } else {
                    tx.introduceTuple((TupleTypeId)CoreTupleTypes.ApplicabilityDefinition, gamma);
                }
                if (!apps.contains(str2)) {
                    apps.add(str2);
                }
                applicsNoArtifacts.remove(str2);
            }
        }
        for (ArtifactToken group : this.getConfigurationGroupsForBranch(branch)) {
            gamma = query.getTuple2GammaFromE1E2(CoreTupleTypes.ApplicabilityDefinition, (Object)group, (Object)(str = "ConfigurationGroup = " + group.getName()));
            if (!gamma.isValid()) {
                tx.addTuple2(CoreTupleTypes.ApplicabilityDefinition, (Object)group, (Object)str);
            } else {
                tx.introduceTuple((TupleTypeId)CoreTupleTypes.ApplicabilityDefinition, gamma);
            }
            if (!apps.contains(str)) {
                apps.add(str);
            }
            applicsNoArtifacts.remove(str);
        }
        for (String app : applicsNoArtifacts) {
            gamma = query.getTuple2GammaFromE1E2(CoreTupleTypes.ApplicabilityDefinition, (Object)ArtifactId.valueOf((int)0), (Object)app);
            if (!gamma.isValid()) {
                tx.addTuple2(CoreTupleTypes.ApplicabilityDefinition, (Object)ArtifactId.valueOf((int)0), (Object)app);
                continue;
            }
            tx.introduceTuple((TupleTypeId)CoreTupleTypes.ApplicabilityDefinition, gamma);
        }
        tx.commit();
        ArrayList<String> appsNoDups = new ArrayList<String>(new HashSet(apps));
        Collections.sort(appsNoDups);
        return appsNoDups;
    }
}

