/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.define.api.synchronization;

import java.util.Arrays;
import java.util.Objects;
import java.util.function.Predicate;
import org.eclipse.osee.define.api.synchronization.Root;
import org.eclipse.osee.framework.jdk.core.util.IndentedString;
import org.eclipse.osee.framework.jdk.core.util.ToMessage;

public class ExportRequest
implements ToMessage {
    private String synchronizationArtifactType;
    private Root[] roots;

    public ExportRequest() {
        this.synchronizationArtifactType = null;
        this.roots = null;
    }

    public ExportRequest(String synchronizationArtifactType, Root[] roots) {
        this.synchronizationArtifactType = Objects.requireNonNull(synchronizationArtifactType, "ExportRequest::new, the parameter \"synchronizationArtifactType\" is null.");
        this.roots = Objects.requireNonNull(roots, "ExportRequest::new, the parameter \"roots\" is null.");
    }

    public Root[] getRoots() {
        if (Objects.isNull(this.roots)) {
            StringBuilder message = new StringBuilder(1024).append("ExportRequest::getRoots, the member \"roots\" has not been set.").append("\n").append("\n");
            this.toMessage(1, message);
            throw new IllegalStateException(message.toString());
        }
        return this.roots;
    }

    public String getSynchronizationArtifactType() {
        if (Objects.isNull(this.synchronizationArtifactType)) {
            StringBuilder message = new StringBuilder(1024).append("ExportRequest::getSynchronizationArtifactType, the member \"synchronizationArtifactType\" has not been set.").append("\n").append("\n");
            this.toMessage(1, message);
            throw new IllegalStateException(message.toString());
        }
        return this.synchronizationArtifactType;
    }

    public boolean isValid() {
        return Objects.nonNull(this.synchronizationArtifactType) && Objects.nonNull(this.roots) && !Arrays.stream(this.roots).anyMatch(Predicate.not(Root::isValid));
    }

    public void setRoots(Root[] roots) {
        if (Objects.nonNull(this.roots)) {
            StringBuilder message = new StringBuilder(1024).append("ExportRequest::setRoots, the member \"roots\" has already been set.").append("\n").append("\n");
            this.toMessage(1, message);
            throw new IllegalStateException(message.toString());
        }
        this.roots = Objects.requireNonNull(roots, "ExportRequest::setRoots, the parameter \"roots\" is null.");
    }

    public void setSynchronizationArtifactType(String synchronizationArtifactType) {
        if (Objects.nonNull(this.synchronizationArtifactType)) {
            StringBuilder message = new StringBuilder(1024).append("ExportRequest::getSynchronizationArtifactType, the member \"synchronizationArtifactType\" has already been set.").append("\n").append("\n");
            this.toMessage(1, message);
            throw new IllegalStateException(message.toString());
        }
        this.synchronizationArtifactType = Objects.requireNonNull(synchronizationArtifactType, "ExportRequest::new, the parameter \"synchronizationArtifactType\" is null.");
    }

    public StringBuilder toMessage(int indent, StringBuilder message) {
        StringBuilder outMessage = message != null ? message : new StringBuilder(1024);
        String indent0 = IndentedString.indentString((int)(indent + 0));
        String indent1 = IndentedString.indentString((int)(indent + 1));
        outMessage.append(indent0).append("ExportRequest:").append("\n").append(indent1).append("synchronizationArtifactType: ").append(Objects.nonNull(this.synchronizationArtifactType) ? this.synchronizationArtifactType : "(null)").append("\n").append(indent1).append("roots:                       ");
        if (Objects.nonNull(this.roots)) {
            outMessage.append("\n");
            Arrays.stream(this.roots).forEach(root -> {
                StringBuilder stringBuilder2 = root.toMessage(2, outMessage);
            });
        } else {
            outMessage.append("(null)").append("\n");
        }
        return outMessage;
    }

    public String toString() {
        return this.toMessage(0, null).toString();
    }
}

