/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.mim.internal;

import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactReadable;
import org.eclipse.osee.framework.core.data.AttributeTypeId;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.RelationTypeSide;
import org.eclipse.osee.framework.core.enums.CoreAttributeTypes;
import org.eclipse.osee.framework.core.enums.CoreRelationTypes;
import org.eclipse.osee.mim.ArtifactAccessor;
import org.eclipse.osee.mim.InterfacePlatformTypeApi;
import org.eclipse.osee.mim.internal.PlatformTypeAccessor;
import org.eclipse.osee.mim.types.InterfaceEnumerationSet;
import org.eclipse.osee.mim.types.MimAttributeQuery;
import org.eclipse.osee.mim.types.PlatformTypeToken;
import org.eclipse.osee.orcs.OrcsApi;

public class InterfacePlatformTypeApiImpl
implements InterfacePlatformTypeApi {
    private ArtifactAccessor<PlatformTypeToken> accessor;
    private final List<AttributeTypeId> attributes;

    InterfacePlatformTypeApiImpl(OrcsApi orcsApi) {
        this.setAccessor(new PlatformTypeAccessor(orcsApi));
        this.attributes = this.createAttributeList();
    }

    @Override
    public ArtifactAccessor<PlatformTypeToken> getAccessor() {
        return this.accessor;
    }

    private void setAccessor(ArtifactAccessor<PlatformTypeToken> accessor) {
        this.accessor = accessor;
    }

    @Override
    public Collection<PlatformTypeToken> query(BranchId branch, MimAttributeQuery query) {
        return this.query(branch, query, false);
    }

    @Override
    public PlatformTypeToken get(BranchId branch, ArtifactId platformTypeId) {
        try {
            return this.getAccessor().get(branch, platformTypeId, PlatformTypeToken.class);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException ex) {
            System.out.println(ex);
            return PlatformTypeToken.SENTINEL;
        }
    }

    @Override
    public PlatformTypeToken getWithElementRelations(BranchId branch, ArtifactId platformTypeId) {
        try {
            return this.getAccessor().get(branch, platformTypeId, Arrays.asList(CoreRelationTypes.InterfaceElementPlatformType_Element), PlatformTypeToken.class);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException ex) {
            System.out.println(ex);
            return PlatformTypeToken.SENTINEL;
        }
    }

    @Override
    public PlatformTypeToken getWithRelations(BranchId branch, ArtifactId platformTypeId, List<RelationTypeSide> relationTypes) {
        try {
            return this.getAccessor().get(branch, platformTypeId, relationTypes, PlatformTypeToken.class);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException ex) {
            System.out.println(ex);
            return PlatformTypeToken.SENTINEL;
        }
    }

    @Override
    public PlatformTypeToken getWithAllParentRelations(BranchId branch, ArtifactId platformTypeId) {
        List<RelationTypeSide> relations = Arrays.asList(CoreRelationTypes.InterfaceElementPlatformType_Element, CoreRelationTypes.InterfaceStructureContent_Structure, CoreRelationTypes.InterfaceSubMessageContent_SubMessage, CoreRelationTypes.InterfaceMessageSubMessageContent_Message, CoreRelationTypes.InterfaceConnectionContent_Connection);
        return this.getWithRelations(branch, platformTypeId, relations);
    }

    @Override
    public List<PlatformTypeToken> getAllFromEnumerationSet(InterfaceEnumerationSet enumSet) {
        return enumSet.getArtifactReadable().getRelatedList(CoreRelationTypes.InterfacePlatformTypeEnumeration_Element).stream().filter(a -> !a.getExistingAttributeTypes().isEmpty()).map(a -> new PlatformTypeToken((ArtifactReadable)a)).collect(Collectors.toList());
    }

    @Override
    public List<PlatformTypeToken> getAllWithRelations(BranchId branch, List<RelationTypeSide> relationTypes) {
        try {
            return (List)this.getAccessor().getAll(branch, relationTypes, PlatformTypeToken.class);
        }
        catch (Exception exception) {
            return new LinkedList<PlatformTypeToken>();
        }
    }

    @Override
    public List<PlatformTypeToken> getFilteredWithRelations(BranchId branch, String filter, List<RelationTypeSide> relationTypes) {
        try {
            return (List)this.getAccessor().getAllByFilter(branch, filter, this.attributes, relationTypes, PlatformTypeToken.class);
        }
        catch (Exception exception) {
            return new LinkedList<PlatformTypeToken>();
        }
    }

    @Override
    public List<PlatformTypeToken> getAllWithElementRelations(BranchId branch) {
        return this.getAllWithRelations(branch, Arrays.asList(CoreRelationTypes.InterfaceElementPlatformType_Element));
    }

    @Override
    public List<PlatformTypeToken> getFilteredWithElementRelations(BranchId branch, String filter) {
        return this.getFilteredWithRelations(branch, filter, Arrays.asList(CoreRelationTypes.InterfaceElementPlatformType_Element));
    }

    private List<AttributeTypeId> createAttributeList() {
        LinkedList<AttributeTypeId> attributes = new LinkedList<AttributeTypeId>();
        attributes.add((AttributeTypeId)CoreAttributeTypes.Name);
        attributes.add((AttributeTypeId)CoreAttributeTypes.Description);
        attributes.add((AttributeTypeId)CoreAttributeTypes.InterfaceLogicalType);
        attributes.add((AttributeTypeId)CoreAttributeTypes.InterfacePlatformType2sComplement);
        attributes.add((AttributeTypeId)CoreAttributeTypes.InterfacePlatformTypeAnalogAccuracy);
        attributes.add((AttributeTypeId)CoreAttributeTypes.InterfacePlatformTypeBitSize);
        attributes.add((AttributeTypeId)CoreAttributeTypes.InterfacePlatformTypeBitsResolution);
        attributes.add((AttributeTypeId)CoreAttributeTypes.InterfacePlatformTypeCompRate);
        attributes.add((AttributeTypeId)CoreAttributeTypes.InterfacePlatformTypeDefaultValue);
        attributes.add((AttributeTypeId)CoreAttributeTypes.InterfacePlatformTypeEnumLiteral);
        attributes.add((AttributeTypeId)CoreAttributeTypes.InterfacePlatformTypeMaxval);
        attributes.add((AttributeTypeId)CoreAttributeTypes.InterfacePlatformTypeMinval);
        attributes.add((AttributeTypeId)CoreAttributeTypes.InterfacePlatformTypeMsbValue);
        attributes.add((AttributeTypeId)CoreAttributeTypes.InterfacePlatformTypeUnits);
        attributes.add((AttributeTypeId)CoreAttributeTypes.InterfacePlatformTypeValidRangeDescription);
        return attributes;
    }

    @Override
    public Collection<PlatformTypeToken> queryExact(BranchId branch, MimAttributeQuery query) {
        return this.query(branch, query, true);
    }

    @Override
    public Collection<PlatformTypeToken> query(BranchId branch, MimAttributeQuery query, boolean isExact) {
        try {
            return this.getAccessor().getAllByQuery(branch, query, isExact, PlatformTypeToken.class);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException ex) {
            System.out.println(ex);
            return new LinkedList<PlatformTypeToken>();
        }
    }
}

