/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.mim.internal;

import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.eclipse.osee.ats.api.AtsApi;
import org.eclipse.osee.ats.api.IAtsWorkItem;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactReadable;
import org.eclipse.osee.framework.core.data.ArtifactTypeId;
import org.eclipse.osee.framework.core.data.ArtifactTypeToken;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.data.Branch;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.enums.CoreArtifactTypes;
import org.eclipse.osee.framework.core.enums.CoreAttributeTypes;
import org.eclipse.osee.framework.core.enums.CoreRelationTypes;
import org.eclipse.osee.framework.core.enums.token.InterfaceStructureCategoryAttribute;
import org.eclipse.osee.framework.jdk.core.util.io.excel.ExcelWorkbookWriter;
import org.eclipse.osee.mim.InterfaceDifferenceReportApi;
import org.eclipse.osee.mim.InterfaceMessageApi;
import org.eclipse.osee.mim.InterfaceStructureApi;
import org.eclipse.osee.mim.MimApi;
import org.eclipse.osee.mim.types.InterfaceMessageToken;
import org.eclipse.osee.mim.types.InterfaceNode;
import org.eclipse.osee.mim.types.InterfaceStructureElementToken;
import org.eclipse.osee.mim.types.InterfaceStructureToken;
import org.eclipse.osee.mim.types.InterfaceSubMessageToken;
import org.eclipse.osee.mim.types.MimDifferenceItem;
import org.eclipse.osee.mim.types.PlatformTypeToken;
import org.eclipse.osee.orcs.OrcsApi;
import org.eclipse.osee.orcs.data.TransactionReadable;
import org.eclipse.osee.orcs.search.BranchQuery;
import org.eclipse.osee.orcs.search.TransactionQuery;

public class IcdGenerator {
    private final OrcsApi orcsApi;
    private final AtsApi atsApi;
    private final InterfaceMessageApi interfaceMessageApi;
    private final InterfaceStructureApi interfaceStructureApi;
    private final InterfaceDifferenceReportApi interfaceDifferenceReportApi;
    private final Map<ArtifactId, StructureInfo> structuresList;
    private final Map<String, StructureInfo> headersList;
    private final Map<ArtifactId, InterfaceSubMessageToken> messageHeaders;
    private final Map<String, InterfaceStructureToken> messageHeaderStructures;
    private Map<ArtifactId, MimDifferenceItem> diffs;

    public IcdGenerator(MimApi mimApi) {
        this.orcsApi = mimApi.getOrcsApi();
        this.atsApi = mimApi.getAtsApi();
        this.structuresList = new HashMap<ArtifactId, StructureInfo>();
        this.headersList = new HashMap<String, StructureInfo>();
        this.messageHeaders = new HashMap<ArtifactId, InterfaceSubMessageToken>();
        this.messageHeaderStructures = new HashMap<String, InterfaceStructureToken>();
        this.diffs = new HashMap<ArtifactId, MimDifferenceItem>();
        this.interfaceMessageApi = mimApi.getInterfaceMessageApi();
        this.interfaceStructureApi = mimApi.getInterfaceStructureApi();
        this.interfaceDifferenceReportApi = mimApi.getInterfaceDifferenceReportApi();
    }

    public void runOperation(OutputStream outputStream, BranchId branch, ArtifactId view, ArtifactId connectionId) {
        ArtifactReadable conn = this.orcsApi.getQueryFactory().fromBranch(branch).andIsOfType(new ArtifactTypeToken[]{CoreArtifactTypes.InterfaceConnection}).andId(connectionId).follow(CoreRelationTypes.InterfaceConnectionContent_Message).follow(CoreRelationTypes.InterfaceMessageSubMessageContent_SubMessage).follow(CoreRelationTypes.InterfaceSubMessageContent_Structure).asArtifact();
        ArtifactReadable primaryNode = this.orcsApi.getQueryFactory().fromBranch(branch).andIsOfType(new ArtifactTypeToken[]{CoreArtifactTypes.InterfaceNode}).andId((ArtifactId)conn.getRelated(CoreRelationTypes.InterfaceConnectionPrimary_Node).getAtMostOneOrDefault((Object)ArtifactReadable.SENTINEL)).asArtifact();
        ArtifactReadable secondaryNode = this.orcsApi.getQueryFactory().fromBranch(branch).andIsOfType(new ArtifactTypeToken[]{CoreArtifactTypes.InterfaceNode}).andId((ArtifactId)conn.getRelated(CoreRelationTypes.InterfaceConnectionSecondary_Node).getAtMostOneOrDefault((Object)ArtifactReadable.SENTINEL)).asArtifact();
        List messages = conn.getRelated(CoreRelationTypes.InterfaceConnectionContent_Message).getList();
        ArrayList<ArtifactReadable> subMessages = new ArrayList<ArtifactReadable>();
        LinkedList<InterfaceSubMessageToken> subMessagesWithHeaders = new LinkedList<InterfaceSubMessageToken>();
        ArrayList<InterfaceStructureToken> structures = new ArrayList<InterfaceStructureToken>();
        TreeMap<InterfaceStructureToken, String> structureLinks = new TreeMap<InterfaceStructureToken, String>();
        for (ArtifactReadable message : messages) {
            ArtifactReadable sendingNode = ((ArtifactReadable)message.getRelated(CoreRelationTypes.InterfaceMessageSendingNode_Node).getAtMostOneOrDefault((Object)ArtifactReadable.SENTINEL)).getIdString().equalsIgnoreCase(primaryNode.getIdString()) ? primaryNode : secondaryNode;
            InterfaceMessageToken msg = new InterfaceMessageToken(message);
            msg.setInitiatingNode(new InterfaceNode(sendingNode));
            List messageSubMessages = message.getRelated(CoreRelationTypes.InterfaceMessageSubMessageContent_SubMessage).getList();
            List smsgTokens = messageSubMessages.stream().map(art -> new InterfaceSubMessageToken((ArtifactReadable)art)).collect(Collectors.toList());
            if (message.getSoleAttributeAsString((AttributeTypeToken)CoreAttributeTypes.InterfaceMessageType, "error").equals("Operational")) {
                InterfaceSubMessageToken header = this.interfaceMessageApi.getMessageHeader(msg);
                this.messageHeaders.put(ArtifactId.valueOf((Long)message.getId()), header);
                smsgTokens.add(0, header);
                InterfaceStructureToken headerStruct = this.interfaceStructureApi.getMessageHeaderStructure(branch, ArtifactId.valueOf((Long)message.getId()));
                this.messageHeaderStructures.put(header.getName(), headerStruct);
            }
            subMessages.addAll(messageSubMessages);
            subMessagesWithHeaders.addAll(smsgTokens);
            for (InterfaceSubMessageToken smsg : smsgTokens) {
                LinkedList<InterfaceStructureToken> structs = new LinkedList<InterfaceStructureToken>();
                if (smsg.getId() == 0L) {
                    structs.add(0, this.interfaceStructureApi.getMessageHeaderStructure(branch, ArtifactId.valueOf((Long)message.getId())));
                } else {
                    structs.addAll(smsg.getArtifactReadable().getRelated(CoreRelationTypes.InterfaceSubMessageContent_Structure).getList().stream().map(art -> new InterfaceStructureToken((ArtifactReadable)art)).collect(Collectors.toList()));
                }
                structures.addAll(structs);
            }
        }
        int worksheetIndex = 0;
        for (InterfaceStructureToken structure : structures) {
            String abbrevName;
            ++worksheetIndex;
            String sheetName = structure.getName().replace("Command Taskfile", "CT").replace("Status Taskfile", "ST");
            if (sheetName.length() > 30) {
                sheetName = String.valueOf(sheetName.substring(0, 25)) + "_" + Integer.toString(worksheetIndex);
            }
            if (structure.getArtifactReadable() != null && !(abbrevName = structure.getArtifactReadable().getSoleAttributeAsString((AttributeTypeToken)CoreAttributeTypes.GeneralStringData, "null")).equals("null")) {
                sheetName = abbrevName;
            }
            structureLinks.put(structure, sheetName);
        }
        BranchId parentBranch = ((Branch)((BranchQuery)this.orcsApi.getQueryFactory().branchQuery().andId(branch)).getResults().getList().get(0)).getParentBranch();
        this.diffs = this.interfaceDifferenceReportApi.getDifferences(branch, parentBranch);
        this.createStructureInfo(branch, view, primaryNode, secondaryNode, messages);
        ExcelWorkbookWriter writer = new ExcelWorkbookWriter(outputStream, ExcelWorkbookWriter.WorkbookFormat.XLS);
        this.createChangeSummary(writer, branch);
        this.createMessageSubMessageSummary(writer, conn, primaryNode, secondaryNode, messages, subMessages);
        this.createStructureNamesSheet(writer, structureLinks);
        this.createStructureSummarySheet(writer, branch, view, primaryNode, secondaryNode, messages, structureLinks);
        this.createStructureSheets(writer, view, subMessagesWithHeaders, structures, structureLinks);
        writer.writeWorkbook();
        writer.closeWorkbook();
    }

    private void createStructureInfo(BranchId branch, ArtifactId view, ArtifactReadable primaryNode, ArtifactReadable secondaryNode, List<ArtifactReadable> messages) {
        for (ArtifactReadable message : messages) {
            String msgRateText;
            ArtifactReadable sendingNode = ((ArtifactReadable)message.getRelated(CoreRelationTypes.InterfaceMessageSendingNode_Node).getAtMostOneOrDefault((Object)ArtifactReadable.SENTINEL)).getIdString().equalsIgnoreCase(primaryNode.getIdString()) ? primaryNode : secondaryNode;
            String msgNumber = message.getSoleAttributeAsString((AttributeTypeToken)CoreAttributeTypes.InterfaceMessageNumber, "0");
            int msgRate = -1;
            String msgPeriodicity = message.getSoleAttributeAsString((AttributeTypeToken)CoreAttributeTypes.InterfaceMessagePeriodicity, "Aperiodic");
            if (msgPeriodicity.equals("Periodic")) {
                msgRateText = message.getSoleAttributeAsString((AttributeTypeToken)CoreAttributeTypes.InterfaceMessageRate, "Error");
                try {
                    msgRate = Integer.parseInt(msgRateText);
                }
                catch (NumberFormatException numberFormatException) {}
            } else {
                msgRateText = msgPeriodicity;
            }
            if (message.getExistingAttributeTypes().contains(CoreAttributeTypes.InterfaceMessageRate)) {
                msgRateText = message.getSoleAttributeAsString((AttributeTypeToken)CoreAttributeTypes.InterfaceMessageRate, "Error");
                try {
                    msgRate = Integer.parseInt(msgRateText);
                }
                catch (NumberFormatException numberFormatException) {}
                if (msgPeriodicity.equals("Aperiodic")) {
                    msgRateText = String.valueOf(msgRateText) + "-A";
                }
            }
            List subMessages = message.getRelated(CoreRelationTypes.InterfaceMessageSubMessageContent_SubMessage).getList().stream().map(art -> new InterfaceSubMessageToken((ArtifactReadable)art)).collect(Collectors.toList());
            if (message.getSoleAttributeAsString((AttributeTypeToken)CoreAttributeTypes.InterfaceMessageType, "Error").equals("Operational")) {
                subMessages.add(0, this.messageHeaders.get(ArtifactId.valueOf((Long)message.getId())));
            }
            for (InterfaceSubMessageToken subMessage : subMessages) {
                LinkedList<InterfaceStructureToken> structures = new LinkedList<InterfaceStructureToken>();
                if (subMessage.getId() == 0L) {
                    structures.add(this.messageHeaderStructures.get(subMessage.getName()));
                } else {
                    structures.addAll(subMessage.getArtifactReadable().getRelated(CoreRelationTypes.InterfaceSubMessageContent_Structure).getList().stream().map(art -> new InterfaceStructureToken((ArtifactReadable)art)).collect(Collectors.toList()));
                }
                for (InterfaceStructureToken struct : structures) {
                    List<InterfaceStructureElementToken> elements;
                    List<ArtifactReadable> elementArts = new LinkedList();
                    if (struct.getId() == 0L) {
                        elements = struct.getElements();
                    } else {
                        elementArts = this.orcsApi.getQueryFactory().fromBranch(branch, view).andRelatedTo(CoreRelationTypes.InterfaceStructureContent_Structure, (ArtifactId)struct.getArtifactReadable()).follow(CoreRelationTypes.InterfaceElementPlatformType_PlatformType).follow(CoreRelationTypes.InterfacePlatformTypeEnumeration_EnumerationSet).follow(CoreRelationTypes.InterfaceEnumeration_EnumerationState).asArtifacts();
                        elements = elementArts.stream().map(art -> new InterfaceStructureElementToken((ArtifactReadable)art)).collect(Collectors.toList());
                    }
                    MimDifferenceItem msgDiffItem = this.diffs.get(ArtifactId.valueOf((Long)message.getId()));
                    MimDifferenceItem diffItem = this.diffs.get(ArtifactId.valueOf((Long)struct.getId()));
                    Integer sizeInBytes = 0;
                    int elementCount = 0;
                    boolean structureSizeChanged = false;
                    boolean structureChanged = false;
                    int byteChangeIndex = elements.size();
                    int i = 0;
                    while (i < elements.size()) {
                        boolean elementAdded;
                        InterfaceStructureElementToken element = elements.get(i);
                        elementCount = struct.isAutogenerated() ? elementCount + 1 : elementCount + element.getArrayLength();
                        sizeInBytes = sizeInBytes + (int)element.getElementSizeInBytes();
                        MimDifferenceItem elementDiffItem = this.diffs.get(ArtifactId.valueOf((Long)element.getId()));
                        MimDifferenceItem pTypeDiffItem = this.diffs.get(ArtifactId.valueOf((Long)element.getPlatformTypeId()));
                        structureSizeChanged = structureSizeChanged || pTypeDiffItem != null && pTypeDiffItem.getDiffs().containsKey(CoreAttributeTypes.InterfacePlatformTypeBitSize.getId()) || elementDiffItem != null && (elementDiffItem.isAdded() || !elementDiffItem.getRelationChanges().isEmpty());
                        boolean bl = elementAdded = diffItem != null && diffItem.getRelationChanges().containsKey(ArtifactId.valueOf((Long)element.getId())) && diffItem.getRelationChanges().get(ArtifactId.valueOf((Long)element.getId())).isAdded();
                        if (structureSizeChanged || elementAdded) {
                            byteChangeIndex = Math.min(i, byteChangeIndex);
                        }
                        structureChanged = structureChanged || elementDiffItem != null || pTypeDiffItem != null;
                        ++i;
                    }
                    String minSim = struct.getInterfaceMinSimultaneity();
                    String maxSim = struct.getInterfaceMaxSimultaneity();
                    String minBps = "Classified";
                    String maxBps = "Classified";
                    if (msgRate > 0) {
                        try {
                            minBps = Integer.toString(Integer.parseInt(minSim) * sizeInBytes * msgRate);
                        }
                        catch (NumberFormatException numberFormatException) {
                            minBps = "Classified";
                        }
                        try {
                            maxBps = Integer.toString(Integer.parseInt(maxSim) * sizeInBytes * msgRate);
                        }
                        catch (NumberFormatException numberFormatException) {
                            maxBps = "Classified";
                        }
                    }
                    String cat = struct.getInterfaceStructureCategory();
                    InterfaceStructureCategoryAttribute.InterfaceStructureCategoryEnum catEnum = CoreAttributeTypes.InterfaceStructureCategory.getEnumValues().stream().filter(e -> cat.equals(e.getName())).findAny().orElse(null);
                    String subMsgNumber = subMessage.getInterfaceSubMessageNumber();
                    String taskFileType = "" + struct.getInterfaceTaskFileType();
                    String desc = struct.getDescription();
                    String categoryFull = catEnum.getId() + " " + catEnum.getName();
                    boolean txRateChanged = msgDiffItem != null && msgDiffItem.getDiffs().containsKey(CoreAttributeTypes.InterfaceMessageRate.getId());
                    boolean msgNumChanged = msgDiffItem != null && msgDiffItem.getDiffs().containsKey(CoreAttributeTypes.InterfaceMessageNumber.getId());
                    boolean numElementsChanged = diffItem != null && !diffItem.getRelationChanges().isEmpty();
                    boolean sizeInBytesChanged = numElementsChanged || structureSizeChanged;
                    structureChanged = structureChanged || diffItem != null || txRateChanged || msgNumChanged;
                    StructureInfo structureInfo = new StructureInfo(struct.getName(), cat, categoryFull, msgRateText, minSim, maxSim, minBps, maxBps, elementCount, sizeInBytes, sendingNode.getName(), msgNumber, subMsgNumber, taskFileType, desc, message, subMessage.getArtifactReadable(), elementArts, structureChanged, txRateChanged, numElementsChanged, sizeInBytesChanged, byteChangeIndex);
                    if (struct.getId() == 0L) {
                        this.headersList.put(struct.getName(), structureInfo);
                        continue;
                    }
                    this.structuresList.put(ArtifactId.valueOf((Long)struct.getId()), structureInfo);
                }
            }
        }
    }

    private void createChangeSummary(ExcelWorkbookWriter writer, BranchId branch) {
        Object[] headers = new String[]{"Team Workflow", "Date", "Change Description"};
        writer.createSheet("Change Summary");
        writer.setColumnWidth(0, 5000);
        writer.setColumnWidth(1, 3000);
        writer.setColumnWidth(2, 10000);
        writer.writeRow(0, headers, new ExcelWorkbookWriter.CELLSTYLE[]{ExcelWorkbookWriter.CELLSTYLE.BOLD});
        int rowIndex = 1;
        for (TransactionReadable tx : ((TransactionQuery)this.orcsApi.getQueryFactory().transactionQuery().andBranch(new BranchId[]{branch})).getResults().getList()) {
            IAtsWorkItem change;
            if (tx.getCommitArt().getId() == -1L || (change = this.atsApi.getQueryService().getWorkItem(tx.getCommitArt().getIdString())) == null || change.getId() == -1L) continue;
            writer.writeCell(++rowIndex, 0, (Object)change.getAtsId());
            writer.writeCell(rowIndex, 1, (Object)tx.getDate());
            writer.writeCell(rowIndex, 2, (Object)change.getName());
        }
    }

    private void createStructureNamesSheet(ExcelWorkbookWriter writer, SortedMap<InterfaceStructureToken, String> structures) {
        writer.createSheet("Structure Names");
        Object[] headers = new String[]{"Structure Name", "Structure Name", "Structure Name"};
        writer.writeRow(0, headers, new ExcelWorkbookWriter.CELLSTYLE[]{ExcelWorkbookWriter.CELLSTYLE.BOLD});
        Iterator<InterfaceStructureToken> iterator = structures.keySet().iterator();
        int size = structures.size();
        int firstCol = (int)Math.ceil((double)size / 3.0);
        int secCol = firstCol * 2;
        int count = 0;
        int rowNum = 1;
        TreeMap<InterfaceStructureToken, String> col1 = new TreeMap<InterfaceStructureToken, String>();
        TreeMap<InterfaceStructureToken, String> col2 = new TreeMap<InterfaceStructureToken, String>();
        TreeMap<InterfaceStructureToken, String> col3 = new TreeMap<InterfaceStructureToken, String>();
        while (iterator.hasNext()) {
            InterfaceStructureToken structure = iterator.next();
            String sLink = (String)structures.get((Object)structure);
            if (count < firstCol) {
                col1.put(structure, sLink);
            } else if (count < secCol) {
                col2.put(structure, sLink);
            } else {
                col3.put(structure, sLink);
            }
            ++count;
        }
        Iterator col1Iterator = col1.keySet().iterator();
        Iterator col2Iterator = col2.keySet().iterator();
        Iterator col3Iterator = col3.keySet().iterator();
        while (col1Iterator.hasNext()) {
            InterfaceStructureToken structure = (InterfaceStructureToken)((Object)col1Iterator.next());
            writer.writeCell(rowNum, 0, (Object)structure.getName(), "'" + (String)col1.get((Object)structure) + "'!A1", ExcelWorkbookWriter.HyperLinkType.SHEET, new ExcelWorkbookWriter.CELLSTYLE[]{ExcelWorkbookWriter.CELLSTYLE.HYPERLINK, this.getStructureNameColor(structure)});
            if (col2Iterator.hasNext()) {
                structure = (InterfaceStructureToken)((Object)col2Iterator.next());
                writer.writeCell(rowNum, 1, (Object)structure.getName(), "'" + (String)col2.get((Object)structure) + "'!A1", ExcelWorkbookWriter.HyperLinkType.SHEET, new ExcelWorkbookWriter.CELLSTYLE[]{ExcelWorkbookWriter.CELLSTYLE.HYPERLINK, this.getStructureNameColor(structure)});
            }
            if (col3Iterator.hasNext()) {
                structure = (InterfaceStructureToken)((Object)col3Iterator.next());
                writer.writeCell(rowNum, 2, (Object)structure.getName(), "'" + (String)col3.get((Object)structure) + "'!A1", ExcelWorkbookWriter.HyperLinkType.SHEET, new ExcelWorkbookWriter.CELLSTYLE[]{ExcelWorkbookWriter.CELLSTYLE.HYPERLINK, this.getStructureNameColor(structure)});
            }
            ++rowNum;
        }
        writer.autoSizeAllColumns(headers.length);
    }

    private ExcelWorkbookWriter.CELLSTYLE getStructureNameColor(InterfaceStructureToken struct) {
        StructureInfo info = this.getStructureInfo(struct);
        MimDifferenceItem diffItem = this.diffs.get(ArtifactId.valueOf((Long)struct.getId()));
        if (diffItem != null && diffItem.isAdded()) {
            return ExcelWorkbookWriter.CELLSTYLE.GREEN;
        }
        if (info.structureChanged) {
            return ExcelWorkbookWriter.CELLSTYLE.YELLOW;
        }
        return ExcelWorkbookWriter.CELLSTYLE.NONE;
    }

    private void createStructureSummarySheet(ExcelWorkbookWriter writer, BranchId branch, ArtifactId view, ArtifactReadable primaryNode, ArtifactReadable secondaryNode, List<ArtifactReadable> messages, SortedMap<InterfaceStructureToken, String> structureLinks) {
        int totalMinSim = 0;
        int totalMaxSim = 0;
        int totalNumAttrs = 0;
        int totalMinBps = 0;
        int totalMaxBps = 0;
        int maxAttrs = 0;
        int totalStructs = 0;
        int rowIndex = 1;
        Object[] headers = new String[]{"Category", "Structure Name", "Tx Rate", "Sim Min", "Sim Max", "# of Attributes", "Size in Bytes", "BPS Min", "BPS Max", "Initiator", "Msg #", "SubMsg #", "Taskfile Type", "Description"};
        writer.createSheet("Structure Summary");
        writer.writeRow(0, headers, new ExcelWorkbookWriter.CELLSTYLE[]{ExcelWorkbookWriter.CELLSTYLE.BOLD});
        for (ArtifactReadable message : messages) {
            List subMessages = message.getRelated(CoreRelationTypes.InterfaceMessageSubMessageContent_SubMessage).getList().stream().map(art -> new InterfaceSubMessageToken((ArtifactReadable)art)).collect(Collectors.toList());
            if (message.getSoleAttributeAsString((AttributeTypeToken)CoreAttributeTypes.InterfaceMessageType, "Error").equals("Operational")) {
                subMessages.add(0, this.messageHeaders.get(ArtifactId.valueOf((Long)message.getId())));
            }
            for (InterfaceSubMessageToken subMessage : subMessages) {
                LinkedList<InterfaceStructureToken> structures = new LinkedList<InterfaceStructureToken>();
                if (subMessage.getId() == 0L) {
                    structures.add(this.messageHeaderStructures.get(subMessage.getName()));
                } else {
                    structures.addAll(subMessage.getArtifactReadable().getRelated(CoreRelationTypes.InterfaceSubMessageContent_Structure).getList().stream().map(art -> new InterfaceStructureToken((ArtifactReadable)art)).collect(Collectors.toList()));
                }
                for (InterfaceStructureToken struct : structures) {
                    String sheetName = (String)structureLinks.get((Object)struct);
                    StructureInfo structureInfo = this.getStructureInfo(struct);
                    ArtifactReadable structReadable = struct.getArtifactReadable();
                    totalMinSim += this.stringToInt(structureInfo.minSim);
                    totalMaxSim += this.stringToInt(structureInfo.maxSim);
                    totalNumAttrs += structureInfo.numAttributes.intValue();
                    totalMinBps += this.stringToInt(structureInfo.minBps);
                    totalMaxBps += this.stringToInt(structureInfo.maxBps);
                    maxAttrs = Math.max(maxAttrs, structureInfo.numAttributes);
                    ++totalStructs;
                    writer.writeCell(rowIndex, 0, (Object)structureInfo.categoryFull, new ExcelWorkbookWriter.CELLSTYLE[]{this.getCellColor(structReadable, CoreAttributeTypes.InterfaceStructureCategory.getId())});
                    writer.writeCell(rowIndex, 1, (Object)struct.getName(), "'" + sheetName + "'!A1", ExcelWorkbookWriter.HyperLinkType.SHEET, new ExcelWorkbookWriter.CELLSTYLE[]{this.getCellColor(structReadable, CoreAttributeTypes.Name.getId()), ExcelWorkbookWriter.CELLSTYLE.HYPERLINK});
                    writer.writeCell(rowIndex, 2, (Object)structureInfo.txRate, new ExcelWorkbookWriter.CELLSTYLE[]{this.getCellColor(structReadable, message, CoreAttributeTypes.InterfaceMessageRate.getId())});
                    writer.writeCell(rowIndex, 3, (Object)structureInfo.minSim, new ExcelWorkbookWriter.CELLSTYLE[]{this.getCellColor(structReadable, CoreAttributeTypes.InterfaceMinSimultaneity.getId())});
                    writer.writeCell(rowIndex, 4, (Object)structureInfo.maxSim, new ExcelWorkbookWriter.CELLSTYLE[]{this.getCellColor(structReadable, CoreAttributeTypes.InterfaceMaxSimultaneity.getId())});
                    writer.writeCell(rowIndex, 5, (Object)structureInfo.numAttributes, new ExcelWorkbookWriter.CELLSTYLE[]{this.getCellColor(structReadable, structureInfo.numElementsChanged)});
                    writer.writeCell(rowIndex, 6, (Object)structureInfo.sizeInBytes, new ExcelWorkbookWriter.CELLSTYLE[]{this.getCellColor(structReadable, structureInfo.structureSizeChanged)});
                    writer.writeCell(rowIndex, 7, (Object)structureInfo.minBps, new ExcelWorkbookWriter.CELLSTYLE[]{this.getCellColor(structReadable, structureInfo.txRateChanged || structureInfo.structureSizeChanged)});
                    writer.writeCell(rowIndex, 8, (Object)structureInfo.maxBps, new ExcelWorkbookWriter.CELLSTYLE[]{this.getCellColor(structReadable, structureInfo.txRateChanged || structureInfo.structureSizeChanged)});
                    writer.writeCell(rowIndex, 9, (Object)structureInfo.initiator, new ExcelWorkbookWriter.CELLSTYLE[]{this.getCellColor(structReadable, false)});
                    writer.writeCell(rowIndex, 10, (Object)structureInfo.msgNum, new ExcelWorkbookWriter.CELLSTYLE[]{this.getCellColor(structReadable, message, CoreAttributeTypes.InterfaceMessageNumber.getId())});
                    writer.writeCell(rowIndex, 11, (Object)structureInfo.subMsgNum, new ExcelWorkbookWriter.CELLSTYLE[]{this.getCellColor(structReadable, subMessage.getArtifactReadable(), CoreAttributeTypes.InterfaceSubMessageNumber.getId())});
                    writer.writeCell(rowIndex, 12, (Object)structureInfo.taskfile, new ExcelWorkbookWriter.CELLSTYLE[]{this.getCellColor(structReadable, CoreAttributeTypes.InterfaceTaskFileType.getId())});
                    writer.writeCell(rowIndex, 13, (Object)structureInfo.description, new ExcelWorkbookWriter.CELLSTYLE[]{this.getCellColor(structReadable, CoreAttributeTypes.Description.getId()), ExcelWorkbookWriter.CELLSTYLE.WRAP});
                    ++rowIndex;
                }
            }
        }
        Object[] totalsHeaders = new String[]{" ", " ", " ", "Sim Min", "Sim Max", "# of Attributes", " ", "Min", "Max"};
        writer.writeRow(++rowIndex, totalsHeaders, new ExcelWorkbookWriter.CELLSTYLE[]{ExcelWorkbookWriter.CELLSTYLE.BOLD});
        writer.writeCell(++rowIndex, 2, (Object)"Totals:", new ExcelWorkbookWriter.CELLSTYLE[]{ExcelWorkbookWriter.CELLSTYLE.BOLD});
        writer.writeCell(rowIndex, 3, (Object)totalMinSim);
        writer.writeCell(rowIndex, 4, (Object)totalMaxSim);
        writer.writeCell(rowIndex, 5, (Object)totalNumAttrs);
        writer.writeCell(rowIndex, 6, (Object)"B/s:", new ExcelWorkbookWriter.CELLSTYLE[]{ExcelWorkbookWriter.CELLSTYLE.BOLD});
        writer.writeCell(rowIndex, 7, (Object)totalMinBps);
        writer.writeCell(rowIndex, 8, (Object)totalMaxBps);
        writer.writeCell(++rowIndex, 3, (Object)"Unique Structures:", new ExcelWorkbookWriter.CELLSTYLE[]{ExcelWorkbookWriter.CELLSTYLE.BOLD});
        writer.writeCell(rowIndex, 4, (Object)maxAttrs);
        writer.writeCell(rowIndex, 6, (Object)"MB/s:", new ExcelWorkbookWriter.CELLSTYLE[]{ExcelWorkbookWriter.CELLSTYLE.BOLD});
        writer.writeCell(rowIndex, 7, (Object)((double)totalMinBps / 1048576.0));
        writer.writeCell(rowIndex, 8, (Object)((double)totalMaxBps / 1048576.0));
        writer.writeCell(++rowIndex, 3, (Object)"Max # Attributes:", new ExcelWorkbookWriter.CELLSTYLE[]{ExcelWorkbookWriter.CELLSTYLE.BOLD});
        writer.writeCell(rowIndex, 4, (Object)totalStructs);
        writer.writeCell(rowIndex, 6, (Object)"Mb/s:", new ExcelWorkbookWriter.CELLSTYLE[]{ExcelWorkbookWriter.CELLSTYLE.BOLD});
        writer.writeCell(rowIndex, 7, (Object)((double)totalMinBps * 8.0 / 1048576.0));
        writer.writeCell(rowIndex, 8, (Object)((double)totalMaxBps * 8.0 / 1048576.0));
        writer.autoSizeAllColumns(headers.length);
        writer.setColumnWidth(13, 15000);
    }

    private StructureInfo getStructureInfo(InterfaceStructureToken struct) {
        return struct.getId() == 0L ? this.headersList.get(struct.getName()) : this.structuresList.get(ArtifactId.valueOf((Long)struct.getId()));
    }

    private int stringToInt(String str) {
        try {
            return Integer.parseInt(str);
        }
        catch (NumberFormatException numberFormatException) {
            return 0;
        }
    }

    private void printFirstRowInStructureSheet(ExcelWorkbookWriter writer, InterfaceStructureToken structure, StructureInfo info) {
        ArtifactReadable structReadable = structure.getArtifactReadable();
        Object[] headers = new String[]{"Sheet Type", "Full Sheet Name", "Abbrev. Sheet Name", "Most Recent Update", "Category", "Transmission Rate", "Min Simultaneity", "Max Simultaneity", "# of attributes", "Size in Bytes", "Initiator", "Msg #", "SubMsg #", "Taskfile", "Description"};
        writer.writeRow(0, headers, new ExcelWorkbookWriter.CELLSTYLE[]{ExcelWorkbookWriter.CELLSTYLE.BOLD});
        String date = structure.getId() == 0L ? "" : ((TransactionReadable)((TransactionQuery)this.orcsApi.getQueryFactory().transactionQuery().andTxId(structure.getArtifactReadable().getTransaction())).getResults().getAtMostOneOrDefault((Object)TransactionReadable.SENTINEL)).getDate();
        writer.writeCell(1, 0, (Object)"Functional", new ExcelWorkbookWriter.CELLSTYLE[]{this.getCellColor(structReadable, false)});
        writer.writeCell(1, 1, (Object)info.name, new ExcelWorkbookWriter.CELLSTYLE[]{this.getCellColor(structReadable, CoreAttributeTypes.Name.getId())});
        writer.writeCell(1, 2, (Object)(structure.getId() == 0L ? info.name : structReadable.getSoleAttributeAsString((AttributeTypeToken)CoreAttributeTypes.GeneralStringData, "")), new ExcelWorkbookWriter.CELLSTYLE[]{this.getCellColor(structReadable, false)});
        writer.writeCell(1, 3, (Object)date, new ExcelWorkbookWriter.CELLSTYLE[]{this.getCellColor(structReadable, false)});
        writer.writeCell(1, 4, (Object)info.category, new ExcelWorkbookWriter.CELLSTYLE[]{this.getCellColor(structReadable, CoreAttributeTypes.Name.getId())});
        writer.writeCell(1, 5, (Object)info.txRate, new ExcelWorkbookWriter.CELLSTYLE[]{this.getCellColor(structReadable, info.message, CoreAttributeTypes.InterfaceMessageRate.getId())});
        writer.writeCell(1, 6, (Object)info.minSim, new ExcelWorkbookWriter.CELLSTYLE[]{this.getCellColor(structReadable, CoreAttributeTypes.InterfaceMinSimultaneity.getId())});
        writer.writeCell(1, 7, (Object)info.maxSim, new ExcelWorkbookWriter.CELLSTYLE[]{this.getCellColor(structReadable, CoreAttributeTypes.InterfaceMaxSimultaneity.getId())});
        writer.writeCell(1, 8, (Object)info.numAttributes, new ExcelWorkbookWriter.CELLSTYLE[]{this.getCellColor(structReadable, info.numElementsChanged)});
        writer.writeCell(1, 9, (Object)info.sizeInBytes, new ExcelWorkbookWriter.CELLSTYLE[]{this.getCellColor(structReadable, info.structureSizeChanged)});
        writer.writeCell(1, 10, (Object)info.initiator, new ExcelWorkbookWriter.CELLSTYLE[]{this.getCellColor(structReadable, false)});
        writer.writeCell(1, 11, (Object)info.msgNum, new ExcelWorkbookWriter.CELLSTYLE[]{this.getCellColor(structReadable, info.message, CoreAttributeTypes.InterfaceMessageNumber.getId())});
        writer.writeCell(1, 12, (Object)info.subMsgNum, new ExcelWorkbookWriter.CELLSTYLE[]{this.getCellColor(structReadable, info.submessage, CoreAttributeTypes.InterfaceSubMessageNumber.getId())});
        writer.writeCell(1, 13, (Object)info.taskfile, new ExcelWorkbookWriter.CELLSTYLE[]{this.getCellColor(structReadable, CoreAttributeTypes.InterfaceTaskFileType.getId())});
        writer.writeCell(1, 14, (Object)info.description, new ExcelWorkbookWriter.CELLSTYLE[]{this.getCellColor(structReadable, CoreAttributeTypes.Description.getId()), ExcelWorkbookWriter.CELLSTYLE.WRAP});
    }

    private void createStructureSheets(ExcelWorkbookWriter writer, ArtifactId view, List<InterfaceSubMessageToken> subMessages, List<InterfaceStructureToken> structures, SortedMap<InterfaceStructureToken, String> structureLinks) {
        Object[] elementHeaders = new String[]{"Begin Word", "Begin Byte", "Number of Bytes", "Ending Word", "Ending Byte", "Type", "Element Name", "Units", "Valid Range", "Alterable After Creation", "Description", "Enumerated Literals", "Notes"};
        for (InterfaceSubMessageToken subMessage : subMessages) {
            LinkedList<InterfaceStructureToken> structs = new LinkedList<InterfaceStructureToken>();
            if (subMessage.getId() == 0L) {
                structs.add(this.messageHeaderStructures.get(subMessage.getName()));
            } else {
                structs.addAll(structures.stream().filter(a -> a.getArtifactReadable() != null && a.getArtifactReadable().areRelated(CoreRelationTypes.InterfaceSubMessageContent_SubMessage, subMessage.getArtifactReadable())).collect(Collectors.toList()));
            }
            for (InterfaceStructureToken struct : structs) {
                Integer byteSize;
                PlatformTypeToken platformType;
                int rowIndex = 4;
                int byteLocation = 0;
                writer.createSheet((String)structureLinks.get((Object)struct));
                StructureInfo info = struct.getId() == 0L ? this.headersList.get(struct.getName()) : this.structuresList.get(ArtifactId.valueOf((Long)struct.getId()));
                this.printFirstRowInStructureSheet(writer, struct, info);
                writer.writeRow(3, elementHeaders, new ExcelWorkbookWriter.CELLSTYLE[]{ExcelWorkbookWriter.CELLSTYLE.BOLD});
                if (struct.getId() == 0L) {
                    for (InterfaceStructureElementToken element : struct.getElements()) {
                        platformType = element.getPlatformType();
                        byteSize = (int)element.getElementSizeInBytes();
                        this.printHeaderStructureRow(writer, rowIndex, view, element, byteLocation, byteSize, platformType);
                        byteLocation += byteSize.intValue();
                        ++rowIndex;
                    }
                } else {
                    int i = 0;
                    while (i < info.elements.size()) {
                        ArtifactReadable element = info.elements.get(i);
                        platformType = (ArtifactReadable)element.getRelated(CoreRelationTypes.InterfaceElementPlatformType_PlatformType).getAtMostOneOrDefault((Object)ArtifactReadable.SENTINEL);
                        byteSize = Integer.valueOf(platformType.getSoleAttributeAsString((AttributeTypeToken)CoreAttributeTypes.InterfacePlatformTypeBitSize, "0")) / 8;
                        this.printDataElementRow(writer, rowIndex, view, struct.getArtifactReadable(), element, byteLocation, byteSize, (ArtifactReadable)platformType, i >= info.byteChangeIndex);
                        if (element.isOfType(new ArtifactTypeId[]{CoreArtifactTypes.InterfaceDataElementArray})) {
                            int startIndex = (Integer)element.getSoleAttributeValue((AttributeTypeToken)CoreAttributeTypes.InterfaceElementIndexStart, (Object)0);
                            int endIndex = (Integer)element.getSoleAttributeValue((AttributeTypeToken)CoreAttributeTypes.InterfaceElementIndexEnd, (Object)0);
                            byteSize = byteSize * (endIndex - startIndex + 1);
                        }
                        byteLocation += byteSize.intValue();
                        ++rowIndex;
                        ++i;
                    }
                }
                writer.autoSizeAllColumns(15);
                writer.setColumnWidth(10, Math.min(writer.getColumnWidth(10), 15000));
                writer.setColumnWidth(12, Math.min(writer.getColumnWidth(12), 10000));
                writer.setColumnWidth(14, Math.min(writer.getColumnWidth(14), 15000));
            }
        }
    }

    private void printHeaderStructureRow(ExcelWorkbookWriter writer, int rowIndex, ArtifactId view, InterfaceStructureElementToken element, Integer byteLocation, Integer byteSize, PlatformTypeToken platformType) {
        Integer beginWord = Math.floorDiv(byteLocation, 4);
        Integer beginByte = Math.floorMod(byteLocation, 4);
        Integer endWord = Math.floorDiv(byteLocation + byteSize - 1, 4);
        Integer endByte = Math.floorMod(byteLocation + byteSize - 1, 4);
        String elementName = element.getName();
        String dataType = element.getLogicalType();
        dataType = dataType.replace("unsigned long", "uLong").replace("unsigned short", "uShort").replace("short", "sShort").replace("unsigned integer", "uInteger").replace("integer", "sInteger");
        String units = platformType == null || platformType.getInterfacePlatformTypeUnits() == "" ? "n/a" : platformType.getInterfacePlatformTypeUnits();
        String validRange = platformType == null || platformType.getInterfacePlatformTypeValidRangeDescription() == "" ? "n/a" : platformType.getInterfacePlatformTypeValidRangeDescription();
        String alterable = element.getInterfaceElementAlterable() != false ? "Yes" : "No";
        String description = element.getDescription() == "" ? "n/a" : element.getDescription();
        String notes = element.getNotes();
        writer.writeCell(rowIndex, 0, (Object)beginWord);
        writer.writeCell(rowIndex, 1, (Object)beginByte);
        writer.writeCell(rowIndex, 2, (Object)byteSize);
        writer.writeCell(rowIndex, 3, (Object)endWord);
        writer.writeCell(rowIndex, 4, (Object)endByte);
        writer.writeCell(rowIndex, 5, (Object)dataType);
        writer.writeCell(rowIndex, 6, (Object)elementName);
        writer.writeCell(rowIndex, 7, (Object)units);
        writer.writeCell(rowIndex, 8, (Object)validRange);
        writer.writeCell(rowIndex, 9, (Object)alterable);
        writer.writeCell(rowIndex, 10, (Object)description, new ExcelWorkbookWriter.CELLSTYLE[]{ExcelWorkbookWriter.CELLSTYLE.WRAP});
        writer.writeCell(rowIndex, 11, (Object)"n/a");
        writer.writeCell(rowIndex, 12, (Object)notes);
    }

    private void printDataElementRow(ExcelWorkbookWriter writer, int rowIndex, ArtifactId view, ArtifactReadable structure, ArtifactReadable element, Integer byteLocation, Integer byteSize, ArtifactReadable platformType, boolean bytesChanged) {
        ExcelWorkbookWriter.CELLSTYLE byteStyle;
        ExcelWorkbookWriter.CELLSTYLE enumStyle;
        ExcelWorkbookWriter.CELLSTYLE pTypeStyle;
        boolean platformTypeChanged;
        Integer beginWord = Math.floorDiv(byteLocation, 4);
        Integer beginByte = Math.floorMod(byteLocation, 4);
        Integer endWord = Math.floorDiv(byteLocation + byteSize - 1, 4);
        Integer endByte = Math.floorMod(byteLocation + byteSize - 1, 4);
        String enumLiterals = element.getSoleAttributeAsString((AttributeTypeToken)CoreAttributeTypes.InterfacePlatformTypeEnumLiteral, "");
        String elementName = (String)element.getSoleAttributeValue((AttributeTypeToken)CoreAttributeTypes.Name);
        String dataType = platformType.getSoleAttributeAsString((AttributeTypeToken)CoreAttributeTypes.InterfaceLogicalType, "n/a");
        dataType = dataType.replace("unsigned long", "uLong").replace("unsigned short", "uShort").replace("short", "sShort").replace("unsigned integer", "uInteger").replace("integer", "sInteger");
        String units = platformType.getSoleAttributeAsString((AttributeTypeToken)CoreAttributeTypes.InterfacePlatformTypeUnits, "n/a");
        String validRange = platformType.getExistingAttributeTypes().contains(CoreAttributeTypes.InterfacePlatformTypeMinval) ? String.valueOf(platformType.getSoleAttributeAsString((AttributeTypeToken)CoreAttributeTypes.InterfacePlatformTypeMinval, "n/a")) + "-" + platformType.getSoleAttributeAsString((AttributeTypeToken)CoreAttributeTypes.InterfacePlatformTypeMaxval, "n/a") : (dataType.equals("enumeration") ? "see enumerated literals" : (dataType.equals("boolean") ? "0 to 1" : platformType.getSoleAttributeAsString((AttributeTypeToken)CoreAttributeTypes.InterfacePlatformTypeValidRangeDescription, " ")));
        String alterable = element.getSoleAttributeAsString((AttributeTypeToken)CoreAttributeTypes.InterfaceElementAlterable, "No");
        alterable = alterable.equalsIgnoreCase("true") ? "Yes" : "No";
        String description = element.getSoleAttributeAsString((AttributeTypeToken)CoreAttributeTypes.Description, "n/a");
        String notes = element.getSoleAttributeAsString((AttributeTypeToken)CoreAttributeTypes.Notes, " ");
        boolean enumChanged = false;
        if (platformType.getExistingRelationTypes().contains(CoreRelationTypes.InterfacePlatformTypeEnumeration)) {
            enumLiterals = "";
            ArtifactReadable enumDef = (ArtifactReadable)platformType.getRelated(CoreRelationTypes.InterfacePlatformTypeEnumeration_EnumerationSet).getAtMostOneOrDefault((Object)ArtifactReadable.SENTINEL);
            enumChanged = enumChanged || this.diffs.containsKey(ArtifactId.valueOf((Long)enumDef.getId()));
            for (ArtifactReadable enumState : enumDef.getRelated(CoreRelationTypes.InterfaceEnumeration_EnumerationState).getList()) {
                enumLiterals = String.valueOf(enumLiterals) + enumState.getSoleAttributeAsString((AttributeTypeToken)CoreAttributeTypes.InterfaceEnumOrdinal, "0") + " = " + enumState.getSoleAttributeAsString((AttributeTypeToken)CoreAttributeTypes.Name, "") + "\n";
                boolean bl = enumChanged = enumChanged || this.diffs.containsKey(ArtifactId.valueOf((Long)enumState.getId()));
            }
        } else {
            enumLiterals = platformType.getSoleAttributeAsString((AttributeTypeToken)CoreAttributeTypes.InterfacePlatformTypeEnumLiteral, " ");
            if (enumLiterals.equals(" ")) {
                enumLiterals = platformType.getSoleAttributeAsString((AttributeTypeToken)CoreAttributeTypes.Description, " ");
            }
        }
        MimDifferenceItem structDiff = this.diffs.get(ArtifactId.valueOf((Long)structure.getId()));
        MimDifferenceItem elementDiff = this.diffs.get(ArtifactId.valueOf((Long)element.getId()));
        boolean elementAdded = structDiff != null && structDiff.getRelationChanges().containsKey(ArtifactId.valueOf((Long)element.getId())) && structDiff.getRelationChanges().get(ArtifactId.valueOf((Long)element.getId())).isAdded();
        boolean bl = platformTypeChanged = elementDiff != null && !elementDiff.getRelationChanges().isEmpty();
        ExcelWorkbookWriter.CELLSTYLE cELLSTYLE = elementAdded || this.getCellColor(element, false).equals((Object)ExcelWorkbookWriter.CELLSTYLE.GREEN) ? ExcelWorkbookWriter.CELLSTYLE.GREEN : (pTypeStyle = platformTypeChanged ? ExcelWorkbookWriter.CELLSTYLE.YELLOW : ExcelWorkbookWriter.CELLSTYLE.NONE);
        ExcelWorkbookWriter.CELLSTYLE cELLSTYLE2 = elementAdded || this.getCellColor(element, false).equals((Object)ExcelWorkbookWriter.CELLSTYLE.GREEN) ? ExcelWorkbookWriter.CELLSTYLE.GREEN : (enumStyle = enumChanged || platformTypeChanged ? ExcelWorkbookWriter.CELLSTYLE.YELLOW : ExcelWorkbookWriter.CELLSTYLE.NONE);
        ExcelWorkbookWriter.CELLSTYLE cELLSTYLE3 = elementAdded || this.getCellColor(element, false).equals((Object)ExcelWorkbookWriter.CELLSTYLE.GREEN) ? ExcelWorkbookWriter.CELLSTYLE.GREEN : (byteStyle = bytesChanged ? ExcelWorkbookWriter.CELLSTYLE.YELLOW : ExcelWorkbookWriter.CELLSTYLE.NONE);
        if (element.isOfType(new ArtifactTypeId[]{CoreArtifactTypes.InterfaceDataElementArray})) {
            int startIndex = (Integer)element.getSoleAttributeValue((AttributeTypeToken)CoreAttributeTypes.InterfaceElementIndexStart, (Object)0);
            int endIndex = (Integer)element.getSoleAttributeValue((AttributeTypeToken)CoreAttributeTypes.InterfaceElementIndexEnd, (Object)0);
            int i = startIndex;
            while (i < endIndex + 1) {
                writer.writeCell(rowIndex, 0, (Object)beginWord, new ExcelWorkbookWriter.CELLSTYLE[]{byteStyle});
                writer.writeCell(rowIndex, 1, (Object)beginByte, new ExcelWorkbookWriter.CELLSTYLE[]{byteStyle});
                writer.writeCell(rowIndex, 2, (Object)byteSize, new ExcelWorkbookWriter.CELLSTYLE[]{byteStyle});
                writer.writeCell(rowIndex, 3, (Object)endWord, new ExcelWorkbookWriter.CELLSTYLE[]{byteStyle});
                writer.writeCell(rowIndex, 4, (Object)endByte, new ExcelWorkbookWriter.CELLSTYLE[]{byteStyle});
                writer.writeCell(rowIndex, 5, (Object)dataType, new ExcelWorkbookWriter.CELLSTYLE[]{pTypeStyle});
                writer.writeCell(rowIndex, 6, (Object)(String.valueOf(elementName) + " " + Integer.toString(i)), new ExcelWorkbookWriter.CELLSTYLE[]{this.getCellColor(element, CoreAttributeTypes.Name.getId())});
                writer.writeCell(rowIndex, 7, (Object)units, new ExcelWorkbookWriter.CELLSTYLE[]{pTypeStyle});
                writer.writeCell(rowIndex, 8, (Object)validRange, new ExcelWorkbookWriter.CELLSTYLE[]{pTypeStyle});
                writer.writeCell(rowIndex, 9, (Object)alterable, new ExcelWorkbookWriter.CELLSTYLE[]{this.getCellColor(element, CoreAttributeTypes.InterfaceElementAlterable.getId())});
                writer.writeCell(rowIndex, 10, (Object)description, new ExcelWorkbookWriter.CELLSTYLE[]{this.getCellColor(element, CoreAttributeTypes.Description.getId()), ExcelWorkbookWriter.CELLSTYLE.WRAP});
                writer.writeCell(rowIndex, 11, (Object)enumLiterals.trim(), new ExcelWorkbookWriter.CELLSTYLE[]{enumStyle, ExcelWorkbookWriter.CELLSTYLE.WRAP});
                writer.writeCell(rowIndex, 12, (Object)notes, new ExcelWorkbookWriter.CELLSTYLE[]{this.getCellColor(element, CoreAttributeTypes.Notes.getId()), ExcelWorkbookWriter.CELLSTYLE.WRAP});
                byteLocation = byteLocation + byteSize;
                beginWord = Math.floorDiv(byteLocation, 4);
                beginByte = Math.floorMod(byteLocation, 4);
                endWord = Math.floorDiv(byteLocation + byteSize - 1, 4);
                endByte = Math.floorMod(byteLocation + byteSize - 1, 4);
                ++i;
            }
        } else {
            writer.writeCell(rowIndex, 0, (Object)beginWord, new ExcelWorkbookWriter.CELLSTYLE[]{byteStyle});
            writer.writeCell(rowIndex, 1, (Object)beginByte, new ExcelWorkbookWriter.CELLSTYLE[]{byteStyle});
            writer.writeCell(rowIndex, 2, (Object)byteSize, new ExcelWorkbookWriter.CELLSTYLE[]{byteStyle});
            writer.writeCell(rowIndex, 3, (Object)endWord, new ExcelWorkbookWriter.CELLSTYLE[]{byteStyle});
            writer.writeCell(rowIndex, 4, (Object)endByte, new ExcelWorkbookWriter.CELLSTYLE[]{byteStyle});
            writer.writeCell(rowIndex, 5, (Object)dataType, new ExcelWorkbookWriter.CELLSTYLE[]{pTypeStyle});
            writer.writeCell(rowIndex, 6, (Object)elementName, new ExcelWorkbookWriter.CELLSTYLE[]{this.getCellColor(element, CoreAttributeTypes.Name.getId())});
            writer.writeCell(rowIndex, 7, (Object)units, new ExcelWorkbookWriter.CELLSTYLE[]{pTypeStyle});
            writer.writeCell(rowIndex, 8, (Object)validRange, new ExcelWorkbookWriter.CELLSTYLE[]{pTypeStyle});
            writer.writeCell(rowIndex, 9, (Object)alterable, new ExcelWorkbookWriter.CELLSTYLE[]{this.getCellColor(element, CoreAttributeTypes.InterfaceElementAlterable.getId())});
            writer.writeCell(rowIndex, 10, (Object)description, new ExcelWorkbookWriter.CELLSTYLE[]{this.getCellColor(element, CoreAttributeTypes.Description.getId()), ExcelWorkbookWriter.CELLSTYLE.WRAP});
            writer.writeCell(rowIndex, 11, (Object)enumLiterals.trim(), new ExcelWorkbookWriter.CELLSTYLE[]{enumStyle, ExcelWorkbookWriter.CELLSTYLE.WRAP});
            writer.writeCell(rowIndex, 12, (Object)notes, new ExcelWorkbookWriter.CELLSTYLE[]{this.getCellColor(element, CoreAttributeTypes.Notes.getId()), ExcelWorkbookWriter.CELLSTYLE.WRAP});
        }
    }

    private void createMessageSubMessageSummary(ExcelWorkbookWriter writer, ArtifactReadable connection, ArtifactReadable primaryNode, ArtifactReadable secondaryNode, List<ArtifactReadable> messages, List<ArtifactReadable> subMessages) {
        List connectionMessages = messages.stream().filter(e -> e.getSoleAttributeAsString((AttributeTypeToken)CoreAttributeTypes.InterfaceMessageType).equals("Operational")).collect(Collectors.toList());
        List primaryList = connectionMessages.stream().filter(e -> primaryNode.equals(e.getRelated(CoreRelationTypes.InterfaceMessageSendingNode_Node).getAtMostOneOrDefault((Object)ArtifactReadable.SENTINEL))).collect(Collectors.toList());
        List secondaryList = connectionMessages.stream().filter(e -> secondaryNode.equals(e.getRelated(CoreRelationTypes.InterfaceMessageSendingNode_Node).getAtMostOneOrDefault((Object)ArtifactReadable.SENTINEL))).collect(Collectors.toList());
        writer.createSheet("Message and SubMessage Summary");
        writer.addMergedRegion("A1:E1");
        writer.addMergedRegion("F1:J1");
        writer.addMergedRegion("D2:E2");
        writer.addMergedRegion("I2:J2");
        writer.setRowHeight(0, 300);
        writer.writeCell(0, 0, (Object)(String.valueOf(primaryNode.getName()) + " Initiated Message"), new ExcelWorkbookWriter.CELLSTYLE[]{ExcelWorkbookWriter.CELLSTYLE.BOLD, ExcelWorkbookWriter.CELLSTYLE.CENTERH, ExcelWorkbookWriter.CELLSTYLE.CENTERV});
        writer.writeCell(0, 5, (Object)(String.valueOf(secondaryNode.getName()) + " Initiated Message"), new ExcelWorkbookWriter.CELLSTYLE[]{ExcelWorkbookWriter.CELLSTYLE.BOLD, ExcelWorkbookWriter.CELLSTYLE.CENTERH, ExcelWorkbookWriter.CELLSTYLE.CENTERV});
        Object[] rowValues = new String[]{"No.", "Rate", "Read/Write", "Content", "", "No.", "Rate", "Read/Write", "Content"};
        writer.writeRow(1, rowValues, new ExcelWorkbookWriter.CELLSTYLE[]{ExcelWorkbookWriter.CELLSTYLE.BOLD, ExcelWorkbookWriter.CELLSTYLE.CENTERH, ExcelWorkbookWriter.CELLSTYLE.CENTERV});
        int rowIndex = 2;
        int i = 0;
        while (i < Math.max(primaryList.size(), secondaryList.size())) {
            ArtifactReadable primaryMessage = ArtifactReadable.SENTINEL;
            ArtifactReadable secondaryMessage = ArtifactReadable.SENTINEL;
            List<Object> primarySubMessages = new ArrayList();
            List<Object> secondarySubMessages = new ArrayList();
            if (i < primaryList.size()) {
                ArtifactReadable pm = primaryMessage = (ArtifactReadable)primaryList.get(i);
                primarySubMessages = subMessages.stream().filter(a -> a.areRelated(CoreRelationTypes.InterfaceMessageSubMessageContent_Message, pm)).collect(Collectors.toList());
            }
            if (i < secondaryList.size()) {
                ArtifactReadable sm = secondaryMessage = (ArtifactReadable)secondaryList.get(i);
                secondarySubMessages = subMessages.stream().filter(a -> a.areRelated(CoreRelationTypes.InterfaceMessageSubMessageContent_Message, sm)).collect(Collectors.toList());
            }
            if (primaryMessage.isValid()) {
                writer.writeCell(rowIndex, 0, (Object)primaryMessage.getSoleAttributeAsString((AttributeTypeToken)CoreAttributeTypes.InterfaceMessageNumber), new ExcelWorkbookWriter.CELLSTYLE[]{this.getCellColor(primaryMessage, CoreAttributeTypes.InterfaceMessageNumber.getId())});
                writer.writeCell(rowIndex, 1, (Object)primaryMessage.getSoleAttributeAsString((AttributeTypeToken)CoreAttributeTypes.InterfaceMessageRate, "Aperiodic"), new ExcelWorkbookWriter.CELLSTYLE[]{this.getCellColor(primaryMessage, CoreAttributeTypes.InterfaceMessageRate.getId())});
                writer.writeCell(rowIndex, 2, (Object)primaryMessage.getSoleAttributeAsString((AttributeTypeToken)CoreAttributeTypes.InterfaceMessageWriteAccess), new ExcelWorkbookWriter.CELLSTYLE[]{this.getCellColor(primaryMessage, CoreAttributeTypes.InterfaceMessageWriteAccess.getId())});
                writer.writeCell(rowIndex, 3, (Object)primaryMessage.getName(), new ExcelWorkbookWriter.CELLSTYLE[]{this.getCellColor(primaryMessage, CoreAttributeTypes.Name.getId()), ExcelWorkbookWriter.CELLSTYLE.BOLD});
                writer.addMergedRegion(rowIndex, rowIndex, 3, 4);
            }
            if (secondaryMessage.isValid()) {
                writer.writeCell(rowIndex, 5, (Object)secondaryMessage.getSoleAttributeAsString((AttributeTypeToken)CoreAttributeTypes.InterfaceMessageNumber), new ExcelWorkbookWriter.CELLSTYLE[]{this.getCellColor(secondaryMessage, CoreAttributeTypes.InterfaceMessageNumber.getId())});
                writer.writeCell(rowIndex, 6, (Object)secondaryMessage.getSoleAttributeAsString((AttributeTypeToken)CoreAttributeTypes.InterfaceMessageRate, "Aperiodic"), new ExcelWorkbookWriter.CELLSTYLE[]{this.getCellColor(secondaryMessage, CoreAttributeTypes.InterfaceMessageRate.getId())});
                writer.writeCell(rowIndex, 7, (Object)secondaryMessage.getSoleAttributeAsString((AttributeTypeToken)CoreAttributeTypes.InterfaceMessageWriteAccess), new ExcelWorkbookWriter.CELLSTYLE[]{this.getCellColor(secondaryMessage, CoreAttributeTypes.InterfaceMessageWriteAccess.getId())});
                writer.writeCell(rowIndex, 8, (Object)secondaryMessage.getName(), new ExcelWorkbookWriter.CELLSTYLE[]{this.getCellColor(secondaryMessage, CoreAttributeTypes.Name.getId()), ExcelWorkbookWriter.CELLSTYLE.BOLD});
                writer.addMergedRegion(rowIndex, rowIndex, 8, 9);
            }
            ++rowIndex;
            if (primaryMessage.isValid()) {
                writer.writeCell(rowIndex, 3, (Object)"Software Interface Header", new ExcelWorkbookWriter.CELLSTYLE[]{this.getCellColor(primaryMessage, false)});
                writer.addMergedRegion(rowIndex, rowIndex, 3, 4);
            }
            if (secondaryMessage.isValid()) {
                writer.writeCell(rowIndex, 8, (Object)"Software Interface Header", new ExcelWorkbookWriter.CELLSTYLE[]{this.getCellColor(secondaryMessage, false)});
                writer.addMergedRegion(rowIndex, rowIndex, 8, 9);
            }
            ++rowIndex;
            int numSubMessages = Math.max(primarySubMessages.size(), secondarySubMessages.size());
            int j = 0;
            while (j < numSubMessages) {
                ArtifactReadable subMessage;
                if (j < primarySubMessages.size()) {
                    subMessage = (ArtifactReadable)primarySubMessages.get(j);
                    writer.writeCell(rowIndex, 3, (Object)("Submessage " + (j + 1) + ":"), new ExcelWorkbookWriter.CELLSTYLE[]{this.getCellColor(subMessage, CoreAttributeTypes.Name.getId())});
                    writer.writeCell(rowIndex, 4, (Object)subMessage.getName(), new ExcelWorkbookWriter.CELLSTYLE[]{this.getCellColor(subMessage, CoreAttributeTypes.Name.getId())});
                }
                if (j < secondarySubMessages.size()) {
                    subMessage = (ArtifactReadable)secondarySubMessages.get(j);
                    writer.writeCell(rowIndex, 8, (Object)("Submessage " + (j + 1) + ":"), new ExcelWorkbookWriter.CELLSTYLE[]{this.getCellColor(subMessage, CoreAttributeTypes.Name.getId())});
                    writer.writeCell(rowIndex, 9, (Object)subMessage.getName(), new ExcelWorkbookWriter.CELLSTYLE[]{this.getCellColor(subMessage, CoreAttributeTypes.Name.getId())});
                }
                ++rowIndex;
                ++j;
            }
            if (primaryMessage.isValid()) {
                writer.addMergedRegion(rowIndex - numSubMessages - 2, rowIndex - 1, 0, 0);
                writer.addMergedRegion(rowIndex - numSubMessages - 2, rowIndex - 1, 1, 1);
                writer.addMergedRegion(rowIndex - numSubMessages - 2, rowIndex - 1, 2, 2);
            }
            if (secondaryMessage.isValid()) {
                writer.addMergedRegion(rowIndex - numSubMessages - 2, rowIndex - 1, 5, 5);
                writer.addMergedRegion(rowIndex - numSubMessages - 2, rowIndex - 1, 6, 6);
                writer.addMergedRegion(rowIndex - numSubMessages - 2, rowIndex - 1, 7, 7);
            }
            ++i;
        }
        writer.autoSizeAllColumns(10);
        writer.setColumnWidth(0, 3000);
        writer.setColumnWidth(1, 3000);
        writer.setColumnWidth(5, 3000);
        writer.setColumnWidth(6, 3000);
    }

    private ExcelWorkbookWriter.CELLSTYLE getCellColor(ArtifactReadable artifact, boolean changed) {
        MimDifferenceItem diffItem = artifact == null ? null : this.diffs.get(ArtifactId.valueOf((Long)artifact.getId()));
        ExcelWorkbookWriter.CELLSTYLE style = ExcelWorkbookWriter.CELLSTYLE.NONE;
        if (diffItem != null) {
            style = diffItem.isAdded() ? ExcelWorkbookWriter.CELLSTYLE.GREEN : (changed ? ExcelWorkbookWriter.CELLSTYLE.YELLOW : ExcelWorkbookWriter.CELLSTYLE.NONE);
        }
        return style;
    }

    private ExcelWorkbookWriter.CELLSTYLE getCellColor(ArtifactReadable artifact, Long attrId) {
        return this.getCellColor(artifact, artifact, attrId);
    }

    private ExcelWorkbookWriter.CELLSTYLE getCellColor(ArtifactReadable rowArtifact, ArtifactReadable cellArtifact, Long attrId) {
        MimDifferenceItem diffItem;
        MimDifferenceItem cellDiffItem;
        MimDifferenceItem rowDiffItem = rowArtifact == null ? null : this.diffs.get(ArtifactId.valueOf((Long)rowArtifact.getId()));
        MimDifferenceItem mimDifferenceItem = cellDiffItem = cellArtifact == null ? null : this.diffs.get(ArtifactId.valueOf((Long)cellArtifact.getId()));
        if (rowDiffItem != null && rowDiffItem.isAdded()) {
            return ExcelWorkbookWriter.CELLSTYLE.GREEN;
        }
        ExcelWorkbookWriter.CELLSTYLE color = ExcelWorkbookWriter.CELLSTYLE.NONE;
        MimDifferenceItem mimDifferenceItem2 = diffItem = rowDiffItem != null && rowDiffItem.isAdded() ? rowDiffItem : cellDiffItem;
        if (diffItem != null) {
            color = diffItem.isAdded() ? ExcelWorkbookWriter.CELLSTYLE.GREEN : (diffItem.getDiffs().keySet().contains(attrId) ? ExcelWorkbookWriter.CELLSTYLE.YELLOW : ExcelWorkbookWriter.CELLSTYLE.NONE);
        }
        return color;
    }

    private class StructureInfo {
        final String name;
        final String category;
        final String categoryFull;
        final String txRate;
        final String minSim;
        final String maxSim;
        final String minBps;
        final String maxBps;
        final Integer numAttributes;
        final Integer sizeInBytes;
        final String initiator;
        final String msgNum;
        final String subMsgNum;
        final String taskfile;
        final String description;
        final ArtifactReadable message;
        final ArtifactReadable submessage;
        final List<ArtifactReadable> elements;
        final boolean structureChanged;
        final boolean txRateChanged;
        final boolean numElementsChanged;
        final boolean structureSizeChanged;
        final int byteChangeIndex;

        public StructureInfo(String name, String cat, String catFull, String msgRateText, String minSim, String maxSim, String minBps, String maxBps, Integer elementCount, Integer sizeInBytes, String sendingNode, String msgNumber, String subMsgNumber, String taskfile, String desc, ArtifactReadable message, ArtifactReadable submessage, List<ArtifactReadable> elements, boolean structureChanged, boolean txRateChanged, boolean numElementsChanged, boolean structureSizeChanged, int byteChangeIndex) {
            this.name = name;
            this.category = cat;
            this.categoryFull = catFull;
            this.txRate = msgRateText;
            this.minSim = minSim;
            this.maxSim = maxSim;
            this.minBps = minBps;
            this.maxBps = maxBps;
            this.numAttributes = elementCount;
            this.sizeInBytes = sizeInBytes;
            this.initiator = sendingNode;
            this.msgNum = msgNumber;
            this.subMsgNum = subMsgNumber;
            this.taskfile = taskfile;
            this.description = desc;
            this.message = message;
            this.submessage = submessage;
            this.elements = elements;
            this.structureChanged = structureChanged;
            this.txRateChanged = txRateChanged;
            this.numElementsChanged = numElementsChanged;
            this.structureSizeChanged = structureSizeChanged;
            this.byteChangeIndex = byteChangeIndex;
        }
    }
}

