/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.icteam.web.rest.layer.structure.resources;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.internal.LinkedTreeMap;
import flexjson.JSONSerializer;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.temporal.ChronoUnit;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;
import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import org.eclipse.osee.ats.api.AtsApi;
import org.eclipse.osee.ats.api.data.AtsArtifactTypes;
import org.eclipse.osee.ats.api.data.AtsAttributeTypes;
import org.eclipse.osee.ats.api.data.AtsRelationTypes;
import org.eclipse.osee.ats.rest.util.AbstractConfigResource;
import org.eclipse.osee.framework.core.data.ArtifactReadable;
import org.eclipse.osee.framework.core.data.ArtifactTypeToken;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.enums.CoreBranches;
import org.eclipse.osee.framework.jdk.core.type.ResultSet;
import org.eclipse.osee.icteam.common.artifact.interfaces.ITransferableArtifact;
import org.eclipse.osee.icteam.common.clientserver.dependent.datamodel.TransferableArtifact;
import org.eclipse.osee.icteam.server.access.core.OseeCoreData;
import org.eclipse.osee.icteam.web.rest.layer.util.BurnDownData;
import org.eclipse.osee.icteam.web.rest.layer.util.CommonUtil;
import org.eclipse.osee.icteam.web.rest.layer.util.InterfaceAdapter;
import org.eclipse.osee.orcs.OrcsApi;

@Path(value="Charts")
public class ChartingResource
extends AbstractConfigResource {
    SimpleDateFormat simpleDateFormat = new SimpleDateFormat("dd-MM-yyyy");
    SimpleDateFormat simpleDateFormatReverse = new SimpleDateFormat("yyyy-MM-dd");
    private static final String COMPLETED = "Completed";

    public ChartingResource(AtsApi atsApi, OrcsApi orcsApi) {
        super(AtsArtifactTypes.Version, atsApi, orcsApi);
    }

    @POST
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    @Path(value="getEffortBurnDownInfo")
    public String getBurnDownInfoData(String sprintGuid) {
        OrcsApi orcsApi = OseeCoreData.getOrcsApi();
        Gson gson = new GsonBuilder().registerTypeAdapter(ITransferableArtifact.class, new InterfaceAdapter()).create();
        TransferableArtifact artifact = (TransferableArtifact)gson.fromJson(sprintGuid, TransferableArtifact.class);
        ResultSet list = orcsApi.getQueryFactory().fromBranch((BranchId)CoreBranches.COMMON).andIsOfType(new ArtifactTypeToken[]{AtsArtifactTypes.Version}).andUuid(Long.valueOf(artifact.getUuid()).longValue()).getResults();
        Date startDate = null;
        Date endDate = null;
        float totalTime = 0.0f;
        TreeMap<Date, Float> burnDownDataMap = new TreeMap<Date, Float>();
        if (!list.isEmpty()) {
            ArtifactReadable artifactReadable = (ArtifactReadable)list.getOneOrNull();
            String startDateString = artifactReadable.getAttributeValuesAsString((AttributeTypeToken)AtsAttributeTypes.StartDate);
            String releaseDateString = artifactReadable.getAttributeValuesAsString((AttributeTypeToken)AtsAttributeTypes.ReleaseDate);
            try {
                startDate = this.simpleDateFormatReverse.parse(startDateString);
                endDate = this.simpleDateFormatReverse.parse(releaseDateString);
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
            if (artifactReadable != null) {
                ResultSet taskResultSet = artifactReadable.getRelated(AtsRelationTypes.TeamWorkflowTargetedForVersion_TeamWorkflow);
                List tasksList = taskResultSet.getList();
                for (ArtifactReadable artReadable : tasksList) {
                    String attributeValuesAsString = artReadable.getAttributeValuesAsString((AttributeTypeToken)AtsAttributeTypes.BurnDownData);
                    LinkedHashMap burnDownMap = (LinkedHashMap)gson.fromJson(attributeValuesAsString, LinkedHashMap.class);
                    if (burnDownMap == null) continue;
                    Set burnDownEntries = burnDownMap.entrySet();
                    boolean isFirst = true;
                    for (Map.Entry burnDownEntry : burnDownEntries) {
                        String timeSpentStr;
                        float timeSpent2;
                        Date date2 = null;
                        if (burnDownEntry.getKey() instanceof String) {
                            String dateString = (String)burnDownEntry.getKey();
                            try {
                                date2 = this.simpleDateFormatReverse.parse(dateString);
                            }
                            catch (ParseException e) {
                                e.printStackTrace();
                            }
                        }
                        String estimatedTime = (String)((LinkedTreeMap)burnDownEntry.getValue()).get((Object)"first");
                        if (isFirst) {
                            totalTime += Float.parseFloat(estimatedTime);
                            isFirst = false;
                        }
                        float f = timeSpent2 = !(timeSpentStr = (String)((LinkedTreeMap)burnDownEntry.getValue()).get((Object)"second")).isEmpty() ? Float.parseFloat(timeSpentStr) : 0.0f;
                        if (burnDownDataMap.containsKey(date2)) {
                            burnDownDataMap.merge(date2, Float.valueOf(timeSpent2), (oldValue, newValue) -> Float.valueOf(oldValue.floatValue() + newValue.floatValue()));
                            continue;
                        }
                        burnDownDataMap.put(date2, Float.valueOf(timeSpent2));
                    }
                }
            }
        }
        Map<Object, Object> updatedMap = new LinkedHashMap();
        try {
            updatedMap = this.identifyAndFillEmptyDates(burnDownDataMap, startDate, endDate);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        LinkedList<Object> linkedList = new LinkedList<Object>(updatedMap.keySet());
        Date currentDate = (Date)linkedList.getLast();
        for (Map.Entry<Object, Object> entry : updatedMap.entrySet()) {
            updatedMap.merge((Date)entry.getKey(), Float.valueOf(totalTime), (timeSpent, total) -> Float.valueOf(total.floatValue() - timeSpent.floatValue()));
        }
        long totalNumberOfDays = this.getNoOfDays(startDate, endDate);
        try {
            this.fillRemainingDates(updatedMap, currentDate, endDate);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        Set<Object> datesSet = updatedMap.keySet();
        List<String> datesString = datesSet.stream().map(date -> this.simpleDateFormat.format((Date)date)).collect(Collectors.toList());
        Collection<Object> values = updatedMap.values();
        BurnDownData burnDown = new BurnDownData();
        burnDown.setDatesSet(datesString);
        burnDown.setRemainingTimeSet(values);
        burnDown.setTotalTime(totalTime);
        burnDown.setNoOfDays((int)totalNumberOfDays);
        JSONSerializer jsonSerializer = new JSONSerializer();
        String burnDownData = jsonSerializer.deepSerialize((Object)burnDown);
        return burnDownData;
    }

    @POST
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    @Path(value="getStoryPointsBurndown")
    public String getStoryPointsBurndownData(String sprintGuid) {
        OrcsApi orcsApi = OseeCoreData.getOrcsApi();
        Gson gson = new GsonBuilder().registerTypeAdapter(ITransferableArtifact.class, new InterfaceAdapter()).create();
        TransferableArtifact artifact = (TransferableArtifact)gson.fromJson(sprintGuid, TransferableArtifact.class);
        ResultSet list = orcsApi.getQueryFactory().fromBranch((BranchId)CoreBranches.COMMON).andIsOfType(new ArtifactTypeToken[]{AtsArtifactTypes.Version}).andUuid(Long.valueOf(artifact.getUuid()).longValue()).getResults();
        Date startDate = null;
        Date endDate = null;
        int totalStoryPoints = 0;
        TreeMap<Date, Float> burnDownDataMap = new TreeMap<Date, Float>();
        if (!list.isEmpty()) {
            ArtifactReadable artifactReadable = (ArtifactReadable)list.getOneOrNull();
            String startDateString = artifactReadable.getAttributeValuesAsString((AttributeTypeToken)AtsAttributeTypes.StartDate);
            String releaseDateString = artifactReadable.getAttributeValuesAsString((AttributeTypeToken)AtsAttributeTypes.ReleaseDate);
            try {
                startDate = this.simpleDateFormatReverse.parse(startDateString);
                endDate = this.simpleDateFormatReverse.parse(releaseDateString);
            }
            catch (ParseException e1) {
                e1.printStackTrace();
            }
            if (artifactReadable != null) {
                ResultSet taskResultSet = artifactReadable.getRelated(AtsRelationTypes.TeamWorkflowTargetedForVersion_TeamWorkflow);
                List tasksList = taskResultSet.getList();
                Iterator<Object> iterator = tasksList.iterator();
                while (iterator.hasNext()) {
                    String completedDateString;
                    ArtifactReadable artifactReadable2 = (ArtifactReadable)iterator.next();
                    String storyPoints = artifactReadable2.getAttributeValuesAsString((AttributeTypeToken)AtsAttributeTypes.PointsAttributeType);
                    String taskState = artifactReadable2.getAttributeValuesAsString((AttributeTypeToken)AtsAttributeTypes.CurrentStateType);
                    int currentStoryPoint = 0;
                    if (!storyPoints.isEmpty()) {
                        currentStoryPoint = Integer.parseInt(storyPoints);
                    }
                    totalStoryPoints += currentStoryPoint;
                    burnDownDataMap.put(startDate, Float.valueOf(0.0f));
                    if (!taskState.equals(COMPLETED) || (completedDateString = artifactReadable2.getAttributeValuesAsString((AttributeTypeToken)AtsAttributeTypes.CompletedDate)).isEmpty()) continue;
                    Date completedDate = null;
                    try {
                        completedDate = this.simpleDateFormatReverse.parse(completedDateString);
                    }
                    catch (ParseException e) {
                        e.printStackTrace();
                    }
                    if (!burnDownDataMap.containsKey(completedDate)) {
                        burnDownDataMap.put(completedDate, Float.valueOf(currentStoryPoint));
                        continue;
                    }
                    Float completedStoryPoints = (Float)burnDownDataMap.get(completedDate);
                    completedStoryPoints = Float.valueOf(completedStoryPoints.floatValue() + (float)currentStoryPoint);
                    burnDownDataMap.put(completedDate, Float.valueOf(completedStoryPoints.floatValue()));
                }
            }
        }
        Map<Object, Object> updatedMap = new LinkedHashMap();
        try {
            updatedMap = this.identifyAndFillEmptyDates(burnDownDataMap, startDate, endDate);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        TreeMap<Date, Float> hashMap = new TreeMap<Date, Float>();
        float storyPoints = 0.0f;
        for (Map.Entry<Object, Object> entry : updatedMap.entrySet()) {
            Date date2 = (Date)entry.getKey();
            hashMap.put(date2, Float.valueOf(storyPoints += ((Float)entry.getValue()).floatValue()));
        }
        LinkedList linkedList = new LinkedList(hashMap.keySet());
        Date currentDate = (Date)linkedList.getLast();
        for (Map.Entry entry : hashMap.entrySet()) {
            hashMap.merge((Date)entry.getKey(), Float.valueOf(totalStoryPoints), (oldValue, total) -> Float.valueOf(total.floatValue() - oldValue.floatValue()));
        }
        long l = this.getNoOfDays(startDate, endDate);
        try {
            this.fillRemainingDates(hashMap, currentDate, endDate);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        Set datesSet = hashMap.keySet();
        List<String> datesString = datesSet.stream().map(date -> this.simpleDateFormat.format((Date)date)).collect(Collectors.toList());
        Collection<Float> remainingStoryPoints = hashMap.values();
        List<Float> practicalStoryPointsData = CommonUtil.getPracticalStoryPointsData(l + 1L, totalStoryPoints);
        BurnDownData burnDownData = new BurnDownData();
        burnDownData.setDatesSet(datesString);
        burnDownData.setNoOfDays((int)l);
        burnDownData.setRemainingStoryPoints(remainingStoryPoints);
        burnDownData.setTotalStoryPoints(totalStoryPoints);
        burnDownData.setPracticalStoryPoints(practicalStoryPointsData);
        JSONSerializer jsonSerializer = new JSONSerializer();
        String burnDownStoryPoints = jsonSerializer.deepSerialize((Object)burnDownData);
        return burnDownStoryPoints;
    }

    private long getNoOfDays(Date startDate, Date endDate) {
        return ChronoUnit.DAYS.between(startDate.toInstant(), endDate.toInstant());
    }

    private void fillRemainingDates(Map<Date, Float> burnDownDataMap, Date currentDate, Date endDate) throws ParseException {
        if (currentDate.compareTo(endDate) == 0) {
            return;
        }
        long noOfDays = this.getNoOfDays(currentDate, endDate);
        int i = 0;
        while ((long)i < noOfDays) {
            Date incrementedDate = this.incrementDatebyOne(currentDate);
            burnDownDataMap.put(incrementedDate, null);
            currentDate = incrementedDate;
            ++i;
        }
    }

    private Map<Date, Float> identifyAndFillEmptyDates(Map<Date, Float> burnDownDataMap, Date startDate, Date endDate) throws ParseException {
        LinkedHashMap<Date, Float> updatedMap = new LinkedHashMap<Date, Float>();
        Set<Map.Entry<Date, Float>> entrySet = burnDownDataMap.entrySet();
        Iterator<Map.Entry<Date, Float>> iterator = entrySet.iterator();
        Date previousDate = null;
        float previousTime = 0.0f;
        boolean isFirst = true;
        while (iterator.hasNext()) {
            Map.Entry<Date, Float> next = iterator.next();
            Date date = next.getKey();
            Float remainingTime = next.getValue();
            if (isFirst) {
                if (date.compareTo(startDate) == 0) {
                    updatedMap.put(startDate, remainingTime);
                } else {
                    updatedMap.put(date, remainingTime);
                }
                isFirst = false;
            } else {
                if (date.compareTo(previousDate) == 0) {
                    updatedMap.put(date, remainingTime);
                } else {
                    long noOfDays = this.getNoOfDays(previousDate, date);
                    int i = 1;
                    while ((long)i < noOfDays) {
                        Date incrementedDate = this.incrementDatebyOne(previousDate);
                        updatedMap.put(incrementedDate, Float.valueOf(previousTime));
                        previousDate = incrementedDate;
                        ++i;
                    }
                }
                updatedMap.put(date, remainingTime);
            }
            previousDate = date;
            previousTime = remainingTime.floatValue();
        }
        return updatedMap;
    }

    private Date incrementDatebyOne(Date date) throws ParseException {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(5, 1);
        String newDate = this.simpleDateFormat.format(calendar.getTime());
        Date incrementedDate = this.simpleDateFormat.parse(newDate);
        return incrementedDate;
    }
}

