/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.authentication.admin;

import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.osee.authentication.admin.AuthenticationConfiguration;
import org.eclipse.osee.authentication.admin.AuthenticationConstants;
import org.eclipse.osee.authentication.admin.internal.AuthenticationUtil;
import org.eclipse.osee.framework.jdk.core.util.Strings;

public class AuthenticationConfigurationBuilder {
    private final AuthenticationConfigurationImpl config = new AuthenticationConfigurationImpl();

    private AuthenticationConfigurationBuilder() {
    }

    public static AuthenticationConfigurationBuilder newBuilder() {
        return new AuthenticationConfigurationBuilder();
    }

    public AuthenticationConfigurationBuilder scheme(String scheme) {
        this.config.addScheme(scheme);
        return this;
    }

    public AuthenticationConfigurationBuilder properties(Map<String, Object> props) {
        this.config.loadProperties(props);
        return this;
    }

    public AuthenticationConfigurationBuilder defaultScheme(String scheme) {
        this.config.setDefaultScheme(scheme);
        return this;
    }

    public AuthenticationConfiguration build() {
        return this.config.clone();
    }

    private static final class AuthenticationConfigurationImpl
    implements AuthenticationConfiguration,
    Cloneable {
        private final Set<String> schemes = new HashSet<String>();
        private String defaultScheme;

        private AuthenticationConfigurationImpl() {
        }

        @Override
        public Iterable<String> getAllowedSchemes() {
            return AuthenticationUtil.unmodifiableSortedIterable(this.schemes);
        }

        public void addSchemes(Collection<String> toAdd) {
            if (toAdd != null && !toAdd.isEmpty()) {
                this.schemes.addAll(toAdd);
            }
        }

        public void addScheme(String scheme) {
            if (Strings.isValid((String)scheme)) {
                this.schemes.add(scheme);
            }
        }

        @Override
        public String getDefaultScheme() {
            return this.defaultScheme;
        }

        public void setDefaultScheme(String defaultScheme) {
            this.defaultScheme = defaultScheme;
        }

        public synchronized AuthenticationConfigurationImpl clone() {
            AuthenticationConfigurationImpl cloned = new AuthenticationConfigurationImpl();
            cloned.addSchemes(this.schemes);
            cloned.setDefaultScheme(this.getDefaultScheme());
            return cloned;
        }

        public void loadProperties(Map<String, Object> props) {
            if (props != null && !props.isEmpty()) {
                this.addSchemes(this.getSet(props, AuthenticationConstants.AUTHENTICATION_SCHEME_ALLOWED, "None"));
                this.setDefaultScheme(this.get(props, AuthenticationConstants.AUTHENTICATION_SCHEME_ALLOWED_DEFAULT, ""));
            }
        }

        public Collection<String> getSet(Map<String, Object> props, String key, String defaultValue) {
            HashSet<String> toReturn = new HashSet<String>();
            String joinedArray = this.get(props, key, "");
            if (Strings.isValid((String)joinedArray)) {
                String[] split;
                String[] stringArray = split = joinedArray.split(",");
                int n = split.length;
                int n2 = 0;
                while (n2 < n) {
                    String value = stringArray[n2];
                    String toAdd = AuthenticationUtil.normalize(value);
                    if (Strings.isValid((String)toAdd)) {
                        toReturn.add(toAdd);
                    }
                    ++n2;
                }
            } else {
                toReturn.add(defaultValue);
            }
            return toReturn;
        }

        private String get(Map<String, Object> props, String key, String defaultValue) {
            String toReturn = defaultValue;
            Object object = props.get(key);
            if (object != null) {
                toReturn = String.valueOf(object);
            }
            return toReturn;
        }
    }
}

