/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.config.keys.loader;

import java.io.IOException;
import java.security.GeneralSecurityException;
import java.util.Collections;
import java.util.List;
import org.apache.sshd.common.config.keys.loader.AbstractPrivateKeyObfuscator;
import org.apache.sshd.common.config.keys.loader.PrivateKeyEncryptionContext;

public class DESPrivateKeyObfuscator
extends AbstractPrivateKeyObfuscator {
    public static final int DEFAULT_KEY_LENGTH = 24;
    public static final List<Integer> AVAILABLE_KEY_LENGTHS = Collections.unmodifiableList(Collections.singletonList(24));
    public static final DESPrivateKeyObfuscator INSTANCE = new DESPrivateKeyObfuscator();

    public DESPrivateKeyObfuscator() {
        super("DES");
    }

    @Override
    public byte[] applyPrivateKeyCipher(byte[] bytes, PrivateKeyEncryptionContext encContext, boolean encryptIt) throws GeneralSecurityException, IOException {
        PrivateKeyEncryptionContext effContext = DESPrivateKeyObfuscator.resolveEffectiveContext(encContext);
        byte[] keyValue = this.deriveEncryptionKey(effContext, 24);
        return this.applyPrivateKeyCipher(bytes, effContext, keyValue.length * 8, keyValue, encryptIt);
    }

    @Override
    public List<Integer> getSupportedKeySizes() {
        return AVAILABLE_KEY_LENGTHS;
    }

    @Override
    protected int resolveKeyLength(PrivateKeyEncryptionContext encContext) throws GeneralSecurityException {
        return 24;
    }

    @Override
    protected byte[] generateInitializationVector(int keyLength) {
        return super.generateInitializationVector(64);
    }

    public static final PrivateKeyEncryptionContext resolveEffectiveContext(PrivateKeyEncryptionContext encContext) {
        if (encContext == null) {
            return null;
        }
        String cipherName = encContext.getCipherName();
        String cipherType = encContext.getCipherType();
        PrivateKeyEncryptionContext effContext = encContext;
        if ("EDE3".equalsIgnoreCase(cipherType)) {
            cipherName = cipherName + "ede";
            effContext = encContext.clone();
            effContext.setCipherName(cipherName);
        }
        return effContext;
    }
}

