/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.rest.internal.search.artifact.dsl;

import java.util.List;
import java.util.Map;
import org.eclipse.osee.framework.jdk.core.type.OseeArgumentException;
import org.eclipse.osee.framework.jdk.core.util.Conditions;
import org.eclipse.osee.orcs.OrcsApi;
import org.eclipse.osee.orcs.rest.internal.search.artifact.PredicateHandler;
import org.eclipse.osee.orcs.rest.model.search.artifact.Predicate;
import org.eclipse.osee.orcs.rest.model.search.artifact.SearchMethod;
import org.eclipse.osee.orcs.rest.model.search.artifact.SearchRequest;
import org.eclipse.osee.orcs.search.QueryBuilder;
import org.eclipse.osee.orcs.search.QueryFactory;

public class SearchQueryBuilder {
    private final OrcsApi orcsApi;
    private final Map<SearchMethod, PredicateHandler> handlers;

    public SearchQueryBuilder(OrcsApi orcsApi, Map<SearchMethod, PredicateHandler> handlers) {
        this.orcsApi = orcsApi;
        this.handlers = handlers;
    }

    public QueryBuilder build(QueryFactory queryFactory, SearchRequest params) {
        Conditions.checkNotNull((Object)queryFactory, (String)"queryFactory");
        Conditions.checkNotNull((Object)params, (String)"params");
        QueryBuilder builder = queryFactory.fromBranch(params.getBranch());
        List predicates = params.getPredicates();
        if (predicates != null) {
            for (Predicate predicate : predicates) {
                SearchMethod method = predicate.getType();
                PredicateHandler handler = this.handlers.get(method);
                if (handler != null) {
                    builder = handler.handle(this.orcsApi, builder, predicate);
                    continue;
                }
                throw new OseeArgumentException("Unable to find PredicateHandler for %s", new Object[]{method.name()});
            }
        }
        return builder;
    }
}

