/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.define.rest.synchronization;

import java.util.Objects;
import org.eclipse.osee.define.rest.synchronization.IdentifierType;
import org.eclipse.osee.define.rest.synchronization.IdentifierTypeGroup;

public class UnexpectedIdentifierTypeException
extends RuntimeException {
    private static final long serialVersionUID = 1L;

    public UnexpectedIdentifierTypeException(IdentifierType identifierType, IdentifierTypeGroup expectedIdentifierTypeGroup) {
        super(UnexpectedIdentifierTypeException.buildMessage(identifierType, expectedIdentifierTypeGroup));
    }

    public UnexpectedIdentifierTypeException(IdentifierType identifierType, Throwable cause, IdentifierTypeGroup expectedIdentifierTypeGroup) {
        this(identifierType, expectedIdentifierTypeGroup);
        this.initCause(cause);
    }

    public static String buildMessage(IdentifierType identifierType, IdentifierTypeGroup expectedIdentifierTypeGroup) {
        return new StringBuilder(1024).append("\n").append("Unexpected IdentifierType.").append("\n").append("   Identifier Type:                ").append(Objects.nonNull(identifierType) ? identifierType : "(null)").append("\n").append("   Expected Identifier Type Group: ").append(Objects.nonNull(expectedIdentifierTypeGroup) ? expectedIdentifierTypeGroup : "(null)").append("\n").append("   Expected Identifier Types:      ").append(Objects.nonNull(expectedIdentifierTypeGroup) ? IdentifierType.getIdentifierTypeGroupMembersMessage(expectedIdentifierTypeGroup) : "(null)").append("\n").toString();
    }
}

