/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.define.rest.synchronization;

import java.io.InputStream;
import java.util.Objects;
import org.eclipse.osee.define.api.synchronization.ExportRequest;
import org.eclipse.osee.define.api.synchronization.ImportRequest;
import org.eclipse.osee.define.api.synchronization.SynchronizationEndpoint;
import org.eclipse.osee.define.rest.synchronization.SynchronizationEndpointImpl;
import org.eclipse.osee.logger.Log;
import org.eclipse.osee.orcs.OrcsApi;

public class ServiceStart
implements SynchronizationEndpoint {
    private Log logger = null;
    private OrcsApi orcsApi = null;
    private SynchronizationEndpoint synchronizationEndpoint = null;

    public void setOrcsApi(OrcsApi orcsApi) {
        this.orcsApi = orcsApi;
    }

    public void setLogger(Log logger) {
        this.logger = logger;
    }

    public void start() {
        assert (Objects.nonNull(this.orcsApi) && Objects.nonNull(this.logger));
        this.synchronizationEndpoint = SynchronizationEndpointImpl.create(this.orcsApi);
        this.logger.warn("Synchronization Artifact Service Started - %s", new Object[]{System.getProperty("OseeApplicationServer")});
    }

    public InputStream export(ExportRequest exportRequest) {
        return this.synchronizationEndpoint.export(exportRequest);
    }

    public void importSynchronizationArtifact(ImportRequest importRequest, InputStream inputStream) {
        this.synchronizationEndpoint.importSynchronizationArtifact(importRequest, inputStream);
    }
}

