/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.template.engine;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.osee.template.engine.AppendableRule;

public final class CompositeRule<T>
extends AppendableRule<T> {
    private final List<AppendableRule<T>> rules = new ArrayList<AppendableRule<T>>();

    public CompositeRule(String ruleName) {
        super(ruleName);
    }

    @Override
    public void applyTo(Appendable appendable) throws IOException {
        for (AppendableRule<T> rule : this.rules) {
            rule.applyTo(appendable);
        }
    }

    @Override
    public void applyTo(Appendable appendable, T data) throws IOException {
        for (AppendableRule<T> rule : this.rules) {
            rule.applyTo(appendable, data);
        }
    }

    public void addRule(AppendableRule<T> rule) {
        this.rules.add(rule);
    }

    public boolean ruleExists(String ruleName) {
        for (AppendableRule<T> rule : this.rules) {
            if (!rule.getName().equals(ruleName)) continue;
            return true;
        }
        return false;
    }
}

