/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.db.internal.search.util;

import com.google.common.base.Supplier;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.orcs.core.ds.ArtifactData;
import org.eclipse.osee.orcs.core.ds.AttributeData;
import org.eclipse.osee.orcs.core.ds.RelationData;

public class LoadDataBuffer {
    private final Map<ArtifactId, ArtifactData> artifacts;
    private final Multimap<ArtifactId, AttributeData<?>> attributes;
    private final Multimap<ArtifactId, RelationData> relations;

    public LoadDataBuffer(int initialSize) {
        this.artifacts = new LinkedHashMap<ArtifactId, ArtifactData>(initialSize);
        this.attributes = LoadDataBuffer.newLinkedHashListMultimap(initialSize);
        this.relations = LoadDataBuffer.newLinkedHashListMultimap(initialSize);
    }

    public synchronized void clear() {
        this.artifacts.clear();
        this.attributes.clear();
        this.relations.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addData(ArtifactData data) {
        Map<ArtifactId, ArtifactData> map = this.artifacts;
        synchronized (map) {
            this.artifacts.put((ArtifactId)data, data);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addData(AttributeData<?> data) {
        Multimap<ArtifactId, AttributeData<?>> multimap = this.attributes;
        synchronized (multimap) {
            this.attributes.put((Object)data.getArtifactId(), data);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addData(RelationData data) {
        Multimap<ArtifactId, RelationData> multimap = this.relations;
        synchronized (multimap) {
            this.relations.put((Object)data.getArtifactIdA(), (Object)data);
            this.relations.put((Object)data.getArtifactIdB(), (Object)data);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArtifactData removeArtifactByArtId(ArtifactId artifactId) {
        ArtifactData art = null;
        Map<ArtifactId, ArtifactData> map = this.artifacts;
        synchronized (map) {
            art = this.artifacts.remove(artifactId);
        }
        return art;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterable<AttributeData<?>> removeAttributesByArtId(ArtifactId artifactId) {
        Collection data = null;
        Multimap<ArtifactId, AttributeData<?>> multimap = this.attributes;
        synchronized (multimap) {
            data = this.attributes.removeAll((Object)artifactId);
        }
        return data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterable<RelationData> removeRelationsByArtId(ArtifactId artifactId) {
        Collection rels = null;
        Multimap<ArtifactId, RelationData> multimap = this.relations;
        synchronized (multimap) {
            rels = this.relations.removeAll((Object)artifactId);
        }
        return rels;
    }

    private static <K, V> ListMultimap<K, V> newLinkedHashListMultimap(int fetchSize) {
        LinkedHashMap map = new LinkedHashMap(fetchSize);
        return Multimaps.newListMultimap(map, (Supplier)new Supplier<List<V>>(){

            public List<V> get() {
                return Lists.newArrayList();
            }
        });
    }
}

