/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.db.internal.exchange.export;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Timestamp;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.type.PropertyStore;
import org.eclipse.osee.framework.jdk.core.util.Lib;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.framework.jdk.core.util.xml.Xml;
import org.eclipse.osee.framework.resource.management.IResource;
import org.eclipse.osee.framework.resource.management.IResourceLocator;
import org.eclipse.osee.framework.resource.management.IResourceManager;
import org.eclipse.osee.jdbc.JdbcClient;
import org.eclipse.osee.jdbc.JdbcStatement;
import org.eclipse.osee.logger.Log;
import org.eclipse.osee.orcs.db.internal.exchange.ExportImportXml;
import org.eclipse.osee.orcs.db.internal.exchange.export.AbstractXmlExportItem;
import org.eclipse.osee.orcs.db.internal.exchange.handler.ExportItem;

public class DbTableExportItem
extends AbstractXmlExportItem {
    private final StringBuilder binaryContentBuffer = new StringBuilder();
    private final StringBuilder stringContentBuffer = new StringBuilder();
    private final StringBuilder oseeCommentBuffer = new StringBuilder();
    private final StringBuilder branchNameBuffer = new StringBuilder();
    private final StringBuilder rationaleBuffer = new StringBuilder();
    private final String query;
    private final Object[] bindData;
    private final JdbcClient jdbcClient;
    private final IResourceManager resourceManager;

    public DbTableExportItem(Log logger, JdbcClient jdbcClient, IResourceManager resourceManager, ExportItem id, String query, Object[] bindData) {
        super(logger, id);
        this.jdbcClient = jdbcClient;
        this.resourceManager = resourceManager;
        this.query = query;
        this.bindData = bindData;
    }

    private JdbcClient getJdbcClient() {
        return this.jdbcClient;
    }

    protected String exportBinaryDataTo(File tempFolder, String uriTarget) throws IOException {
        if (!(tempFolder = new File(tempFolder + File.separator + "resources")).exists()) {
            tempFolder.mkdirs();
        }
        IResourceLocator locator = this.resourceManager.getResourceLocator(uriTarget);
        IResource resource = this.resourceManager.acquire(locator, new PropertyStore());
        File target = new File(tempFolder, locator.getRawPath());
        if (target.getParentFile() != null) {
            target.getParentFile().mkdirs();
        }
        InputStream sourceStream = null;
        FileOutputStream outputStream = null;
        try {
            if (resource != null) {
                sourceStream = resource.getContent();
                outputStream = new FileOutputStream(target);
                Lib.inputStreamToOutputStream((InputStream)sourceStream, (OutputStream)outputStream);
            }
        }
        finally {
            Lib.close(sourceStream);
            Lib.close(outputStream);
        }
        return locator.getRawPath().replace('/', '\\');
    }

    @Override
    protected void doWork(Appendable appendable) {
        this.getJdbcClient().runQueryWithMaxFetchSize(stmt -> this.processData(appendable, (JdbcStatement)stmt), this.query, this.bindData);
    }

    private void processData(Appendable appendable, JdbcStatement chStmt) {
        try {
            ExportImportXml.openPartialXmlNode(appendable, "entry");
            try {
                int numberOfColumns = chStmt.getColumnCount();
                int columnIndex = 1;
                while (columnIndex <= numberOfColumns) {
                    String columnName = chStmt.getColumnName(columnIndex).toLowerCase();
                    Object value = chStmt.getObject(columnIndex);
                    if (columnName.equals("uri")) {
                        this.handleBinaryContent(this.binaryContentBuffer, value);
                    } else if (columnName.equals("value")) {
                        this.handleStringContent(this.stringContentBuffer, value, "stringContent");
                    } else if (columnName.equals("osee_comment")) {
                        this.handleStringContent(this.oseeCommentBuffer, value, columnName);
                    } else if (columnName.equals("branch_name")) {
                        this.handleStringContent(this.branchNameBuffer, value, columnName);
                    } else if (columnName.equals("rationale")) {
                        this.handleStringContent(this.rationaleBuffer, value, columnName);
                    } else if (columnName.equals("art_type_id")) {
                        this.handleTypeId(appendable, value);
                    } else if (columnName.equals("attr_type_id")) {
                        this.handleTypeId(appendable, value);
                    } else if (columnName.equals("rel_link_type_id")) {
                        this.handleTypeId(appendable, value);
                    } else {
                        Timestamp timestamp = this.asTimestamp(value);
                        if (timestamp != null) {
                            ExportImportXml.addXmlAttribute(appendable, columnName, timestamp);
                        } else {
                            try {
                                ExportImportXml.addXmlAttribute(appendable, columnName, value);
                            }
                            catch (Exception ex) {
                                throw new OseeCoreException((Throwable)ex, "Unable to convert [%s] of raw type [%s] to string.", new Object[]{columnName, chStmt.getColumnTypeName(columnIndex)});
                            }
                        }
                    }
                    ++columnIndex;
                }
            }
            finally {
                if (this.binaryContentBuffer.length() > 0 || this.stringContentBuffer.length() > 0 || this.oseeCommentBuffer.length() > 0 || this.branchNameBuffer.length() > 0 || this.rationaleBuffer.length() > 0) {
                    ExportImportXml.endOpenedPartialXmlNode(appendable);
                    if (this.binaryContentBuffer.length() > 0) {
                        appendable.append(this.binaryContentBuffer);
                        this.binaryContentBuffer.delete(0, this.binaryContentBuffer.length());
                    }
                    if (this.stringContentBuffer.length() > 0) {
                        appendable.append(this.stringContentBuffer);
                        this.stringContentBuffer.delete(0, this.stringContentBuffer.length());
                    }
                    if (this.oseeCommentBuffer.length() > 0) {
                        appendable.append(this.oseeCommentBuffer);
                        this.oseeCommentBuffer.delete(0, this.oseeCommentBuffer.length());
                    }
                    if (this.branchNameBuffer.length() > 0) {
                        appendable.append(this.branchNameBuffer);
                        this.branchNameBuffer.delete(0, this.branchNameBuffer.length());
                    }
                    if (this.rationaleBuffer.length() > 0) {
                        appendable.append(this.rationaleBuffer);
                        this.rationaleBuffer.delete(0, this.rationaleBuffer.length());
                    }
                    ExportImportXml.closeXmlNode(appendable, "entry");
                } else {
                    ExportImportXml.closePartialXmlNode(appendable);
                }
            }
        }
        catch (Exception ex) {
            throw new OseeCoreException((Throwable)ex, "Failure during %s processData", new Object[]{((Object)((Object)this)).getClass().getSimpleName()});
        }
    }

    private Timestamp asTimestamp(Object value) {
        Timestamp toReturn = null;
        if (value instanceof Timestamp) {
            toReturn = (Timestamp)value;
        } else if (value != null) {
            try {
                Class<?> clazz = value.getClass();
                Method method = clazz.getMethod("timestampValue", new Class[0]);
                Object object = method.invoke(value, new Object[0]);
                if (object instanceof Timestamp) {
                    toReturn = (Timestamp)object;
                }
            }
            catch (NoSuchMethodException noSuchMethodException) {
            }
            catch (Exception ex) {
                this.getLogger().warn((Throwable)ex, "Error converting [%s] to timestamp", new Object[]{value});
            }
        }
        return toReturn;
    }

    private void handleBinaryContent(Appendable appendable, Object value) throws IOException {
        String uriData = (String)value;
        if (Strings.isValid((String)uriData)) {
            uriData = this.exportBinaryDataTo(this.getWriteLocation(), uriData);
            ExportImportXml.openPartialXmlNode(appendable, "binaryContent");
            ExportImportXml.addXmlAttribute(appendable, "location", uriData);
            ExportImportXml.closePartialXmlNode(appendable);
        }
    }

    private void handleTypeId(Appendable appendable, Object value) throws IOException {
        long typeId = -1L;
        if (value instanceof Short) {
            Short xShort = (Short)value;
            typeId = xShort.longValue();
        } else if (value instanceof Integer) {
            typeId = ((Integer)value).longValue();
        } else if (value instanceof Long) {
            typeId = (Long)value;
        } else if (value instanceof BigInteger) {
            typeId = ((BigInteger)value).longValue();
        } else if (value instanceof BigDecimal) {
            typeId = ((BigDecimal)value).longValue();
        } else {
            throw new OseeCoreException("Undefined Type [%s]", new Object[]{value != null ? value.getClass().getSimpleName() : value});
        }
        String uuidString = String.valueOf(typeId);
        ExportImportXml.addXmlAttribute(appendable, "type_guid", uuidString);
    }

    private void handleStringContent(Appendable appendable, Object value, String tag) throws IOException {
        String stringValue = (String)value;
        if (Strings.isValid((String)stringValue)) {
            ExportImportXml.openXmlNodeNoNewline(appendable, tag);
            Xml.writeWhileHandlingCdata((Appendable)appendable, (String)stringValue);
            ExportImportXml.closeXmlNode(appendable, tag);
        }
    }
}

