/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.mim.types;

import com.fasterxml.jackson.annotation.JsonIgnore;
import org.eclipse.osee.framework.core.data.ApplicabilityToken;
import org.eclipse.osee.framework.core.data.ArtifactReadable;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.enums.CoreAttributeTypes;
import org.eclipse.osee.mim.types.ConnectionViewData;
import org.eclipse.osee.mim.types.ConnectionViewType;
import org.eclipse.osee.mim.types.InterfaceConnection;
import org.eclipse.osee.mim.types.PLGenericDBObject;

public class ConnectionView
extends PLGenericDBObject {
    @JsonIgnore
    private String Name;
    private String Description;
    private String source = "";
    private String target = "";
    private String label = "";
    private ConnectionViewData data;

    public ConnectionView(ArtifactToken art) {
        this((ArtifactReadable)art);
    }

    public ConnectionView(InterfaceConnection connection) {
        this(connection.getId(), connection.getName(), connection.getDescription(), connection.getTransportType());
        this.setSource(connection.getPrimaryNode().toString());
        this.setTarget(connection.getSecondaryNode().toString());
        this.setApplicability(connection.getApplicability());
    }

    public ConnectionView(ArtifactReadable art) {
        this();
        this.setId(art.getId());
        this.setName(art.getName());
        this.setData(new ConnectionViewData(art));
        this.setDescription((String)art.getSoleAttributeValue((AttributeTypeToken)CoreAttributeTypes.Description, (Object)""));
        this.setApplicability(!art.getApplicabilityToken().getId().equals(-1L) ? art.getApplicabilityToken() : ApplicabilityToken.SENTINEL);
    }

    public ConnectionView(Long id, String name, String description, String transportType) {
        this(id, name);
        this.setLabel(name);
        this.setData(new ConnectionViewData(id, name));
        this.setDescription(description);
        this.setType(ConnectionViewType.valueOf(transportType));
    }

    public ConnectionView(Long id, String name) {
        super(id, name);
    }

    public ConnectionView() {
    }

    @JsonIgnore
    public String getDescription() {
        return this.data.getDescription();
    }

    public void setDescription(String description) {
        this.data.setDescription(description);
    }

    @JsonIgnore
    public String getName() {
        return super.getName();
    }

    public void setName(String name) {
        super.setName(name);
        this.setLabel(name);
    }

    public String getSource() {
        return this.source;
    }

    public void setSource(String source) {
        this.source = source;
    }

    public String getTarget() {
        return this.target;
    }

    public void setTarget(String target) {
        this.target = target;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public ConnectionViewData getData() {
        return this.data;
    }

    public void setData(ConnectionViewData data) {
        this.data = data;
    }

    @JsonIgnore
    public ConnectionViewType getType() {
        return this.data.getTransportType();
    }

    @JsonIgnore
    public void setType(ConnectionViewType type) {
        this.data.setTransportType(type);
    }

    @JsonIgnore
    public boolean getIsDashed() {
        return this.data.isDashed();
    }

    @JsonIgnore
    public void setIsDashed(boolean isDashed) {
        this.data.setDashed(isDashed);
    }

    @JsonIgnore
    public ApplicabilityToken getApplicability() {
        return this.data.getApplicability();
    }

    public void setApplicability(ApplicabilityToken applicabilityToken) {
        this.data.setApplicability(applicabilityToken);
    }
}

