/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.mim.internal;

import java.util.Arrays;
import java.util.Collection;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.mim.InterfaceStructureApi;
import org.eclipse.osee.mim.InterfaceStructureFilterEndpoint;
import org.eclipse.osee.mim.types.InterfaceStructureToken;

public class InterfaceStructureFilterEndpointImpl
implements InterfaceStructureFilterEndpoint {
    private final BranchId branch;
    private final ArtifactId messageId;
    private final ArtifactId subMessageId;
    private final InterfaceStructureApi interfaceStructureApi;

    public InterfaceStructureFilterEndpointImpl(BranchId branch, ArtifactId messageId, ArtifactId subMessageId, InterfaceStructureApi interfaceStructureApi) {
        this.branch = branch;
        this.messageId = messageId;
        this.subMessageId = subMessageId;
        this.interfaceStructureApi = interfaceStructureApi;
    }

    @Override
    public Collection<InterfaceStructureToken> getStructures() {
        if (this.subMessageId.getId() == 0L) {
            return Arrays.asList(this.interfaceStructureApi.getMessageHeaderStructure(this.branch, this.messageId));
        }
        return this.interfaceStructureApi.getAllRelated(this.branch, this.subMessageId);
    }

    @Override
    public Collection<InterfaceStructureToken> getStructures(String filter) {
        if (this.subMessageId.getId() == 0L) {
            return Arrays.asList(this.interfaceStructureApi.getMessageHeaderStructure(this.branch, this.messageId));
        }
        return this.interfaceStructureApi.getAllRelatedAndFilter(this.branch, this.subMessageId, filter);
    }
}

