/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.define.rest.synchronization.reqifsynchronizationartifactbuilder;

import java.util.Map;
import java.util.Objects;
import org.eclipse.osee.define.rest.synchronization.IdentifierType;
import org.eclipse.osee.define.rest.synchronization.IdentifierTypeGroup;
import org.eclipse.osee.define.rest.synchronization.UnexpectedGroveThingTypeException;
import org.eclipse.osee.define.rest.synchronization.forest.GroveThing;
import org.eclipse.osee.define.rest.synchronization.reqifsynchronizationartifactbuilder.ReqIFSynchronizationArtifactBuilder;
import org.eclipse.osee.framework.core.data.ArtifactReadable;
import org.eclipse.osee.framework.jdk.core.util.EnumSupplierMap;
import org.eclipse.rmf.reqif10.ReqIF10Factory;
import org.eclipse.rmf.reqif10.SpecElementWithAttributes;

public class SpecElementWithAttributesConverter {
    private static EnumSupplierMap<IdentifierType, SpecElementWithAttributes> specElementWithAttributesSupplierMap;
    private static Map<IdentifierType, String> descriptionMap;

    static {
        Map.Entry[] entryArray = new Map.Entry[4];
        entryArray[0] = Map.entry(IdentifierType.SPECIFICATION, () -> ((ReqIF10Factory)ReqIF10Factory.eINSTANCE).createSpecification());
        entryArray[1] = Map.entry(IdentifierType.SPECTER_SPEC_OBJECT, () -> ((ReqIF10Factory)ReqIF10Factory.eINSTANCE).createSpecObject());
        entryArray[2] = Map.entry(IdentifierType.SPEC_OBJECT, () -> ((ReqIF10Factory)ReqIF10Factory.eINSTANCE).createSpecObject());
        entryArray[3] = Map.entry(IdentifierType.SPEC_RELATION, () -> ((ReqIF10Factory)ReqIF10Factory.eINSTANCE).createSpecRelation());
        specElementWithAttributesSupplierMap = EnumSupplierMap.ofEntries(IdentifierType.class, (Map.Entry[])entryArray);
        descriptionMap = Map.ofEntries(Map.entry(IdentifierType.SPECIFICATION, " Specification"), Map.entry(IdentifierType.SPECTER_SPEC_OBJECT, " Specter Spec Object"), Map.entry(IdentifierType.SPEC_OBJECT, " Spec Object"), Map.entry(IdentifierType.SPEC_RELATION, " Spec Relation"));
    }

    private SpecElementWithAttributesConverter() {
    }

    static void convert(GroveThing groveThing) {
        assert (Objects.nonNull(groveThing) && groveThing.isInGroup(IdentifierTypeGroup.OBJECT)) : UnexpectedGroveThingTypeException.buildMessage(groveThing, IdentifierTypeGroup.OBJECT);
        ArtifactReadable nativeArtifactReadable = (ArtifactReadable)groveThing.getNativeThing();
        SpecElementWithAttributes reqifSpecElementWithAttributes = (SpecElementWithAttributes)specElementWithAttributesSupplierMap.get((Enum)groveThing.getIdentifier().getType());
        String description = new StringBuilder(512).append("OSEE ").append(nativeArtifactReadable.getName()).append(descriptionMap.get(groveThing.getIdentifier().getType())).toString();
        reqifSpecElementWithAttributes.setDesc(description);
        reqifSpecElementWithAttributes.setIdentifier(groveThing.getIdentifier().toString());
        reqifSpecElementWithAttributes.setLastChange(ReqIFSynchronizationArtifactBuilder.lastChangeEpoch);
        reqifSpecElementWithAttributes.setLongName(nativeArtifactReadable.getName());
        groveThing.setForeignThing(reqifSpecElementWithAttributes);
    }
}

