/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.define.rest.synchronization.forest.morphology;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.eclipse.osee.define.rest.synchronization.IdentifierType;
import org.eclipse.osee.define.rest.synchronization.forest.Grove;
import org.eclipse.osee.define.rest.synchronization.forest.GroveThing;
import org.eclipse.osee.define.rest.synchronization.forest.GroveThingNotFoundWithNativeKeysException;
import org.eclipse.osee.define.rest.synchronization.forest.morphology.DuplicateGroveEntryException;
import org.eclipse.osee.define.rest.synchronization.forest.morphology.DuplicateStoreEntryException;
import org.eclipse.osee.define.rest.synchronization.forest.morphology.Store;
import org.eclipse.osee.define.rest.synchronization.forest.morphology.StoreRank3;
import org.eclipse.osee.define.rest.synchronization.forest.morphology.StoreRankN;
import org.eclipse.osee.define.rest.synchronization.forest.morphology.StoreType;
import org.eclipse.osee.framework.jdk.core.util.IndentedString;

public class AbstractMapGrove
implements Grove {
    protected final IdentifierType identifierType;
    protected final Store nativeStore;
    protected final Store primaryStore;

    public AbstractMapGrove(IdentifierType identifierType, boolean groveThingProvidesNativeKeys, Predicate<Object>[] primaryKeyValidators, Predicate<Object>[] nativeKeyValidators) {
        this.identifierType = identifierType;
        this.primaryStore = this.createPrimaryStorage(identifierType == IdentifierType.SPEC_OBJECT ? StoreType.PRIMARY_HIERARCHY : StoreType.PRIMARY, primaryKeyValidators);
        this.nativeStore = groveThingProvidesNativeKeys ? this.createNativeStorage(nativeKeyValidators) : null;
    }

    @Override
    public GroveThing add(GroveThing groveThing) {
        try {
            this.primaryStore.add(groveThing);
            if (Objects.nonNull(this.nativeStore)) {
                this.nativeStore.add(groveThing);
            }
            return groveThing;
        }
        catch (DuplicateStoreEntryException e) {
            throw new DuplicateGroveEntryException(this, (Throwable)e);
        }
    }

    @Override
    public boolean containsByPrimaryKeys(IdentifierType.Identifier ... primaryKeys) {
        return this.primaryStore.contains(primaryKeys);
    }

    @Override
    public boolean containsByNativeKeys(Object ... nativeKeys) {
        return Objects.nonNull(this.nativeStore) ? this.nativeStore.contains(nativeKeys) : false;
    }

    private Store createNativeStorage(Predicate<Object>[] keyValidators) {
        int keyCount = Objects.nonNull(keyValidators) ? keyValidators.length : 0;
        return keyCount > 0 ? new StoreRankN(StoreType.NATIVE, keyCount, keyValidators) : null;
    }

    private Store createPrimaryStorage(StoreType storeType, Predicate<Object>[] keyValidators) {
        int keyCount = Objects.nonNull(keyValidators) ? keyValidators.length : 0;
        return storeType == StoreType.PRIMARY_HIERARCHY ? new StoreRank3(StoreType.PRIMARY_HIERARCHY, keyValidators[0], keyValidators[1], keyValidators[2]) : new StoreRankN(StoreType.PRIMARY, keyCount, keyValidators);
    }

    @Override
    public Optional<GroveThing> getByPrimaryKeys(IdentifierType.Identifier ... primaryKeys) {
        return this.primaryStore.get(primaryKeys);
    }

    @Override
    public Optional<GroveThing> getByNativeKeys(Object ... nativeKeys) {
        return this.nativeStore.get(nativeKeys);
    }

    @Override
    public GroveThing getByNativeKeysOrElseThrow(Object ... nativeKeys) {
        return this.nativeStore.get(nativeKeys).orElseThrow(() -> new GroveThingNotFoundWithNativeKeysException(this, nativeKeys));
    }

    @Override
    public IdentifierType getType() {
        assert (this.identifierType != null);
        return this.identifierType;
    }

    @Override
    public int nativeRank() {
        return this.nativeStore.rank();
    }

    @Override
    public int rank() {
        return this.primaryStore.rank();
    }

    @Override
    public Stream<GroveThing> stream(IdentifierType.Identifier ... primaryKeys) {
        return this.primaryStore.stream(primaryKeys);
    }

    @Override
    public Stream<IdentifierType.Identifier> streamIdentifiersDeep(IdentifierType.Identifier ... primaryKeys) {
        return this.primaryStore.streamKeysAtAndBelow(primaryKeys);
    }

    @Override
    public Stream<IdentifierType.Identifier> streamIdentifiersShallow(IdentifierType.Identifier ... primaryKeys) {
        return this.primaryStore.streamKeysAt(primaryKeys);
    }

    @Override
    public Stream<IdentifierType.Identifier[]> streamKeySets(IdentifierType.Identifier ... primaryKeys) {
        return this.primaryStore.streamKeySets(primaryKeys);
    }

    public StringBuilder toMessage(int indent, StringBuilder message) {
        StringBuilder outMessage = message != null ? message : new StringBuilder(1024);
        String indent0 = IndentedString.indentString((int)(indent + 0));
        String indent1 = IndentedString.indentString((int)(indent + 1));
        outMessage.append(indent0).append("Grove:").append("\n").append(indent1).append("Type:          ").append(this.getType()).append("\n").append(indent1).append("Primary Store: ").append("\n");
        this.primaryStore.toMessage(indent + 2, outMessage);
        outMessage.append(indent1).append("Native Store:  ").append("\n");
        this.nativeStore.toMessage(indent + 2, outMessage);
        return outMessage;
    }

    public String toString() {
        return this.toMessage(0, null).toString();
    }
}

