/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.define.rest.synchronization;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.eclipse.osee.define.rest.synchronization.CommonObjectTypeContainerMap;
import org.eclipse.osee.define.rest.synchronization.IdentifierType;
import org.eclipse.osee.define.rest.synchronization.IdentifierTypeGroup;
import org.eclipse.osee.define.rest.synchronization.IsSynchronizationArtifactBuilder;
import org.eclipse.osee.define.rest.synchronization.RootList;
import org.eclipse.osee.define.rest.synchronization.SynchronizationArtifactBuilder;
import org.eclipse.osee.define.rest.synchronization.UnknownSynchronizationArtifactTypeException;
import org.eclipse.osee.define.rest.synchronization.forest.Forest;
import org.eclipse.osee.define.rest.synchronization.forest.Grove;
import org.eclipse.osee.define.rest.synchronization.forest.GroveThing;
import org.eclipse.osee.define.rest.synchronization.forest.denizens.ArtifactTypeTokens;
import org.eclipse.osee.define.rest.synchronization.forest.denizens.NativeDataTypeKey;
import org.eclipse.osee.define.rest.synchronization.forest.denizens.NativeDataTypeKeyFactory;
import org.eclipse.osee.define.rest.synchronization.forest.denizens.NativeHeader;
import org.eclipse.osee.define.rest.synchronization.forest.denizens.SpecRelationArtifactReadable;
import org.eclipse.osee.define.rest.synchronization.forest.denizens.SpecterSpecObjectArtifactReadable;
import org.eclipse.osee.define.rest.synchronization.forest.denizens.UnknownAttributeTypeTokenException;
import org.eclipse.osee.framework.core.OrcsTokenService;
import org.eclipse.osee.framework.core.data.ArtifactReadable;
import org.eclipse.osee.framework.core.data.ArtifactTypeToken;
import org.eclipse.osee.framework.core.data.AttributeTypeEnum;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.data.RelationTypeSide;
import org.eclipse.osee.framework.core.data.RelationTypeToken;
import org.eclipse.osee.framework.core.enums.RelationSide;
import org.eclipse.osee.framework.core.exception.AttributeDoesNotExist;
import org.eclipse.osee.framework.core.exception.MultipleAttributesExist;
import org.eclipse.osee.framework.jdk.core.type.Id;
import org.eclipse.osee.framework.jdk.core.type.NamedId;
import org.eclipse.osee.framework.jdk.core.util.IndentedString;
import org.eclipse.osee.framework.jdk.core.util.ToMessage;
import org.eclipse.osee.orcs.OrcsApi;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.wiring.BundleWiring;

public class SynchronizationArtifact
implements ToMessage {
    private static Map<String, Class<?>> synchronizationArtifactBuilderClassMap = new HashMap();
    private final Forest forest;
    private final OrcsApi orcsApi;
    private final CommonObjectTypeContainerMap commonObjectTypeContainerMap;
    private final RootList rootList;
    private final SynchronizationArtifactBuilder synchronizationArtifactBuilder;
    private final NativeDataTypeKeyFactory nativeDataTypeKeyFactory;

    static {
        BundleContext bundleContext = FrameworkUtil.getBundle(SynchronizationArtifact.class).getBundleContext();
        Bundle bundle = bundleContext.getBundle();
        String bundleSymbolicNamePath = bundle.getSymbolicName().replace('.', '/');
        BundleWiring bundleWiring = (BundleWiring)bundle.adapt(BundleWiring.class);
        ClassLoader classLoader = bundleWiring.getClassLoader();
        Collection resources = bundleWiring.listResources(bundleSymbolicNamePath, "*.class", 1);
        resources.forEach(resource -> {
            try {
                String className = resource.substring(0, resource.indexOf(46)).replace('/', '.');
                Class<?> theClass = classLoader.loadClass(className);
                IsSynchronizationArtifactBuilder isSynchronizationArtifactBuilder = theClass.getAnnotation(IsSynchronizationArtifactBuilder.class);
                if (isSynchronizationArtifactBuilder != null) {
                    synchronizationArtifactBuilderClassMap.put(isSynchronizationArtifactBuilder.artifactType(), theClass);
                }
            }
            catch (Exception exception) {}
        });
    }

    private SynchronizationArtifact(RootList rootList, SynchronizationArtifactBuilder synchronizationArtifactBuilder) {
        assert (Objects.nonNull(rootList) && Objects.nonNull(rootList.getOrcsApi()) && Objects.nonNull(synchronizationArtifactBuilder));
        IdentifierType.resetIdentifierCounts();
        this.rootList = rootList;
        this.synchronizationArtifactBuilder = synchronizationArtifactBuilder;
        this.orcsApi = rootList.getOrcsApi();
        this.commonObjectTypeContainerMap = new CommonObjectTypeContainerMap();
        this.forest = new Forest();
        this.nativeDataTypeKeyFactory = new NativeDataTypeKeyFactory();
    }

    public static SynchronizationArtifact create(RootList rootList) throws UnknownSynchronizationArtifactTypeException {
        Objects.requireNonNull(rootList);
        Objects.requireNonNull(rootList.getOrcsApi());
        String synchronizationArtifactType = rootList.getSynchronizationArtifactType();
        if (!synchronizationArtifactBuilderClassMap.containsKey(synchronizationArtifactType)) {
            throw new UnknownSynchronizationArtifactTypeException(synchronizationArtifactType);
        }
        SynchronizationArtifactBuilder synchronizationArtifactBuilder = SynchronizationArtifact.getSynchronizationArtifactBuilder(synchronizationArtifactType);
        SynchronizationArtifact synchronizationArtifact = new SynchronizationArtifact(rootList, synchronizationArtifactBuilder);
        return synchronizationArtifact;
    }

    private static SynchronizationArtifactBuilder getSynchronizationArtifactBuilder(String artifactType) throws UnknownSynchronizationArtifactTypeException {
        try {
            return (SynchronizationArtifactBuilder)synchronizationArtifactBuilderClassMap.get(artifactType).getConstructor(null).newInstance(null);
        }
        catch (Exception e) {
            throw new UnknownSynchronizationArtifactTypeException(artifactType, e);
        }
    }

    public void build() {
        this.forest.getGrove(IdentifierType.HEADER).add(this.forest.createGroveThing(IdentifierType.HEADER, new GroveThing[0]).setNativeThings(new NativeHeader(1L, this.orcsApi, this.rootList)));
        this.rootList.forEach(this::processRootArtifact);
        this.processSpecObjectGroveForRelationships();
        this.processCommonObjectTypeContainerMap();
        this.processAttributeDefinitionGrove();
        this.processCommonObjectTypeGroveThings();
        this.forest.stream().forEach(grove -> this.getSynchronizationArtifactBuilder().getConverter(grove.getType()).ifPresent(converter -> grove.stream(new IdentifierType.Identifier[0]).filter(groveThing -> groveThing.getIdentifier().getType().equals(grove.getType())).forEach(converter::accept)));
        this.synchronizationArtifactBuilder.build(this);
    }

    private GroveThing createCommonObject(ArtifactReadable nativeArtifactReadable, IdentifierType identifierType, GroveThing specificationGroveThing, GroveThing parentCommonObjectGroveThing) {
        assert (identifierType.equals(IdentifierType.SPECIFICATION) && Objects.isNull(specificationGroveThing) && Objects.isNull(parentCommonObjectGroveThing) || identifierType.equals(IdentifierType.SPEC_OBJECT) && Objects.nonNull(specificationGroveThing) && Objects.nonNull(parentCommonObjectGroveThing));
        GroveThing commonObjectGroveThing = identifierType == IdentifierType.SPECIFICATION ? this.forest.createGroveThing(identifierType, new GroveThing[0]) : this.forest.createGroveThing(identifierType, specificationGroveThing, parentCommonObjectGroveThing);
        commonObjectGroveThing.setNativeThings(nativeArtifactReadable);
        commonObjectGroveThing.setLinkScalar(identifierType.getAssociatedType(), this.getOrCreateCommonObjectType(nativeArtifactReadable.getArtifactType(), identifierType.getAssociatedType()));
        return commonObjectGroveThing;
    }

    private void createRelationship(GroveThing sourceSpecObjectGroveThing, GroveThing targetSpecObjectGroveThing, RelationTypeToken nativeRelationTypeToken) {
        Grove specRelationGrove = this.getForest().getGrove(IdentifierType.SPEC_RELATION);
        GroveThing specRelationTypeGroveThing = this.getSpecRelationTypeGroveThing(nativeRelationTypeToken.getId());
        ArtifactTypeToken nativeSpecRelationTypeArtifactTypeToken = (ArtifactTypeToken)specRelationTypeGroveThing.getNativeThing();
        if (specRelationGrove.containsByNativeKeys(((ArtifactReadable)sourceSpecObjectGroveThing.getNativeThing()).getId(), ((ArtifactReadable)targetSpecObjectGroveThing.getNativeThing()).getId(), nativeSpecRelationTypeArtifactTypeToken.getId())) {
            return;
        }
        SpecRelationArtifactReadable artifact = new SpecRelationArtifactReadable(nativeSpecRelationTypeArtifactTypeToken, nativeRelationTypeToken.getSideName(RelationSide.SIDE_A), nativeRelationTypeToken.getSideName(RelationSide.SIDE_B), nativeRelationTypeToken.getMultiplicity());
        GroveThing specRelationGroveThing = this.getForest().createGroveThing(IdentifierType.SPEC_RELATION, new GroveThing[0]);
        specRelationGroveThing.setNativeThings(sourceSpecObjectGroveThing.getNativeThing(), targetSpecObjectGroveThing.getNativeThing(), artifact);
        specRelationGroveThing.setLinkScalar(IdentifierType.SPEC_RELATION_TYPE, specRelationTypeGroveThing);
        specRelationGroveThing.setLinkVectorElement(IdentifierTypeGroup.RELATABLE_OBJECT, sourceSpecObjectGroveThing);
        specRelationGroveThing.setLinkVectorElement(IdentifierTypeGroup.RELATABLE_OBJECT, targetSpecObjectGroveThing);
        specRelationGrove.add(specRelationGroveThing);
    }

    private void createRelationshipsForSide(RelationSide relationSide, GroveThing specObjectGroveThing, RelationTypeToken nativeRelationTypeToken) {
        assert (Objects.nonNull(relationSide) && Objects.nonNull(specObjectGroveThing) && Objects.nonNull(nativeRelationTypeToken));
        RelationTypeSide nativeRelationTypeSide = new RelationTypeSide(nativeRelationTypeToken, relationSide);
        Consumer<GroveThing> relationshipCreator = relationSide.equals((Object)RelationSide.SIDE_A) ? relatedSpecObjectGroveThing -> this.createRelationship(specObjectGroveThing, (GroveThing)relatedSpecObjectGroveThing, nativeRelationTypeToken) : relatedSpecObjectGroveThing -> this.createRelationship((GroveThing)relatedSpecObjectGroveThing, specObjectGroveThing, nativeRelationTypeToken);
        ((ArtifactReadable)specObjectGroveThing.getNativeThing()).getRelated(nativeRelationTypeSide).getList().stream().map(Id::getId).map(this::getSpecObjectGroveThingOrGetOrCreateSpecterSpecObjectGroveThing).forEach(relationshipCreator);
    }

    public void deserialize(InputStream inputStream) {
        this.synchronizationArtifactBuilder.deserialize(inputStream);
    }

    public Forest getForest() {
        return this.forest;
    }

    private GroveThing getOrCreateCommonObjectType(ArtifactTypeToken nativeArtifactTypeToken, IdentifierType identifierType) {
        return this.commonObjectTypeContainerMap.get(nativeArtifactTypeToken, identifierType).orElseGet(() -> {
            GroveThing newCommonObjectTypeGroveThing = this.forest.createGroveThing(identifierType, new GroveThing[0]);
            newCommonObjectTypeGroveThing.setNativeThings(nativeArtifactTypeToken);
            this.forest.getGrove(identifierType).add(newCommonObjectTypeGroveThing);
            this.commonObjectTypeContainerMap.put(newCommonObjectTypeGroveThing);
            return newCommonObjectTypeGroveThing;
        });
    }

    private GroveThing getOrCreateSpecterSpecObjectGroveThing(Long specterId, Supplier<String> specterNameSupplier) {
        OrcsTokenService orcsTokenService = this.orcsApi.tokenService();
        return this.getForest().getGrove(IdentifierType.SPECTER_SPEC_OBJECT).getByNativeKeys(specterId).orElseGet(() -> {
            GroveThing specterSpecObjectGroveThing = this.getForest().createGroveThing(IdentifierType.SPECTER_SPEC_OBJECT, new GroveThing[0]);
            specterSpecObjectGroveThing.setNativeThings(new SpecterSpecObjectArtifactReadable(ArtifactTypeTokens.createSpecterSpecObjectArtifactTypeToken(orcsTokenService), specterId, (String)specterNameSupplier.get()));
            this.getForest().getGrove(IdentifierType.SPECTER_SPEC_OBJECT).add(specterSpecObjectGroveThing);
            specterSpecObjectGroveThing.setLinkScalar(IdentifierType.SPEC_OBJECT_TYPE, this.getOrCreateCommonObjectType(ArtifactTypeTokens.createSpecterSpecObjectArtifactTypeToken(orcsTokenService), IdentifierType.SPEC_OBJECT_TYPE));
            return specterSpecObjectGroveThing;
        });
    }

    private GroveThing getSpecObjectGroveThingOrGetOrCreateSpecterSpecObjectGroveThing(Object nativeKey) {
        return this.getForest().getGrove(IdentifierType.SPEC_OBJECT).getByNativeKeys(nativeKey).map(commonObject -> {
            if (commonObject.isType(IdentifierType.SPECIFICATION)) {
                Long specterId = ((NamedId)commonObject.getNativeThing()).getId();
                Supplier<String> specterNameSupplier = () -> new StringBuilder(512).append("Specter Spec Object For Specification: ").append(((NamedId)commonObject.getNativeThing()).getName()).toString();
                return this.getOrCreateSpecterSpecObjectGroveThing(specterId, specterNameSupplier);
            }
            return commonObject;
        }).orElseGet(() -> {
            Long specterId = (Long)nativeKey;
            Supplier<String> specterNameSupplier = () -> ((Long)nativeKey).toString();
            return this.getOrCreateSpecterSpecObjectGroveThing(specterId, specterNameSupplier);
        });
    }

    private GroveThing getSpecRelationTypeGroveThing(Object nativeKey) {
        return this.getForest().getGrove(IdentifierType.SPEC_RELATION_TYPE).getByNativeKeysOrElseThrow(nativeKey);
    }

    SynchronizationArtifactBuilder getSynchronizationArtifactBuilder() {
        return this.synchronizationArtifactBuilder;
    }

    private void processArtifactReadable(ArtifactReadable artifactReadable, GroveThing specificationGroveThing, GroveThing parentCommonObjectGroveThing) {
        Grove specRelationTypeGrove = this.getForest().getGrove(IdentifierType.SPEC_RELATION_TYPE);
        GroveThing specObjectGroveThing = this.createCommonObject(artifactReadable, IdentifierType.SPEC_OBJECT, specificationGroveThing, parentCommonObjectGroveThing);
        this.getForest().getGrove(IdentifierType.SPEC_OBJECT).add(specObjectGroveThing);
        artifactReadable.getExistingRelationTypes().stream().filter(nativeRelationTypeToken -> !specRelationTypeGrove.containsByNativeKeys(nativeRelationTypeToken.getId())).forEach(nativeRelationTypeToken -> {
            GroveThing groveThing = this.getOrCreateCommonObjectType(ArtifactTypeTokens.createSpecRelationTypeArtifactTypeToken(nativeRelationTypeToken), IdentifierType.SPEC_RELATION_TYPE);
        });
        artifactReadable.getChildren().forEach(childArtifactReadable -> this.processArtifactReadable((ArtifactReadable)childArtifactReadable, specificationGroveThing, specObjectGroveThing));
    }

    private void processAttributeDefinitionGrove() {
        Grove attributeDefinitionGrove = this.forest.getGrove(IdentifierType.ATTRIBUTE_DEFINITION);
        Grove dataTypeDefinitionGrove = this.forest.getGrove(IdentifierType.DATA_TYPE_DEFINITION);
        attributeDefinitionGrove.stream(new IdentifierType.Identifier[0]).forEach(attributeDefinitionGroveThing -> {
            AttributeTypeToken attributeTypeToken = (AttributeTypeToken)attributeDefinitionGroveThing.getNativeThing();
            NativeDataTypeKey nativeDataTypeKey = this.nativeDataTypeKeyFactory.createOrGetKey(attributeTypeToken);
            GroveThing dataTypeDefinitionGroveThing = dataTypeDefinitionGrove.getByNativeKeys(nativeDataTypeKey).orElseGet(() -> {
                GroveThing newDataTypeDefinitionGroveThing = this.forest.createGroveThing(IdentifierType.DATA_TYPE_DEFINITION, new GroveThing[0]).setNativeThings(nativeDataTypeKey);
                if (attributeTypeToken.isEnumerated()) {
                    this.processEnumeratedDataTypeDefinition(newDataTypeDefinitionGroveThing, attributeTypeToken);
                }
                return dataTypeDefinitionGrove.add(newDataTypeDefinitionGroveThing);
            });
            attributeDefinitionGroveThing.setLinkScalar(IdentifierType.DATA_TYPE_DEFINITION, dataTypeDefinitionGroveThing);
        });
    }

    private void processCommonObjectTypeContainerMap() {
        Grove attributeDefinitionGrove = this.forest.getGrove(IdentifierType.ATTRIBUTE_DEFINITION);
        this.commonObjectTypeContainerMap.stream().forEach(commonObjectTypeGroveThing -> {
            ArtifactTypeToken artifactTypeToken = (ArtifactTypeToken)commonObjectTypeGroveThing.getNativeThing();
            artifactTypeToken.getValidAttributeTypes().forEach(attributeTypeToken -> {
                GroveThing attributeDefinitionGroveThing = this.getForest().createGroveThing(IdentifierType.ATTRIBUTE_DEFINITION, (GroveThing)commonObjectTypeGroveThing);
                attributeDefinitionGroveThing.setNativeThings(attributeTypeToken);
                commonObjectTypeGroveThing.setLinkVectorElement(IdentifierType.ATTRIBUTE_DEFINITION, attributeDefinitionGroveThing);
                attributeDefinitionGrove.add(attributeDefinitionGroveThing);
            });
        });
    }

    private void processEnumeratedDataTypeDefinition(GroveThing dataTypeDefinitionGroveThing, AttributeTypeToken attributeTypeToken) {
        assert (attributeTypeToken.isEnumerated());
        Grove enumValueGrove = this.forest.getGrove(IdentifierType.ENUM_VALUE);
        attributeTypeToken.toEnum().getEnumValues().forEach(enumToken -> dataTypeDefinitionGroveThing.setLinkVectorElement(IdentifierType.ENUM_VALUE, enumValueGrove.add(this.forest.createGroveThing(IdentifierType.ENUM_VALUE, new GroveThing[0]).setNativeThings(attributeTypeToken, enumToken))));
    }

    private void processRootArtifact(ArtifactReadable rootArtifactReadable) {
        GroveThing specificationGroveThing = this.createCommonObject(rootArtifactReadable, IdentifierType.SPECIFICATION, null, null);
        this.getForest().getGrove(IdentifierType.SPECIFICATION).add(specificationGroveThing);
        this.getForest().getGrove(IdentifierType.SPEC_OBJECT).add(specificationGroveThing);
        rootArtifactReadable.getChildren().forEach(childArtifactReadable -> this.processArtifactReadable((ArtifactReadable)childArtifactReadable, specificationGroveThing, specificationGroveThing));
    }

    private void processCommonObjectTypeGroveThings() {
        Grove attributeValueGrove = this.forest.getGrove(IdentifierType.ATTRIBUTE_VALUE);
        Grove enumValueGrove = this.forest.getGrove(IdentifierType.ENUM_VALUE);
        Arrays.stream(new IdentifierType[]{IdentifierType.SPEC_OBJECT, IdentifierType.SPEC_RELATION, IdentifierType.SPECTER_SPEC_OBJECT}).map(this.getForest()::getGrove).flatMap(grove -> grove.stream(new IdentifierType.Identifier[0])).forEach(groveThing -> {
            ArtifactReadable nativeArtifactReadable = (ArtifactReadable)groveThing.getNativeThing();
            groveThing.getLinkScalar(groveThing.getIdentifier().getType().getAssociatedType()).ifPresentOrElse(commonObjectTypeGroveThing -> commonObjectTypeGroveThing.streamLinks(IdentifierType.ATTRIBUTE_DEFINITION).forEach(attributeDefinitionGroveThing -> {
                AttributeTypeToken nativeAttributeTypeToken = (AttributeTypeToken)attributeDefinitionGroveThing.getNativeThing();
                GroveThing attributeValueGroveThing = this.forest.createGroveThing(IdentifierType.ATTRIBUTE_VALUE, (GroveThing)groveThing);
                attributeValueGroveThing.setLinkScalar(IdentifierType.ATTRIBUTE_DEFINITION, (GroveThing)attributeDefinitionGroveThing);
                try {
                    if (((NativeDataTypeKey)attributeDefinitionGroveThing.getLinkScalar(IdentifierType.DATA_TYPE_DEFINITION).get().getNativeThing()).isEnumerated()) {
                        List nativeAttributeValueList = nativeArtifactReadable.getAttributeValues(nativeAttributeTypeToken);
                        ArrayList enumValueGroveThingList = new ArrayList(nativeAttributeValueList.size());
                        AttributeTypeEnum nativeAttributeTypeEnum = nativeAttributeTypeToken.toEnum();
                        nativeAttributeValueList.forEach(oseeAttributeValueEnumerationMemberString -> {
                            Long ordinal = nativeAttributeTypeEnum.getEnumOrdinal((String)oseeAttributeValueEnumerationMemberString);
                            Optional<GroveThing> enumValueGroveThing = enumValueGrove.getByNativeKeys(nativeAttributeTypeToken.getId(), ordinal);
                            enumValueGroveThingList.add(enumValueGroveThing.get());
                        });
                        attributeValueGroveThing.setNativeThings(enumValueGroveThingList);
                    } else {
                        Object nativeAttributeValue = nativeArtifactReadable.getSoleAttributeValue(nativeAttributeTypeToken);
                        attributeValueGroveThing.setNativeThings(nativeAttributeValue);
                    }
                    attributeValueGrove.add(attributeValueGroveThing);
                }
                catch (UnknownAttributeTypeTokenException uatte) {
                    throw uatte;
                }
                catch (MultipleAttributesExist multipleAttributesExist) {
                }
                catch (AttributeDoesNotExist attributeDoesNotExist) {
                }
                catch (Exception e) {
                    throw new RuntimeException("\nUnexpected exception accessing the attribute values of an ArtifactReadable.\n", e);
                }
            }), () -> {
                StringBuilder message = new StringBuilder(1024);
                message.append("\n").append("CommonObjectGroveThing does not have expected link to a CommonObjectTypeGroveThing.").append("\n").append("   Identifier: ").append(groveThing.getIdentifier()).append("\n");
                groveThing.toMessage(1, message);
                throw new RuntimeException(message.toString());
            });
        });
    }

    private void processSpecObjectGroveForRelationships() {
        this.getForest().getGrove(IdentifierType.SPEC_OBJECT).stream(new IdentifierType.Identifier[0]).filter(groveThing -> groveThing.isType(IdentifierType.SPEC_OBJECT)).forEach(specObjectGroveThing -> ((ArtifactReadable)specObjectGroveThing.getNativeThing()).getExistingRelationTypes().forEach(nativeRelationTypeToken -> {
            this.createRelationshipsForSide(RelationSide.SIDE_A, (GroveThing)specObjectGroveThing, (RelationTypeToken)nativeRelationTypeToken);
            this.createRelationshipsForSide(RelationSide.SIDE_B, (GroveThing)specObjectGroveThing, (RelationTypeToken)nativeRelationTypeToken);
        }));
    }

    public InputStream serialize() {
        return this.synchronizationArtifactBuilder.serialize();
    }

    public StringBuilder toMessage(int indent, StringBuilder message) {
        StringBuilder outMessage = message != null ? message : new StringBuilder(1024);
        String indent0 = IndentedString.indentString((int)0);
        outMessage.append(indent0).append("Root List:").append("\n");
        this.rootList.toMessage(indent + 1, outMessage);
        return outMessage;
    }

    public String toString() {
        return this.toMessage(0, null).toString();
    }
}

