/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.define.rest.publishing;

import java.util.LinkedList;
import java.util.List;
import org.eclipse.osee.ats.api.workflow.IAtsTeamWorkflow;
import org.eclipse.osee.define.api.PublishingArtifactError;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.ArtifactTypeToken;
import org.eclipse.osee.framework.core.util.WordMLWriter;

public class PublishingErrorLog {
    private final List<PublishingArtifactError> publishingErrors = new LinkedList<PublishingArtifactError>();

    public void clear() {
        this.publishingErrors.clear();
    }

    public void error(ArtifactToken artifactToken, String message) {
        this.publishingErrors.add(new PublishingArtifactError(artifactToken.getId(), artifactToken.getName(), artifactToken.getArtifactType(), message));
    }

    public void error(IAtsTeamWorkflow iAtsTeamWorkflow, String message) {
        this.publishingErrors.add(new PublishingArtifactError(iAtsTeamWorkflow.getId(), iAtsTeamWorkflow.getName(), iAtsTeamWorkflow.getArtifactType(), message));
    }

    public void error(String message) {
        this.publishingErrors.add(new PublishingArtifactError(ArtifactToken.SENTINEL.getId(), "N/A", ArtifactTypeToken.SENTINEL, message));
    }

    public void publishErrorLog(WordMLWriter wordMl) {
        if (this.publishingErrors.isEmpty()) {
            return;
        }
        wordMl.startErrorLog();
        for (PublishingArtifactError error : this.publishingErrors) {
            wordMl.addErrorRow(error.getArtId().toString(), error.getArtName(), error.getArtType().getName(), error.getErrorDescription());
        }
        wordMl.endErrorLog();
    }
}

