/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.define.rest.operations;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.osee.define.rest.operations.SearchReplaceLines;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactReadable;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.ArtifactTypeToken;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.enums.CoreArtifactTypes;
import org.eclipse.osee.framework.core.enums.CoreAttributeTypes;
import org.eclipse.osee.framework.core.enums.DeletionFlag;
import org.eclipse.osee.framework.jdk.core.result.XResultData;
import org.eclipse.osee.framework.jdk.core.type.HashCollection;
import org.eclipse.osee.framework.jdk.core.type.Pair;
import org.eclipse.osee.framework.jdk.core.util.AXml;
import org.eclipse.osee.framework.jdk.core.util.Collections;
import org.eclipse.osee.framework.jdk.core.util.Conditions;
import org.eclipse.osee.framework.jdk.core.util.ElapsedTime;
import org.eclipse.osee.framework.jdk.core.util.Lib;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.framework.jdk.core.util.xml.Xml;
import org.eclipse.osee.jdbc.JdbcClient;
import org.eclipse.osee.orcs.OrcsApi;
import org.eclipse.osee.orcs.transaction.TransactionBuilder;

public class ValidateProcFuncCalls {
    private static final List<ArtifactTypeToken> SR_METHOD_TYPES = Arrays.asList(CoreArtifactTypes.SoftwareRequirementProcedureMsWord, CoreArtifactTypes.SoftwareRequirementFunctionMsWord, CoreArtifactTypes.SoftwareRequirementDataDefinitionMsWord);
    private static final List<ArtifactTypeToken> ID_METHOD_TYPES = Arrays.asList(CoreArtifactTypes.ImplementationDetailsProcedureMsWord, CoreArtifactTypes.ImplementationDetailsFunctionMsWord, CoreArtifactTypes.ImplementationDetailsDataDefinitionMsWord);
    private static final List<ArtifactTypeToken> ALL_METHOD_TYPES = new LinkedList<ArtifactTypeToken>();
    Map<String, ArtifactToken> artNameToArtifact = new HashMap<String, ArtifactToken>(3000);
    HashCollection<ArtifactTypeToken, String> artTypeToArtUiName = new HashCollection(3000);
    HashCollection<String, ArtifactToken> linkNameToArtifact = new HashCollection(3000);
    Set<String> methodCallWordContentLinkUiNames = new HashSet<String>(3000);
    HashCollection<ArtifactTypeToken, String> artTypeToWordContentLinkUiName = new HashCollection(3000);
    Map<ArtifactTypeToken, Pattern> artTypeToPattern = new HashMap<ArtifactTypeToken, Pattern>(3000);
    Pattern uiPattern = Pattern.compile("\\{([A-Z0-9_]+?)\\}", 2);
    private final BranchId branch;
    private final JdbcClient jdbcClient;
    private final XResultData results;
    private final OrcsApi orcsApi;
    private List<Pair<String, String>> srchReplPairs;
    boolean reportOnly = true;
    private final Pattern curlBracePattern = Pattern.compile("(\\{.*?\\})");

    public ValidateProcFuncCalls(JdbcClient jdbcClient, BranchId branch, XResultData results, OrcsApi orcsApi) {
        this.jdbcClient = jdbcClient;
        this.branch = branch;
        this.results = results;
        this.orcsApi = orcsApi;
    }

    public ValidateProcFuncCalls(JdbcClient jdbcClient, BranchId branch, OrcsApi orcsApi) {
        this(jdbcClient, branch, new XResultData(false), orcsApi);
    }

    public XResultData get() {
        ElapsedTime time = new ElapsedTime("run");
        this.getReqNamesForMethodArtifacts();
        this.getMethodLinksFromWordContent();
        this.validateSoftReqMethsAreReferencedInSoftReq();
        this.validateMethodLinksInSoftReqExistInReqArtifacts();
        time.end();
        return this.results;
    }

    private void validateSoftReqMethsAreReferencedInSoftReq() {
        this.log("", new Object[0]);
        this.log("", new Object[0]);
        this.log("Errors: Software Requirement Procedure, Function, Data Definition not found in Software Requirements", new Object[0]);
        for (ArtifactTypeToken methodType : SR_METHOD_TYPES) {
            List wordContentLinkUiNames = (List)this.artTypeToWordContentLinkUiName.getValues((Object)methodType);
            List artUiNames = (List)this.artTypeToArtUiName.getValues((Object)methodType);
            HashSet<String> nameUsed = new HashSet<String>();
            for (String artUiName : artUiNames) {
                if (nameUsed.contains(artUiName)) continue;
                nameUsed.add(artUiName);
                if (wordContentLinkUiNames.contains(artUiName) || this.methodCallWordContentLinkUiNames.contains(artUiName)) continue;
                ArtifactToken art = this.artNameToArtifact.get(artUiName);
                if (art == null) {
                    this.log("Error: Can't find artifact with name [%s]", artUiName);
                    continue;
                }
                this.log("[%s] %s not found in Software Requirements", methodType.getName(), art.toStringWithId());
            }
        }
    }

    private void validateMethodLinksInSoftReqExistInReqArtifacts() {
        this.log("", new Object[0]);
        this.log("", new Object[0]);
        this.log("Errors: Software Requirement Procedure, Function, Data Definition not found in Software Requirements", new Object[0]);
        LinkedList allTypeArtNames = new LinkedList();
        for (ArtifactTypeToken methodType : SR_METHOD_TYPES) {
            List wordContentLinkUiNames = (List)this.artTypeToWordContentLinkUiName.getValues((Object)methodType);
            List artUiNames = (List)this.artTypeToArtUiName.getValues((Object)methodType);
            allTypeArtNames.addAll(artUiNames);
            HashSet<String> linkUsed = new HashSet<String>();
            for (String wordContentLinkUiName : wordContentLinkUiNames) {
                if (linkUsed.contains(wordContentLinkUiName)) continue;
                linkUsed.add(wordContentLinkUiName);
                if (artUiNames.contains(wordContentLinkUiName)) continue;
                this.log("[%s] Method Link [%s] not found as Software Requirements Artifact", methodType.getName(), wordContentLinkUiName);
            }
        }
        this.log("", new Object[0]);
        this.log("", new Object[0]);
        this.log("Errors: Call link w/o method name not found in Software Requirements", new Object[0]);
        for (String methodCallWordContentLinkUiName : this.methodCallWordContentLinkUiNames) {
            if (allTypeArtNames.contains(methodCallWordContentLinkUiName)) continue;
            this.log("Call Link [%s] not found as Software Requirements Artifact", methodCallWordContentLinkUiName);
        }
    }

    private void extractReqNamesFromArtName(ArtifactToken swArt) {
        String artName = swArt.getName();
        LinkedList<ArtifactTypeToken> TYPES = new LinkedList<ArtifactTypeToken>();
        TYPES.addAll(ALL_METHOD_TYPES);
        TYPES.add(CoreArtifactTypes.SoftwareRequirementMsWord);
        for (ArtifactTypeToken type : TYPES) {
            String uiName;
            Matcher uiMatch;
            if (!swArt.getArtifactType().equals(type) || !(uiMatch = this.uiPattern.matcher(artName)).find() || !Strings.isValid((String)(uiName = uiMatch.group(1)))) continue;
            this.artTypeToArtUiName.put((Object)type, (Object)uiName);
            this.artNameToArtifact.put(uiName, swArt);
            this.log("Artifact %s UI Name [%s]", swArt.toStringWithId(), uiName);
        }
    }

    private void extractLinksFromWordContent(String reqStr, ArtifactReadable swArt) {
        for (ArtifactTypeToken type : ALL_METHOD_TYPES) {
            Pattern linkPattern = this.artTypeToPattern.get(type);
            Matcher m = linkPattern.matcher(reqStr);
            while (m.find()) {
                String linkName = m.group(1);
                this.artTypeToWordContentLinkUiName.put((Object)type, (Object)linkName);
                this.linkNameToArtifact.put((Object)linkName, (Object)swArt);
                this.log("Content [%s] Link Match [%s] UI Name [%s]", type.getName(), m.group(), linkName);
            }
        }
        Pattern uiPattern = Pattern.compile("Call *\\{([A-Z0-9_]+?)\\}", 2);
        Matcher m = uiPattern.matcher(reqStr);
        HashSet linkUsed = new HashSet();
        while (m.find()) {
            String linkName = m.group(1);
            this.linkNameToArtifact.put((Object)linkName, (Object)swArt);
            this.methodCallWordContentLinkUiNames.add(linkName);
            if (linkUsed.contains(linkName)) continue;
            this.log("Call Content Link Match [%s] UI Name [%s]", m.group(), linkName);
        }
    }

    private void createTypeLinkPatterns() {
        for (ArtifactTypeToken type : ALL_METHOD_TYPES) {
            String typeName = "";
            if (type.getName().contains("Func")) {
                typeName = "FUNC";
            } else if (type.getName().contains("Proc")) {
                typeName = "PROC";
            } else if (type.getName().contains("Data")) {
                typeName = "DATA";
            } else if (type.getName().contains("Draw")) {
                typeName = "DRAW";
            }
            Conditions.assertNotNullOrEmpty((String)typeName, (String)("typeName can't be null for " + type.getName()), (Object[])new Object[0]);
            this.artTypeToPattern.put(type, Pattern.compile("\\{([A-Z0-9_ ]+?)\\} *" + typeName, 2));
        }
    }

    private List<Long> getSoftwareReqIds(BranchId branch) {
        LinkedList<Long> resultIds = new LinkedList<Long>();
        for (ArtifactId art : this.orcsApi.getQueryFactory().fromBranch(branch).andIsOfType(new ArtifactTypeToken[]{CoreArtifactTypes.SoftwareRequirementMsWord, CoreArtifactTypes.SoftwareRequirementFunctionMsWord, CoreArtifactTypes.SoftwareRequirementProcedureMsWord}).asArtifactIds()) {
            resultIds.add(art.getId());
        }
        return resultIds;
    }

    private void log(String message, Object ... data) {
        String errStr = String.format(message, data);
        this.results.log(errStr);
    }

    private void getMethodLinksFromWordContent() {
        List<Long> softwareReqArtIds = this.getSoftwareReqIds(this.branch);
        List subDivide = Collections.subDivide(softwareReqArtIds, (int)100);
        this.createTypeLinkPatterns();
        for (Collection ids : subDivide) {
            for (ArtifactReadable swArt : this.orcsApi.getQueryFactory().fromBranch(this.branch).andIdsL(ids).getResults().getList()) {
                try {
                    String reqXmlStr = (String)swArt.getSoleAttributeValue((AttributeTypeToken)CoreAttributeTypes.WordTemplateContent, DeletionFlag.EXCLUDE_DELETED, null);
                    if (reqXmlStr == null) continue;
                    String reqStr = AXml.removeXmlTags((String)reqXmlStr);
                    this.extractLinksFromWordContent(reqStr, swArt);
                }
                catch (Exception ex) {
                    this.results.errorf("Exception processing art %s - ex: %s", new Object[]{swArt.toStringWithId(), ex.getLocalizedMessage()});
                }
            }
        }
    }

    private void getReqNamesForMethodArtifacts() {
        ALL_METHOD_TYPES.addAll(SR_METHOD_TYPES);
        ALL_METHOD_TYPES.addAll(ID_METHOD_TYPES);
        for (ArtifactTypeToken type : ALL_METHOD_TYPES) {
            for (ArtifactToken art : this.orcsApi.getQueryFactory().fromBranch(this.branch).andIsOfType(new ArtifactTypeToken[]{type}).asArtifactTokens()) {
                this.extractReqNamesFromArtName(art);
            }
        }
    }

    public void searchAndReplace() {
        BranchId branch = BranchId.valueOf((Long)8203443705848388493L);
        TransactionBuilder tx = null;
        if (!this.reportOnly) {
            tx = this.orcsApi.getTransactionFactory().createTransaction(branch, "Fix UI names in SoftReq word content.");
        }
        String wasPath = "C:/UserData/SrsConversion/was/";
        String isPath = "C:/UserData/SrsConversion/is/";
        List<Long> softwareReqArtIds = this.getSoftwareReqIds(branch);
        List subDivide = Collections.subDivide(softwareReqArtIds, (int)100);
        this.getSrchReplStrs();
        for (Collection ids : subDivide) {
            for (ArtifactReadable swArt : this.orcsApi.getQueryFactory().fromBranch(branch).andIdsL(ids).getResults().getList()) {
                try {
                    String reqXmlStrOrig;
                    String reqXmlStr = reqXmlStrOrig = (String)swArt.getSoleAttributeValue((AttributeTypeToken)CoreAttributeTypes.WordTemplateContent, DeletionFlag.EXCLUDE_DELETED, null);
                    if (reqXmlStr == null) continue;
                    reqXmlStr = this.performSearchAndReplace(reqXmlStr);
                    if (!(reqXmlStr = this.fixXmlInUiNameAndUppercase(reqXmlStrOrig, reqXmlStr)).equals(reqXmlStrOrig)) {
                        Lib.writeStringToFile((String)reqXmlStrOrig, (File)new File(String.valueOf(wasPath) + "id" + swArt.getIdString() + ".txt"));
                        Lib.writeStringToFile((String)reqXmlStr, (File)new File(String.valueOf(isPath) + "id" + swArt.getIdString() + ".txt"));
                    }
                    if (this.reportOnly || tx == null || reqXmlStr.equals(reqXmlStrOrig)) continue;
                    tx.setSoleAttributeValue((ArtifactId)swArt, (AttributeTypeToken)CoreAttributeTypes.WordTemplateContent, (Object)reqXmlStr);
                }
                catch (Exception ex) {
                    String msg = String.format("Exception processing art %s - ex: %s", swArt.toStringWithId(), ex.getLocalizedMessage());
                    this.results.error(msg);
                }
            }
        }
        if (!this.reportOnly && tx != null) {
            tx.commit();
        }
    }

    private String performSearchAndReplace(String reqXmlStr) {
        for (Pair<String, String> srchReplStr : this.getSrchReplStrs()) {
            String srch = (String)srchReplStr.getFirst();
            String repl = (String)srchReplStr.getSecond();
            reqXmlStr = reqXmlStr.replace(srch, repl);
        }
        return reqXmlStr;
    }

    private String fixXmlInUiNameAndUppercase(String reqXmlStrOrig, String reqXmlStr) {
        Matcher m = this.curlBracePattern.matcher(reqXmlStrOrig);
        while (m.find()) {
            String name = m.group(1);
            String fixedName = Strings.xmlToText((String)name);
            fixedName = fixedName.toUpperCase();
            if (name.equals(fixedName = fixedName.replaceAll(" ", "_"))) continue;
            System.out.println(String.format("now [%s] was [%s]", fixedName, name));
            String escapeForRegex = Lib.escapeForRegex((String)name);
            reqXmlStr = reqXmlStr.replaceFirst(escapeForRegex, fixedName);
        }
        return reqXmlStr;
    }

    private List<Pair<String, String>> getSrchReplStrs() {
        if (this.srchReplPairs == null) {
            this.srchReplPairs = new ArrayList<Pair<String, String>>(3000);
            String[] searchReplaceLines = SearchReplaceLines.getSearchReplaceLines().toArray(new String[SearchReplaceLines.getSearchReplaceLines().size()]);
            int x = 0;
            while (x < SearchReplaceLines.getSearchReplaceLines().size()) {
                String repl;
                String srch = searchReplaceLines[x];
                srch = srch.replaceAll("}.*$", "}");
                if (!(srch = Xml.escape((CharSequence)srch).toString()).equals(repl = searchReplaceLines[x + 2]) && srch.startsWith("{") && srch.endsWith("}") && !repl.contains("N/A") && repl.startsWith("{") && repl.endsWith("}")) {
                    this.srchReplPairs.add((Pair<String, String>)new Pair((Object)srch, (Object)repl));
                }
                x += 3;
            }
        }
        return this.srchReplPairs;
    }
}

