/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.define.api.synchronization;

import java.util.Arrays;
import java.util.Objects;
import java.util.function.Predicate;
import org.eclipse.osee.define.api.synchronization.ImportMapping;
import org.eclipse.osee.framework.jdk.core.util.IndentedString;
import org.eclipse.osee.framework.jdk.core.util.ToMessage;

public class ImportRequest
implements ToMessage {
    private String synchronizationArtifactType;
    private ImportMapping[] importMappings;

    public ImportRequest() {
        this.synchronizationArtifactType = null;
        this.importMappings = null;
    }

    public ImportRequest(String synchronizationArtifactType, ImportMapping[] importMappings) {
        this.synchronizationArtifactType = Objects.requireNonNull(synchronizationArtifactType, "ImportRequest::new, the parameter \"synchronizationArtifactType\" is null.");
        this.importMappings = Objects.requireNonNull(importMappings, "ImportRequest::new, the parameter \"importMappings\" is null.");
    }

    public ImportMapping[] getImportMappings() {
        if (Objects.isNull(this.importMappings)) {
            StringBuilder message = new StringBuilder(1024).append("ImportRequest::getImportMappings, the member \"importMappings\" has not been set.").append("\n").append("\n");
            this.toMessage(1, message);
            throw new IllegalStateException(message.toString());
        }
        return this.importMappings;
    }

    public String getSynchronizationArtifactType() {
        if (Objects.isNull(this.synchronizationArtifactType)) {
            StringBuilder message = new StringBuilder(1024).append("ImportRequest::getSynchronizationArtifactType, the member \"synchronizationArtifactType\" has not been set.").append("\n").append("\n");
            this.toMessage(1, message);
            throw new IllegalStateException(message.toString());
        }
        return this.synchronizationArtifactType;
    }

    public boolean isValid() {
        return Objects.nonNull(this.synchronizationArtifactType) && Objects.nonNull(this.importMappings) && !Arrays.stream(this.importMappings).anyMatch(Predicate.not(ImportMapping::isValid));
    }

    public void setImportMappings(ImportMapping[] importMappings) {
        if (Objects.nonNull(this.importMappings)) {
            StringBuilder message = new StringBuilder(1024).append("ImportRequest::setImportMappings, the member \"importMappings\" has already been set.").append("\n").append("\n");
            this.toMessage(1, message);
            throw new IllegalStateException(message.toString());
        }
        this.importMappings = Objects.requireNonNull(importMappings, "ImportRequest::new, the parameter \"importMappings\" is null.");
    }

    public void setSynchronizationArtifactType(String synchronizationArtifactType) {
        if (Objects.nonNull(this.synchronizationArtifactType)) {
            StringBuilder message = new StringBuilder(1024).append("ImportRequest::setSynchronizationArtifactType, the member \"synchronizationArtifactType\" has already been set.").append("\n").append("\n");
            this.toMessage(1, message);
            throw new IllegalStateException(message.toString());
        }
        this.synchronizationArtifactType = Objects.requireNonNull(synchronizationArtifactType, "ImportRequest::new, the parameter \"synchronizationArtifactType\" is null.");
    }

    public StringBuilder toMessage(int indent, StringBuilder message) {
        StringBuilder outMessage = message != null ? message : new StringBuilder(1024);
        String indent0 = IndentedString.indentString((int)(indent + 0));
        String indent1 = IndentedString.indentString((int)(indent + 1));
        outMessage.append(indent0).append("ImportRequest:").append("\n").append(indent1).append("synchronizationArtifactType: ").append(Objects.nonNull(this.synchronizationArtifactType) ? this.synchronizationArtifactType : "(null)").append("\n").append(indent1).append("importMappings:              ");
        if (Objects.nonNull(this.importMappings)) {
            outMessage.append("\n");
            Arrays.stream(this.importMappings).forEach(importMapping -> {
                StringBuilder stringBuilder2 = importMapping.toMessage(2, outMessage);
            });
        } else {
            outMessage.append("(null)").append("\n");
        }
        return outMessage;
    }

    public String toString() {
        return this.toMessage(0, null).toString();
    }
}

