/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.jdk.core.text.tool;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.osee.framework.jdk.core.text.FileToBufferConvert;
import org.eclipse.osee.framework.jdk.core.text.FindResults;
import org.eclipse.osee.framework.jdk.core.text.tool.SimpleFileToBufferConvert;
import org.eclipse.osee.framework.jdk.core.text.tool.StripBlockComments;
import org.eclipse.osee.framework.jdk.core.util.Lib;

public class Find {
    private final Collection<File> files;
    private final FindResults results;
    private final FileToBufferConvert converter;
    private int precedingCount;
    private int trailingCount;
    private final Matcher[] matchers;
    private final boolean[] matcherUsed;
    private static FileToBufferConvert simpleToBuffer = new SimpleFileToBufferConvert();

    public Find(Collection<String> patterns, Collection<File> files, FileToBufferConvert converter) {
        this.files = files;
        this.converter = converter;
        this.precedingCount = 0;
        this.trailingCount = 0;
        this.results = new FindResults(patterns.size());
        this.matchers = new Matcher[patterns.size()];
        int i = 0;
        for (String pattern : patterns) {
            this.matchers[i++] = Pattern.compile(pattern).matcher("");
        }
        this.matcherUsed = new boolean[this.matchers.length];
    }

    public Find(Collection<String> patterns, Collection<File> files) {
        this(patterns, files, simpleToBuffer);
    }

    private static ArrayList<String> toList(String pattern) {
        ArrayList<String> patterns = new ArrayList<String>();
        patterns.add(pattern);
        return patterns;
    }

    public Find(String pattern, File topLevelSearchDir, String fileNamePattern) {
        this(Find.toList(pattern), Lib.recursivelyListFiles(topLevelSearchDir, Pattern.compile(fileNamePattern)));
    }

    public static void main(String[] args) throws IOException {
        if (args.length < 7) {
            System.out.println("Usage: java text.Find <pattern-list file or pattern> <search directory> <fileName pattern> <leading pad> <trailing pad> <negative: true|false> <ignoreComments: true|false>");
            return;
        }
        ArrayList<Object> patterns = null;
        if (new File(args[0]).exists()) {
            patterns = Lib.readListFromFile(args[0]);
        } else {
            patterns = new ArrayList();
            patterns.add(args[0]);
        }
        File resultFile = new File("results.txt");
        try (BufferedWriter out = new BufferedWriter(new FileWriter(resultFile));){
            List<File> files = Lib.recursivelyListFiles(new File(args[1]), Pattern.compile(args[2]));
            System.out.println("Searching " + files.size() + " files...");
            if (files.isEmpty()) {
                return;
            }
            FileToBufferConvert toBuffer = null;
            toBuffer = Boolean.valueOf(args[6]) != false ? new StripBlockComments() : simpleToBuffer;
            Find app = new Find(patterns, files, toBuffer);
            app.setRegionPadding(Integer.parseInt(args[3]), Integer.parseInt(args[4]));
            if (Boolean.valueOf(args[5]).booleanValue()) {
                app.findMeNot();
            } else {
                app.find(999999, true);
            }
            OutputStreamWriter stdOut = new OutputStreamWriter(System.out);
            stdOut.write(resultFile.getAbsolutePath());
            app.writeUnusedPatterns(stdOut);
            app.getResults().writeFindResutls(out);
        }
    }

    public void setRegionPadding(int precedingCount, int trailingCount) {
        this.precedingCount = precedingCount;
        this.trailingCount = trailingCount;
    }

    public FindResults getResults() {
        return this.results;
    }

    /*
     * Unable to fully structure code
     */
    public void find(int maxMatches, boolean maxIsPerPattern) {
        block2: for (File file : this.files) {
            buf = null;
            try {
                buf = this.converter.fileToCharSequence(file);
            }
            catch (Exception ex) {
                System.out.println("In File " + file + ": " + ex);
                continue;
            }
            numMatches = 0;
            i = 0;
            while (i < this.matchers.length) {
                this.matchers[i].reset(buf);
                if (maxIsPerPattern) {
                    numMatches = 0;
                }
                if (numMatches != maxMatches) ** GOTO lbl33
                continue block2;
lbl-1000:
                // 1 sources

                {
                    this.matcherUsed[i] = true;
                    region = null;
                    if (this.matchers[i].groupCount() == 0) {
                        if (this.precedingCount == 0 && this.trailingCount == 0) {
                            region = this.matchers[i].group();
                        } else {
                            start = this.matchers[i].start() - this.precedingCount;
                            if (start < 0) {
                                start = 0;
                            }
                            if ((end = this.matchers[i].end() + this.trailingCount) > buf.length()) {
                                end = buf.length();
                            }
                            region = buf.subSequence(start, end).toString();
                        }
                    } else {
                        region = this.matchers[i].group(1);
                    }
                    this.results.addMatch(this.matchers[i].pattern().pattern(), file, region);
lbl33:
                    // 2 sources

                    ** while (this.matchers[i].find() && numMatches++ < maxMatches)
                }
lbl34:
                // 1 sources

                ++i;
            }
        }
    }

    public void findMeNot() {
        for (File file : this.files) {
            CharSequence buf = null;
            try {
                buf = this.converter.fileToCharSequence(file);
            }
            catch (ParseException ex) {
                System.out.println(ex);
                continue;
            }
            catch (IOException ex) {
                System.out.println(ex);
                continue;
            }
            int i = 0;
            while (i < this.matchers.length) {
                this.matchers[i].reset(buf);
                if (!this.matchers[i].find()) {
                    this.matcherUsed[i] = true;
                    this.results.addMatch(this.matchers[i].pattern().pattern(), file, "findMeNot");
                }
                ++i;
            }
        }
    }

    public void writeUnusedPatterns(Writer out) throws IOException {
        boolean titleNotYetPrinted = true;
        int i = 0;
        while (i < this.matcherUsed.length) {
            if (!this.matcherUsed[i]) {
                if (titleNotYetPrinted) {
                    out.write("Patterns that were never used\n");
                    titleNotYetPrinted = false;
                }
                out.write(this.matchers[i].pattern().pattern());
                out.write(10);
            }
            ++i;
        }
        out.flush();
    }
}

