/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.core.internal.branch;

import java.util.concurrent.Callable;
import org.eclipse.osee.framework.core.executor.CancellableCallable;
import org.eclipse.osee.framework.core.executor.HasCancellation;
import org.eclipse.osee.framework.jdk.core.util.Conditions;
import org.eclipse.osee.framework.jdk.core.util.Lib;
import org.eclipse.osee.logger.Log;
import org.eclipse.osee.orcs.OrcsSession;
import org.eclipse.osee.orcs.core.ds.BranchDataStore;

public abstract class AbstractBranchCallable<T>
extends CancellableCallable<T> {
    private final Log logger;
    private final OrcsSession session;
    private final BranchDataStore branchStore;
    private Callable<?> innerWorker;

    public AbstractBranchCallable(Log logger, OrcsSession session, BranchDataStore branchStore) {
        this.logger = logger;
        this.session = session;
        this.branchStore = branchStore;
    }

    protected Log getLogger() {
        return this.logger;
    }

    protected OrcsSession getSession() {
        return this.session;
    }

    protected BranchDataStore getBranchStore() {
        return this.branchStore;
    }

    public final T call() throws Exception {
        T result;
        long startTime = 0L;
        if (this.logger.isTraceEnabled()) {
            startTime = System.currentTimeMillis();
        }
        try {
            Conditions.checkNotNull((Object)this.session, (String)"session");
            Conditions.checkNotNull((Object)this.branchStore, (String)"branchDataStore");
            result = this.innerCall();
        }
        catch (Throwable throwable) {
            if (this.logger.isTraceEnabled()) {
                this.logger.trace("Branch [%s] completed in [%s]", new Object[]{((Object)((Object)this)).getClass().getSimpleName(), Lib.getElapseString((long)startTime)});
            }
            throw throwable;
        }
        if (this.logger.isTraceEnabled()) {
            this.logger.trace("Branch [%s] completed in [%s]", new Object[]{((Object)((Object)this)).getClass().getSimpleName(), Lib.getElapseString((long)startTime)});
        }
        return result;
    }

    protected abstract T innerCall() throws Exception;

    protected <K> K callAndCheckForCancel(Callable<K> callable) throws Exception {
        this.checkForCancelled();
        this.setInnerWorker(callable);
        K result = callable.call();
        this.setInnerWorker(null);
        return result;
    }

    private synchronized void setInnerWorker(Callable<?> callable) {
        this.innerWorker = callable;
    }

    public void setCancel(boolean isCancelled) {
        super.setCancel(isCancelled);
        Callable<?> inner = this.innerWorker;
        if (inner != null && inner instanceof HasCancellation) {
            ((HasCancellation)inner).setCancel(isCancelled);
        }
    }
}

