/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.util.widgets.dialog;

import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.osee.ats.api.util.AtsImage;
import org.eclipse.osee.ats.api.version.IAtsVersion;
import org.eclipse.osee.framework.core.enums.OseeImage;
import org.eclipse.osee.framework.ui.skynet.FrameworkImage;
import org.eclipse.osee.framework.ui.swt.ImageManager;
import org.eclipse.osee.framework.ui.swt.KeyedImage;
import org.eclipse.osee.framework.ui.swt.OverlayImage;
import org.eclipse.swt.graphics.Image;

public class VersionLabelProvider
extends LabelProvider {
    private static Image releasedVersion;
    private static Image lockedVersion;
    public static final String CLEAR = "--clear--";

    public String getText(Object element) {
        if (element instanceof IAtsVersion) {
            IAtsVersion version = (IAtsVersion)element;
            String str = version.getName();
            if (version.isNextVersion()) {
                str = String.valueOf(str) + "   (Next Release)";
            } else if (version.isReleased()) {
                str = String.valueOf(str) + "   (Released)";
            }
            return str;
        }
        if (element instanceof String && element.equals(CLEAR)) {
            return (String)element;
        }
        return "Unknown element type";
    }

    public Image getImage(Object element) {
        if (element instanceof IAtsVersion) {
            IAtsVersion version = (IAtsVersion)element;
            if (version.isNextVersion()) {
                return ImageManager.getImage((KeyedImage)FrameworkImage.VERSION_NEXT);
            }
            if (version.isReleased()) {
                if (releasedVersion == null) {
                    OverlayImage overlay = new OverlayImage(ImageManager.getImage((KeyedImage)FrameworkImage.VERSION), ImageManager.getImageDescriptor((OseeImage)AtsImage.RELEASED), OverlayImage.Location.BOT_RIGHT);
                    releasedVersion = overlay.createImage();
                }
                return releasedVersion;
            }
            if (version.isLocked()) {
                if (lockedVersion == null) {
                    OverlayImage overlay = new OverlayImage(ImageManager.getImage((KeyedImage)FrameworkImage.VERSION), ImageManager.getImageDescriptor((OseeImage)AtsImage.VERSION_LOCKED), OverlayImage.Location.BOT_RIGHT);
                    lockedVersion = overlay.createImage();
                }
                return lockedVersion;
            }
            return ImageManager.getImage((KeyedImage)FrameworkImage.VERSION);
        }
        return null;
    }
}

