/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.util.widgets.dialog;

import java.util.logging.Level;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.osee.ats.api.IAtsObject;
import org.eclipse.osee.ats.api.IAtsWorkItem;
import org.eclipse.osee.ats.api.data.AtsAttributeTypes;
import org.eclipse.osee.ats.core.workflow.transition.TransitionStatusData;
import org.eclipse.osee.ats.ide.internal.Activator;
import org.eclipse.osee.ats.ide.internal.AtsApiService;
import org.eclipse.osee.ats.ide.workflow.AbstractWorkflowArtifact;
import org.eclipse.osee.framework.core.data.AttributeTypeId;
import org.eclipse.osee.framework.core.util.Result;
import org.eclipse.osee.framework.logging.OseeLevel;
import org.eclipse.osee.framework.logging.OseeLog;
import org.eclipse.osee.framework.ui.skynet.widgets.XFloat;
import org.eclipse.osee.framework.ui.skynet.widgets.XPercent;
import org.eclipse.osee.framework.ui.skynet.widgets.XRadioButton;
import org.eclipse.osee.framework.ui.swt.Displays;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;

public class TransitionStatusDialog
extends MessageDialog {
    protected Label statusLabel;
    protected XPercent percent = new XPercent("Percent Complete");
    protected XFloat hours = new XFloat("Additional Hours Spent");
    protected XRadioButton splitRadio = new XRadioButton("Split Hours Spent between Items");
    protected XRadioButton eachRadio = new XRadioButton("Apply Hours Spent to each Item");
    private Button okButton;
    private final TransitionStatusData data;

    public TransitionStatusDialog(String dialogTitle, String dialogMessage, TransitionStatusData data) {
        super(Displays.getActiveShell(), dialogTitle, null, dialogMessage, 0, new String[]{"OK", "Cancel"}, 0);
        this.data = data;
    }

    protected void createPreCustomArea(Composite parent) {
    }

    protected Control createCustomArea(Composite parent) {
        this.statusLabel = new Label(parent, 0);
        this.statusLabel.setForeground(Displays.getSystemColor((int)3));
        this.updateStatusLabel();
        if (this.data.getWorkItems().size() > 1) {
            Label label = new Label(parent, 0);
            label.setText("Mulitple objects being statused.  All objects will be set to percent\ncomplete and hours spent will be split or added into each item.");
        }
        this.createPreCustomArea(parent);
        boolean percentSet = false;
        if (this.data.isPercentRequired()) {
            this.percent.setRequiredEntry(true);
            this.percent.setToolTip("Enter total percent complete.");
            this.percent.createWidgets(parent, 2);
            try {
                Integer defaultPercent = this.data.getDefaultPercent();
                if (defaultPercent != null) {
                    this.data.setPercent(defaultPercent);
                    this.percent.set(defaultPercent.intValue());
                    percentSet = true;
                } else if (this.data.getWorkItems().size() == 1) {
                    int currentPercent = 0;
                    AbstractWorkflowArtifact awa = (AbstractWorkflowArtifact)AtsApiService.get().getQueryService().getArtifact((IAtsObject)((IAtsWorkItem)this.data.getWorkItems().iterator().next()));
                    currentPercent = !AtsApiService.get().getWorkDefinitionService().isStateWeightingEnabled(awa.getWorkDefinition()) ? ((Integer)awa.getSoleAttributeValue((AttributeTypeId)AtsAttributeTypes.PercentComplete, 0)).intValue() : awa.getStateMgr().getPercentComplete(awa.getCurrentStateName());
                    this.data.setPercent(Integer.valueOf(currentPercent));
                    this.percent.set(currentPercent);
                    percentSet = true;
                }
            }
            catch (Exception ex) {
                OseeLog.log(Activator.class, (Level)OseeLevel.SEVERE_POPUP, (Throwable)ex);
            }
            this.percent.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    IStatus status = TransitionStatusDialog.this.percent.isValid();
                    if (status.getSeverity() != 0) {
                        TransitionStatusDialog.this.data.setPercent(null);
                    } else {
                        TransitionStatusDialog.this.data.setPercent(Integer.valueOf(TransitionStatusDialog.this.percent.getInt()));
                    }
                    TransitionStatusDialog.this.updateButtons();
                    TransitionStatusDialog.this.updateStatusLabel();
                }
            });
            this.percent.getLabelWidget().addListener(4, new Listener(){

                public void handleEvent(Event event) {
                    if (event.button == 3) {
                        TransitionStatusDialog.this.data.setPercent(Integer.valueOf(99));
                        TransitionStatusDialog.this.percent.set("99");
                        TransitionStatusDialog.this.data.setAdditionalHours(Double.valueOf(1.0));
                        TransitionStatusDialog.this.hours.set("1");
                        TransitionStatusDialog.this.updateStatusLabel();
                    }
                }
            });
        }
        this.hours.setRequiredEntry(true);
        this.hours.setToolTip("Enter hours spent since last status entry.");
        this.hours.createWidgets(parent, 2);
        this.hours.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                IStatus status = TransitionStatusDialog.this.hours.isValid();
                if (status.getSeverity() != 0) {
                    TransitionStatusDialog.this.data.setAdditionalHours(null);
                } else {
                    TransitionStatusDialog.this.data.setAdditionalHours(Double.valueOf(TransitionStatusDialog.this.hours.getFloat()));
                }
                TransitionStatusDialog.this.updateButtons();
                TransitionStatusDialog.this.updateStatusLabel();
            }
        });
        if (this.data.getWorkItems().size() > 1) {
            Composite comp = new Composite(parent, 0);
            comp.setLayout((Layout)new GridLayout(2, false));
            comp.setLayoutData((Object)new GridData(768));
            this.eachRadio.createWidgets(comp, 2);
            this.eachRadio.setSelected(this.data.isApplyHoursToEachItem());
            this.eachRadio.setToolTip("Hours Spent will be added to to time spent for each object.");
            this.eachRadio.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    TransitionStatusDialog.this.data.setApplyHoursToEachItem(TransitionStatusDialog.this.eachRadio.isSelected());
                    TransitionStatusDialog.this.updateButtons();
                    TransitionStatusDialog.this.updateStatusLabel();
                }
            });
            this.splitRadio.createWidgets(comp, 2);
            this.splitRadio.setSelected(this.data.isSplitHoursBetweenItems());
            this.splitRadio.setToolTip("Hours Spent will be divided equaly by the number of objects and added to the existing hours spent for the object.");
            this.splitRadio.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    TransitionStatusDialog.this.data.setSplitHoursBetweenItems(TransitionStatusDialog.this.splitRadio.isSelected());
                    TransitionStatusDialog.this.updateButtons();
                    TransitionStatusDialog.this.updateStatusLabel();
                }
            });
        }
        this.updateStatusLabel();
        if (!this.data.isPercentRequired() || percentSet) {
            this.hours.setFocus();
        }
        return parent;
    }

    protected void updateStatusLabel() {
        IStatus result = this.isComplete();
        this.statusLabel.setText(result.isOK() ? "" : result.getMessage());
        this.statusLabel.getParent().layout();
    }

    protected Control createButtonBar(Composite parent) {
        Control c = super.createButtonBar(parent);
        this.okButton = this.getButton(0);
        this.okButton.setEnabled(false);
        return c;
    }

    protected IStatus isComplete() {
        Result result = this.data.isValid();
        if (result.isFalse()) {
            return new Status(4, "org.eclipse.osee.ats.ide", result.getText());
        }
        return Status.OK_STATUS;
    }

    private void updateButtons() {
        this.okButton.setEnabled(this.isComplete().isOK());
    }

    public TransitionStatusData getData() {
        return this.data;
    }
}

