/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.util.widgets;

import java.util.Collection;
import org.eclipse.osee.ats.api.data.AtsAttributeTypes;
import org.eclipse.osee.ats.api.team.IAtsTeamDefinition;
import org.eclipse.osee.ats.ide.internal.AtsApiService;
import org.eclipse.osee.ats.ide.util.AtsApiIde;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.enums.EnumToken;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.framework.ui.skynet.widgets.XHyperlinkLabelCmdValueSelection;
import org.eclipse.osee.framework.ui.skynet.widgets.dialog.EntryDialog;
import org.eclipse.osee.framework.ui.skynet.widgets.dialog.FilteredListEnumDialog;

public class XHyperlinkLabelValuePointsSelection
extends XHyperlinkLabelCmdValueSelection {
    String value = "";
    private final AtsApiIde atsApi;
    private final IAtsTeamDefinition teamDef;

    public XHyperlinkLabelValuePointsSelection(IAtsTeamDefinition teamDef) {
        super("Points", true);
        this.teamDef = teamDef;
        this.atsApi = AtsApiService.get();
    }

    public boolean handleSelection() {
        AttributeTypeToken pointsAttrType = this.atsApi.getAgileService().getPointsAttrType(this.teamDef);
        if (pointsAttrType == AtsAttributeTypes.PointsNumeric) {
            String entry;
            EntryDialog dialog = new EntryDialog("Enter Points", "Enter Points");
            if (dialog.open() == 0 && Strings.isNumeric((String)(entry = dialog.getEntry()))) {
                try {
                    double points = Double.valueOf(entry);
                    this.value = String.valueOf(points);
                    return true;
                }
                catch (Exception exception) {}
            }
        } else {
            EnumToken selected;
            Collection enumValues = pointsAttrType.toEnum().getEnumValues();
            FilteredListEnumDialog dialog = new FilteredListEnumDialog("Select Points", "Select Points", enumValues);
            if (dialog.open() == 0 && (selected = (EnumToken)dialog.getSelected()) != null) {
                this.value = selected.getName();
                return true;
            }
        }
        return false;
    }

    public boolean handleClear() {
        this.value = "";
        this.refresh();
        return true;
    }

    public String getCurrentValue() {
        return this.value;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }
}

