/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.util;

import java.util.ArrayList;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.osee.ats.api.IAtsConfigObject;
import org.eclipse.osee.ats.api.IAtsObject;
import org.eclipse.osee.ats.api.IAtsWorkItem;
import org.eclipse.osee.ats.api.ai.IAtsActionableItem;
import org.eclipse.osee.ats.api.config.TeamDefinition;
import org.eclipse.osee.ats.api.data.AtsArtifactTypes;
import org.eclipse.osee.ats.api.program.IAtsProgram;
import org.eclipse.osee.ats.api.team.IAtsTeamDefinition;
import org.eclipse.osee.ats.api.util.AtsImage;
import org.eclipse.osee.ats.ide.internal.AtsApiService;
import org.eclipse.osee.ats.ide.util.widgets.dialog.ProgramVersion;
import org.eclipse.osee.framework.core.data.ArtifactTypeToken;
import org.eclipse.osee.framework.core.enums.OseeImage;
import org.eclipse.osee.framework.jdk.core.util.Collections;
import org.eclipse.osee.framework.skynet.core.artifact.Artifact;
import org.eclipse.osee.framework.ui.skynet.ArtifactImageManager;
import org.eclipse.osee.framework.ui.swt.ImageManager;
import org.eclipse.osee.framework.ui.swt.KeyedImage;
import org.eclipse.search.ui.text.Match;
import org.eclipse.swt.graphics.Image;

public class AtsObjectLabelProvider
extends LabelProvider {
    private final boolean showActive;
    private final boolean showAtsId;

    public AtsObjectLabelProvider() {
        this(false);
    }

    public AtsObjectLabelProvider(boolean showActive) {
        this(showActive, false);
    }

    public AtsObjectLabelProvider(boolean showActive, boolean showAtsId) {
        this.showActive = showActive;
        this.showAtsId = showAtsId;
    }

    public Image getImage(Object element) {
        if (element instanceof Artifact) {
            return ArtifactImageManager.getImage((Artifact)AtsApiService.get().getQueryServiceIde().getArtifact(element));
        }
        if (element instanceof IAtsActionableItem) {
            return ArtifactImageManager.getImage((ArtifactTypeToken)AtsArtifactTypes.ActionableItem);
        }
        if (element instanceof IAtsTeamDefinition || element instanceof TeamDefinition) {
            return ArtifactImageManager.getImage((ArtifactTypeToken)AtsArtifactTypes.TeamDefinition);
        }
        if (element instanceof IAtsProgram) {
            return ArtifactImageManager.getImage((ArtifactTypeToken)AtsArtifactTypes.Program);
        }
        if (element instanceof ProgramVersion) {
            return ImageManager.getImage((OseeImage)AtsImage.VERSION);
        }
        if (element instanceof Match && ((Match)element).getElement() instanceof Artifact) {
            return ArtifactImageManager.getImage((Artifact)AtsApiService.get().getQueryServiceIde().getArtifact(((Match)element).getElement()));
        }
        if (element instanceof String) {
            return null;
        }
        return ImageManager.getImage((KeyedImage)ImageManager.MISSING);
    }

    public String getText(Object element) {
        String result = "";
        if (element != null) {
            if (element instanceof Match) {
                element = ((Match)element).getElement();
            }
            if (element instanceof IAtsObject) {
                IAtsObject artifact = (IAtsObject)element;
                ArrayList<String> extraInfo = new ArrayList<String>();
                String name = artifact.getName();
                extraInfo.add(name != null ? name : "");
                result = Collections.toString((String)" ", extraInfo);
            } else {
                result = element.toString();
            }
        }
        result = this.getAtsId(element, result);
        result = this.getActiveTag(element, result);
        return result;
    }

    private String getAtsId(Object element, String result) {
        if (this.showAtsId && element instanceof IAtsWorkItem) {
            IAtsWorkItem iAtsObject = (IAtsWorkItem)element;
            result = String.format("[%s] - %s", iAtsObject.getAtsId(), result);
        }
        return result;
    }

    private String getActiveTag(Object element, String result) {
        if (this.showActive && element instanceof IAtsConfigObject) {
            IAtsConfigObject iAtsObject = (IAtsConfigObject)element;
            result = String.format("%s (%s)", result, iAtsObject.isActive() ? "Active" : "InActive");
        }
        return result;
    }
}

