/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.operation;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.osee.ats.api.IAtsObject;
import org.eclipse.osee.ats.api.data.AtsAttributeTypes;
import org.eclipse.osee.ats.api.util.ExportChangeReportUtil;
import org.eclipse.osee.ats.api.workflow.IAtsTeamWorkflow;
import org.eclipse.osee.ats.ide.internal.AtsApiService;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactTypeId;
import org.eclipse.osee.framework.core.data.ArtifactTypeToken;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.BranchToken;
import org.eclipse.osee.framework.core.data.OseeData;
import org.eclipse.osee.framework.core.data.TransactionId;
import org.eclipse.osee.framework.core.data.TransactionToken;
import org.eclipse.osee.framework.core.enums.CoreArtifactTypes;
import org.eclipse.osee.framework.core.model.change.CompareData;
import org.eclipse.osee.framework.core.operation.AbstractOperation;
import org.eclipse.osee.framework.core.operation.IOperation;
import org.eclipse.osee.framework.core.operation.OperationLogger;
import org.eclipse.osee.framework.core.util.RendererOption;
import org.eclipse.osee.framework.jdk.core.type.Id;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.type.OseeStateException;
import org.eclipse.osee.framework.jdk.core.util.Lib;
import org.eclipse.osee.framework.skynet.core.artifact.Artifact;
import org.eclipse.osee.framework.skynet.core.artifact.BranchManager;
import org.eclipse.osee.framework.skynet.core.change.ArtifactChange;
import org.eclipse.osee.framework.skynet.core.change.ArtifactDelta;
import org.eclipse.osee.framework.skynet.core.change.Change;
import org.eclipse.osee.framework.skynet.core.revision.ChangeManager;
import org.eclipse.osee.framework.skynet.core.transaction.TransactionManager;
import org.eclipse.osee.framework.ui.skynet.render.RendererManager;
import org.eclipse.osee.framework.ui.skynet.render.compare.CompareDataCollector;

public final class ExportChangeReportOperation
extends AbstractOperation {
    private final List<IAtsTeamWorkflow> workflows;
    private final Appendable resultFolder;
    private final boolean reverse;
    private final boolean writeChangeReports;
    private final ArtifactTypeToken[] DISALLOW_TYPES = new ArtifactTypeToken[]{CoreArtifactTypes.ImplementationDetailsMsWord};
    private final String overrideDataRightsClassification;
    boolean debug = false;

    public ExportChangeReportOperation(List<IAtsTeamWorkflow> workflows, boolean reverse, boolean writeChangeReports, String overrideDataRightsClassification, Appendable resultFolder, OperationLogger logger) {
        super("Exporting Change Report(s)", "org.eclipse.osee.ats.ide", logger);
        this.workflows = workflows;
        this.reverse = reverse;
        this.writeChangeReports = writeChangeReports;
        this.overrideDataRightsClassification = overrideDataRightsClassification;
        this.resultFolder = resultFolder;
    }

    protected void doWork(IProgressMonitor monitor) {
        this.logf("Starting %s, processing %d workflows.", new Object[]{((Object)((Object)this)).getClass().getSimpleName(), this.workflows.size()});
        this.sortWorkflows();
        HashSet<String> skippedTypes = new HashSet<String>();
        CompareDataCollector collector = new CompareDataCollector(){

            public void onCompare(CompareData data) {
                String filePath = data.getOutputPath();
                String modifiedPath = filePath.substring(0, filePath.lastIndexOf(File.separator));
                try {
                    if (ExportChangeReportOperation.this.resultFolder.toString().isEmpty()) {
                        ExportChangeReportOperation.this.resultFolder.append(modifiedPath);
                    }
                }
                catch (IOException ex) {
                    OseeCoreException.wrapAndThrow((Throwable)ex);
                }
            }
        };
        for (IAtsTeamWorkflow workflow : this.workflows) {
            HashSet<ArtifactId> artIds;
            Collection<Change> changes = this.computeChanges(workflow, monitor, artIds = new HashSet<ArtifactId>());
            if (!changes.isEmpty() && changes.size() < 4000) {
                this.logf("Exporting: %s -- %s", new Object[]{workflow.toString(), workflow.getAtsId()});
                String id = workflow.getAtsId();
                String prefix = "/" + id;
                if (this.writeChangeReports) {
                    Collection artifactDeltas = ChangeManager.getCompareArtifacts(changes);
                    Iterator it = artifactDeltas.iterator();
                    while (it.hasNext()) {
                        ArtifactDelta next = (ArtifactDelta)it.next();
                        Artifact endArtifact = next.getEndArtifact();
                        if (!endArtifact.isOfType((ArtifactTypeId[])this.DISALLOW_TYPES) && endArtifact.isOfType((ArtifactTypeId[])ExportChangeReportUtil.ARTIFACT_ALLOW_TYPES)) continue;
                        it.remove();
                        artIds.remove(ArtifactId.create((Id)endArtifact));
                        if (this.debug) {
                            this.logf("skipping: [" + endArtifact.getName().replaceAll("%", "%%") + "] type: [" + endArtifact.getArtifactTypeName() + "] branch: [" + endArtifact.getBranch().getIdString() + "] artId: [" + endArtifact.getIdString() + "]", new Object[0]);
                        }
                        skippedTypes.add(endArtifact.getArtifactTypeName());
                    }
                    if (artifactDeltas.isEmpty()) {
                        this.logf("Nothing exported for Workflow[%s]", new Object[]{id});
                        continue;
                    }
                    HashMap<RendererOption, Object> rendererOptions = new HashMap<RendererOption, Object>();
                    rendererOptions.put(RendererOption.NO_DISPLAY, true);
                    rendererOptions.put(RendererOption.SKIP_DIALOGS, true);
                    rendererOptions.put(RendererOption.OVERRIDE_DATA_RIGHTS, this.overrideDataRightsClassification);
                    RendererManager.diff((CompareDataCollector)collector, (Collection)artifactDeltas, (String)prefix, rendererOptions);
                }
                String artIdsAsString = org.eclipse.osee.framework.jdk.core.util.Collections.toString((String)",", artIds);
                try {
                    if (this.resultFolder.toString().isEmpty()) {
                        IFolder folder = OseeData.getFolder((String)"ids");
                        File idsFolder = new File(folder.getLocationURI());
                        this.resultFolder.append(idsFolder.getAbsolutePath());
                    }
                    Lib.writeStringToFile((String)artIdsAsString, (File)new File(this.resultFolder + prefix + "_ids.txt"));
                }
                catch (IOException ex) {
                    OseeCoreException.wrapAndThrow((Throwable)ex);
                }
            }
            monitor.worked(this.calculateWork(0.5));
        }
        this.logf("-------- skipped types --------- ", new Object[0]);
        for (String skipped : skippedTypes) {
            this.logf(skipped, new Object[0]);
        }
    }

    private void sortWorkflows() {
        Collections.sort(this.workflows, new Comparator<IAtsTeamWorkflow>(){

            @Override
            public int compare(IAtsTeamWorkflow workflow1, IAtsTeamWorkflow workflow2) {
                try {
                    String atsId1 = (String)AtsApiService.get().getAttributeResolver().getSoleAttributeValue((IAtsObject)workflow1, (AttributeTypeToken)AtsAttributeTypes.AtsId, (Object)"");
                    String atsId2 = (String)AtsApiService.get().getAttributeResolver().getSoleAttributeValue((IAtsObject)workflow2, (AttributeTypeToken)AtsAttributeTypes.AtsId, (Object)"");
                    int compare = atsId1.compareTo(atsId2);
                    return ExportChangeReportOperation.this.reverse ? -1 * compare : compare;
                }
                catch (OseeCoreException oseeCoreException) {
                    return -1;
                }
            }
        });
    }

    private Collection<Change> computeChanges(IAtsTeamWorkflow teamWf, IProgressMonitor monitor, Set<ArtifactId> artIds) {
        ArrayList<Change> changes = new ArrayList<Change>();
        IOperation operation = null;
        if (AtsApiService.get().getBranchService().isCommittedBranchExists(teamWf)) {
            operation = ChangeManager.comparedToPreviousTx((TransactionToken)this.pickTransaction(teamWf), changes);
        } else {
            BranchToken workingBranch = AtsApiService.get().getBranchService().getWorkingBranch(teamWf);
            if (workingBranch != null && !BranchManager.getType((BranchId)workingBranch).isBaselineBranch()) {
                operation = ChangeManager.comparedToParent((BranchId)workingBranch, changes);
            }
        }
        if (operation != null) {
            this.doSubWork(operation, monitor, 0.5);
            Iterator iterator = changes.iterator();
            while (iterator.hasNext()) {
                Change change = (Change)iterator.next();
                if (!(change instanceof ArtifactChange)) {
                    iterator.remove();
                    continue;
                }
                artIds.add(change.getArtId());
            }
            Collections.sort(changes);
        }
        return changes;
    }

    private TransactionToken pickTransaction(IAtsTeamWorkflow workflow) {
        TransactionToken minTransactionId = TransactionToken.SENTINEL;
        for (TransactionToken transaction : TransactionManager.getCommittedArtifactTransactionIds((ArtifactId)AtsApiService.get().getQueryServiceIde().getArtifact(workflow))) {
            if (!minTransactionId.isOlderThan((TransactionId)transaction) || BranchManager.isArchived((BranchId)transaction.getBranch())) continue;
            minTransactionId = transaction;
        }
        if (!minTransactionId.isValid()) {
            throw new OseeStateException("no transaction records found for [%s]", new Object[]{workflow});
        }
        return minTransactionId;
    }
}

