/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.navigate;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import org.eclipse.osee.ats.ide.internal.Activator;
import org.eclipse.osee.ats.ide.internal.AtsApiService;
import org.eclipse.osee.framework.core.data.ArtifactTypeToken;
import org.eclipse.osee.framework.core.data.AttributeTypeId;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.BranchToken;
import org.eclipse.osee.framework.core.data.IUserGroupArtifactToken;
import org.eclipse.osee.framework.core.enums.CoreArtifactTypes;
import org.eclipse.osee.framework.core.enums.CoreAttributeTypes;
import org.eclipse.osee.framework.core.enums.CoreUserGroups;
import org.eclipse.osee.framework.core.enums.PresentationType;
import org.eclipse.osee.framework.core.exception.UserNotInDatabase;
import org.eclipse.osee.framework.jdk.core.result.XResultData;
import org.eclipse.osee.framework.jdk.core.util.Lib;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.framework.logging.OseeLevel;
import org.eclipse.osee.framework.logging.OseeLog;
import org.eclipse.osee.framework.skynet.core.artifact.Artifact;
import org.eclipse.osee.framework.skynet.core.artifact.ArtifactTypeManager;
import org.eclipse.osee.framework.skynet.core.transaction.SkynetTransaction;
import org.eclipse.osee.framework.skynet.core.transaction.TransactionManager;
import org.eclipse.osee.framework.ui.plugin.xnavigate.XNavItemCat;
import org.eclipse.osee.framework.ui.plugin.xnavigate.XNavigateComposite;
import org.eclipse.osee.framework.ui.plugin.xnavigate.XNavigateItem;
import org.eclipse.osee.framework.ui.plugin.xnavigate.XNavigateItemAction;
import org.eclipse.osee.framework.ui.skynet.FrameworkImage;
import org.eclipse.osee.framework.ui.skynet.artifact.massEditor.MassArtifactEditor;
import org.eclipse.osee.framework.ui.skynet.render.RendererManager;
import org.eclipse.osee.framework.ui.skynet.results.XResultDataUI;
import org.eclipse.osee.framework.ui.skynet.widgets.dialog.EntryDialog;
import org.eclipse.osee.framework.ui.swt.Displays;
import org.eclipse.osee.framework.ui.swt.ImageManager;
import org.eclipse.osee.framework.ui.swt.KeyedImage;
import org.eclipse.swt.graphics.Image;

public class CreateNewUsersByNameItem
extends XNavigateItemAction {
    public CreateNewUsersByNameItem() {
        super("Create New Users by Name (Testing Only)", (KeyedImage)FrameworkImage.USER, new XNavItemCat[]{XNavigateItem.USER_MANAGEMENT_ADMIN});
    }

    public void run(XNavigateComposite.TableLoadOption ... tableLoadOptions) {
        EntryDialog ed = new EntryDialog(Displays.getActiveShell(), "Create New User(s)", null, "Enter User name(s) one per line", 3, new String[]{"OK", "Cancel"}, 0);
        ed.setFillVertically(true);
        if (ed.open() == 0) {
            HashSet<String> newUserNames = new HashSet<String>();
            String[] stringArray = ed.getEntry().split(System.getProperty("line.separator"));
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String str = stringArray[n2];
                newUserNames.add(str);
                ++n2;
            }
            XResultData resultData = new XResultData(false);
            for (String newUserName : newUserNames) {
                if (!Strings.isValid((String)newUserName)) {
                    resultData.error("user name can't be blank");
                }
                try {
                    if (AtsApiService.get().getUserService().getUserByName(newUserName) == null) continue;
                    resultData.error(String.format("User [%s] already exists", newUserName));
                }
                catch (UserNotInDatabase userNotInDatabase) {}
            }
            if (!resultData.isEmpty()) {
                resultData.log("\nErrors found while creating users.\nPlease resolve and try again.");
                XResultDataUI.report((XResultData)resultData, (String)"Create New User(s) Error");
                return;
            }
            try {
                SkynetTransaction transaction = TransactionManager.createTransaction((BranchId)AtsApiService.get().getAtsBranch(), (String)"Create New User(s)");
                Set<Artifact> newUsers = this.createNewUserItemTx(transaction, newUserNames);
                transaction.execute();
                if (newUsers.size() == 1) {
                    RendererManager.open((Artifact)newUsers.iterator().next(), (PresentationType)PresentationType.DEFAULT_OPEN);
                } else {
                    MassArtifactEditor.editArtifacts((String)"New Users", newUsers, (XNavigateComposite.TableLoadOption[])new XNavigateComposite.TableLoadOption[]{XNavigateComposite.TableLoadOption.None});
                }
            }
            catch (Exception ex) {
                OseeLog.log(Activator.class, (Level)OseeLevel.SEVERE_POPUP, (Throwable)ex);
            }
        }
    }

    private Set<Artifact> createNewUserItemTx(SkynetTransaction transaction, Set<String> userNames) {
        HashSet<Artifact> newVersions = new HashSet<Artifact>();
        for (String userName : userNames) {
            Artifact userArt = ArtifactTypeManager.addArtifact((ArtifactTypeToken)CoreArtifactTypes.User, (BranchToken)AtsApiService.get().getAtsBranch(), (String)userName);
            userArt.setSoleAttributeValue((AttributeTypeId)CoreAttributeTypes.UserId, (Object)Lib.generateArtifactIdAsInt().toString());
            userArt.persist(transaction);
            newVersions.add(userArt);
        }
        return newVersions;
    }

    public Collection<IUserGroupArtifactToken> getUserGroups() {
        return Arrays.asList(CoreUserGroups.OseeAdmin);
    }

    public Image getImage() {
        return ImageManager.getImage((KeyedImage)FrameworkImage.USER_ADD);
    }
}

