/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.export;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.logging.Level;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.osee.ats.ide.export.AtsExportAction;
import org.eclipse.osee.ats.ide.internal.Activator;
import org.eclipse.osee.ats.ide.navigate.AtsNavigateViewItems;
import org.eclipse.osee.ats.ide.workflow.AbstractWorkflowArtifact;
import org.eclipse.osee.framework.core.operation.AbstractOperation;
import org.eclipse.osee.framework.core.operation.IOperation;
import org.eclipse.osee.framework.core.operation.OperationLogger;
import org.eclipse.osee.framework.core.util.Result;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.framework.logging.OseeLevel;
import org.eclipse.osee.framework.logging.OseeLog;
import org.eclipse.osee.framework.skynet.core.artifact.Artifact;
import org.eclipse.osee.framework.ui.plugin.xnavigate.XNavItemCat;
import org.eclipse.osee.framework.ui.skynet.FrameworkImage;
import org.eclipse.osee.framework.ui.skynet.blam.AbstractBlam;
import org.eclipse.osee.framework.ui.skynet.blam.BlamEditor;
import org.eclipse.osee.framework.ui.skynet.blam.VariableMap;
import org.eclipse.osee.framework.ui.skynet.widgets.XListDropViewer;
import org.eclipse.osee.framework.ui.skynet.widgets.XModifiedListener;
import org.eclipse.osee.framework.ui.skynet.widgets.XWidget;
import org.eclipse.osee.framework.ui.skynet.widgets.util.SwtXWidgetRenderer;
import org.eclipse.osee.framework.ui.swt.ImageManager;
import org.eclipse.osee.framework.ui.swt.KeyedImage;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class AtsExportBlam
extends AbstractBlam {
    public static final String INVALID_DIRECTORY = "Invalid Directory";
    public static final String MUST_SELECT_EXPORT_LOCATION = "Must select \"Export Location\" for \"" + (Object)((Object)AtsExportAction.ExportOption.AS_HTML_TO_FILE) + "\" or \"" + (Object)((Object)AtsExportAction.ExportOption.AS_PDF) + "\" options.";
    public static final String MUST_SELECT_MERGE_INTO_SINGLE_FILE_OR_SAVE_INTO_SEPARATE_FILES = "Must select \"MERGE_INTO_SINGLE_FILE\" or \"SAVE_INTO_SEPARATE_FILES\"";
    public static final String MUST_SELECT_AT_LEAST_ONE_EXPORT_AS_OPTION = "Must select at least one export AS_ option.";
    public static final String NO_ARTIFACTS_SELECTED = "No Artifacts selected.  Cancel wizard and try again.";
    public static final String ARTIFACTS = "Drag in ATS objects to export";
    public static final String EXPORT_LOCATION = "Export Location";
    private final Collection<AbstractWorkflowArtifact> defaultArtifacts;

    public AtsExportBlam(Collection<AbstractWorkflowArtifact> defaultArtifacts) {
        this.defaultArtifacts = defaultArtifacts;
    }

    public String getDescriptionUsage() {
        return "Export ATS objects to PDF or HTML.";
    }

    public String getXWidgetsXml() {
        StringBuilder sb = new StringBuilder();
        sb.append("<xWidgets>");
        sb.append("<XWidget xwidgetType=\"XListDropViewer\" displayName=\"");
        sb.append(ARTIFACTS);
        sb.append("\" />");
        ArrayList<AtsExportAction.ExportOption> validExportOptions = new ArrayList<AtsExportAction.ExportOption>();
        validExportOptions.addAll(Arrays.asList(AtsExportAction.ExportOption.values()));
        for (AtsExportAction.ExportOption exportOption : validExportOptions) {
            sb.append("<XWidget xwidgetType=\"XCheckBox\" displayName=\"");
            sb.append(exportOption.name());
            sb.append("\" labelAfter=\"true\" horizontalLabel=\"true\" />");
        }
        sb.append("<XWidget xwidgetType=\"XDirectorySelectionDialog\" displayName=\"");
        sb.append(EXPORT_LOCATION);
        sb.append("\" multiSelect=\"false\" />");
        sb.append("</xWidgets>");
        return sb.toString();
    }

    public Result isEntryValid(VariableMap variableMap) {
        List artifacts = variableMap.getArtifacts(ARTIFACTS);
        if (artifacts == null || artifacts.isEmpty()) {
            return new Result(NO_ARTIFACTS_SELECTED);
        }
        Collection<AtsExportAction.ExportOption> exportOtions = this.getExportOptions(variableMap);
        if (!(exportOtions.contains((Object)AtsExportAction.ExportOption.AS_HTML_TO_FILE) || exportOtions.contains((Object)AtsExportAction.ExportOption.AS_HTML_TO_RESULT_EDITOR) || exportOtions.contains((Object)AtsExportAction.ExportOption.AS_PDF))) {
            return new Result(MUST_SELECT_AT_LEAST_ONE_EXPORT_AS_OPTION);
        }
        if (!exportOtions.contains((Object)AtsExportAction.ExportOption.MERGE_INTO_SINGLE_FILE) && !exportOtions.contains((Object)AtsExportAction.ExportOption.SAVE_INTO_SEPARATE_FILES)) {
            return new Result(MUST_SELECT_MERGE_INTO_SINGLE_FILE_OR_SAVE_INTO_SEPARATE_FILES);
        }
        if (exportOtions.contains((Object)AtsExportAction.ExportOption.AS_HTML_TO_FILE) || exportOtions.contains((Object)AtsExportAction.ExportOption.AS_PDF)) {
            String fileSelection = variableMap.getString(EXPORT_LOCATION);
            if (!Strings.isValid((String)fileSelection)) {
                return new Result(MUST_SELECT_EXPORT_LOCATION);
            }
            if (!new File(fileSelection).isDirectory()) {
                return new Result(INVALID_DIRECTORY);
            }
        }
        return Result.TrueResult;
    }

    public void widgetCreated(XWidget xWidget, FormToolkit toolkit, Artifact art, SwtXWidgetRenderer dynamicXWidgetLayout, XModifiedListener modListener, boolean isEditable) {
        super.widgetCreated(xWidget, toolkit, art, dynamicXWidgetLayout, modListener, isEditable);
        if (xWidget.getLabel().equals(ARTIFACTS) && this.defaultArtifacts != null) {
            XListDropViewer viewer = (XListDropViewer)xWidget;
            viewer.setInput(this.defaultArtifacts);
        }
    }

    public Collection<AtsExportAction.ExportOption> getExportOptions(VariableMap variableMap) {
        ArrayList<AtsExportAction.ExportOption> options = new ArrayList<AtsExportAction.ExportOption>();
        AtsExportAction.ExportOption[] exportOptionArray = AtsExportAction.ExportOption.values();
        int n = exportOptionArray.length;
        int n2 = 0;
        while (n2 < n) {
            AtsExportAction.ExportOption exportOption = exportOptionArray[n2];
            boolean checked = variableMap.getBoolean(exportOption.name());
            if (checked) {
                options.add(exportOption);
            }
            ++n2;
        }
        return options;
    }

    public IOperation createOperation(final VariableMap variableMap, OperationLogger logger) throws Exception {
        Result result = this.isEntryValid(variableMap);
        if (result.isFalse()) {
            return null;
        }
        final Collection<AtsExportAction.ExportOption> exportOptions = this.getExportOptions(variableMap);
        AbstractOperation export = new AbstractOperation(this.getName(), "org.eclipse.osee.ats.ide"){

            protected void doWork(IProgressMonitor monitor) throws Exception {
                AtsExportAction exporter = new AtsExportAction();
                exporter.export(variableMap.getArtifacts(AtsExportBlam.ARTIFACTS), exportOptions, variableMap.getString(AtsExportBlam.EXPORT_LOCATION));
            }
        };
        return export;
    }

    public static void openAtsExportBlam(Collection<AbstractWorkflowArtifact> defaultArtifacts) {
        try {
            AtsExportBlam blam = new AtsExportBlam(defaultArtifacts);
            BlamEditor.edit((AbstractBlam)blam);
        }
        catch (OseeCoreException ex) {
            OseeLog.log(Activator.class, (Level)OseeLevel.SEVERE_POPUP, (Throwable)ex);
        }
    }

    public Collection<XNavItemCat> getCategories() {
        return Arrays.asList(AtsNavigateViewItems.ATS_UTIL);
    }

    public Image getImage() {
        return ImageManager.getImage((KeyedImage)FrameworkImage.EXPORT);
    }

    public ImageDescriptor getImageDescriptor() {
        return ImageManager.getImageDescriptor((KeyedImage)FrameworkImage.EXPORT);
    }
}

